/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.community.plugin.storedprocedures.deployed;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.io.PatternFilenameFilter;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.generic.ci.Folder;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@Metadata(virtual=true, description="Scripts in the folder are executed against a Container based on a naming convention")
@Placeholders
public class ExecutedFolder<D extends Folder>
extends AbstractDeployed<D>
implements DerivedArtifact<D> {
    private Map<String, Object> freeMarkerContext = Collections.singletonMap("deployed", this);
    @Property(required=false, category="Placeholders", description="A key/value pair mapping of placeholders in the deployed artifact to their values. Special values are <ignore> and <empty>")
    private Map<String, String> placeholders = Maps.newHashMap();
    private OverthereFile placeholderProcessedFile;
    @Property(description="Regular expression used to identify a script in the folder.  A successful match should returns a single group to which the rollbackScriptPostfix can be appended in order to find the associated rollback script or the script's dependent subfolder.  e.g.([0-9]*-.*)\\.sql")
    private String scriptRecognitionRegex;
    @Property(required=true)
    private List<String> folderSequence;
    @Property(description="Name of the executor script that will be executed for each script found in the folder.")
    private String executorScript;

    @Create
    public void executeCreate(DeploymentPlanningContext ctx, Delta delta) {
        File root = this.getDerivedArtifactAsFile();
        for (String sub : this.folderSequence) {
            ScriptExecutionStep step = null;
            for (File script : this.identifyAndOrderScriptsInFolder(new File(root, sub))) {
                step = ExecutedFolder.newScriptExecutionStep(script.getName(), this, this.getCreateOrder(), this.getCreateVerb());
                if (this.getCreateOptions().contains("uploadArtifactData")) {
                    step.setArtifact(script);
                }
                ctx.addStep((Step)step);
            }
            if (step == null) continue;
            ctx.addCheckpoint(step, delta, Operation.CREATE);
        }
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx, Delta delta) {
        File root = this.getDerivedArtifactAsFile();
        for (String sub : this.folderSequence) {
            ScriptExecutionStep step = null;
            for (File script : this.identifyAndOrderScriptsInFolder(new File(root, sub))) {
                step = ExecutedFolder.newScriptExecutionStep(script.getName(), this, this.getModifyOrder(), this.getModifyVerb());
                if (this.getModifyOptions().contains("uploadArtifactData")) {
                    step.setArtifact(script);
                }
                ctx.addStep((Step)step);
            }
            if (step == null) continue;
            ctx.addCheckpoint(step, delta, Operation.MODIFY);
        }
    }

    public String getDescription(String script, String verb) {
        return String.format("%s %s on %s", verb, script, ((HostContainer)this.getContainer()).getName());
    }

    protected static ScriptExecutionStep newScriptExecutionStep(String script, ExecutedFolder<?> deployed, int order, String verb) {
        return new ScriptExecutionStep(order, deployed.getExecutorScript(), (HostContainer)deployed.getContainer(), deployed.freeMarkerContext, deployed.getDescription(script, verb));
    }

    protected File getDerivedArtifactAsFile() {
        Preconditions.checkNotNull((Object)this.getFile(), (String)"%s has a null file property", (Object[])new Object[]{this});
        Preconditions.checkArgument((boolean)(this.getFile() instanceof LocalFile), (String)"%s has a file that is not a LocalFile but a %s", (Object[])new Object[]{this, this.getFile().getClass().getName()});
        LocalFile localFile = (LocalFile)this.getFile();
        return localFile.getFile();
    }

    protected List<File> identifyAndOrderScriptsInFolder(File folder) {
        List<File> scriptsToRun = this.findScriptsToRun(folder, this.getScriptRecognitionRegex());
        return Ordering.from((Comparator)new FilenameComparator()).sortedCopy(scriptsToRun);
    }

    protected List<File> findScriptsToRun(File folder, String pattern) {
        Object[] scriptsToRun = folder.listFiles((FilenameFilter)new PatternFilenameFilter(pattern));
        scriptsToRun = scriptsToRun == null ? new File[]{} : scriptsToRun;
        return Lists.newArrayList((Object[])scriptsToRun);
    }

    public D getSourceArtifact() {
        return (D)((Folder)this.getDeployable());
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public OverthereFile getFile() {
        return this.placeholderProcessedFile;
    }

    public void setFile(OverthereFile overthereFile) {
        this.placeholderProcessedFile = overthereFile;
    }

    public String getScriptRecognitionRegex() {
        return this.scriptRecognitionRegex;
    }

    public String getExecutorScript() {
        return this.resolveExpression(this.executorScript);
    }

    public void setExecutorScript(String executorScript) {
        this.executorScript = executorScript;
    }

    public static class FilenameComparator
    implements Comparator<File> {
        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

