/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt.api;

import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.profile.CertValidity;
import org.xipki.ca.server.mgmt.api.CaMgmtException;
import org.xipki.ca.server.mgmt.api.CaStatus;
import org.xipki.ca.server.mgmt.api.CmpControl;
import org.xipki.ca.server.mgmt.api.CrlControl;
import org.xipki.ca.server.mgmt.api.InternUtil;
import org.xipki.ca.server.mgmt.api.PermissionConstants;
import org.xipki.ca.server.mgmt.api.ProtocolSupport;
import org.xipki.ca.server.mgmt.api.ScepControl;
import org.xipki.ca.server.mgmt.api.ValidityMode;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.HashAlgo;
import org.xipki.security.KeyUsage;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.CollectionUtil;
import org.xipki.util.CompareUtil;
import org.xipki.util.ConfPairs;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;

public class CaEntry {
    private NameId ident;
    private CaStatus status;
    private CertValidity maxValidity;
    private String signerType;
    private String signerConf;
    private ScepControl scepControl;
    private CrlControl crlControl;
    private String crlSignerName;
    private CmpControl cmpControl;
    private String cmpResponderName;
    private String scepResponderName;
    private boolean duplicateKeyPermitted;
    private boolean duplicateSubjectPermitted;
    private ProtocolSupport protocolSupport;
    private boolean saveRequest;
    private ValidityMode validityMode = ValidityMode.STRICT;
    private int permission;
    private int expirationPeriod;
    private int keepExpiredCertInDays;
    private ConfPairs extraControl;
    private CaUris caUris;
    private X509Certificate cert;
    private int serialNoBitLen;
    private long nextCrlNumber;
    private int numCrls;
    private CertRevocationInfo revocationInfo;
    private String subject;
    private String hexSha1OfCert;

    public CaEntry(NameId ident, int serialNoBitLen, long nextCrlNumber, String signerType, String signerConf, CaUris caUris, int numCrls, int expirationPeriod) {
        this.ident = (NameId)ParamUtil.requireNonNull((String)"ident", (Object)ident);
        this.signerType = ParamUtil.requireNonBlankLower((String)"signerType", (String)signerType);
        this.expirationPeriod = ParamUtil.requireMin((String)"expirationPeriod", (int)expirationPeriod, (int)0);
        this.signerConf = ParamUtil.requireNonBlank((String)"signerConf", (String)signerConf);
        this.numCrls = ParamUtil.requireMin((String)"numCrls", (int)numCrls, (int)1);
        this.serialNoBitLen = ParamUtil.requireRange((String)"serialNoBitLen", (int)serialNoBitLen, (int)63, (int)159);
        this.nextCrlNumber = ParamUtil.requireMin((String)"nextCrlNumber", (long)nextCrlNumber, (long)1L);
        this.caUris = caUris == null ? CaUris.EMPTY_INSTANCE : caUris;
    }

    public static List<String[]> splitCaSignerConfs(String conf) throws XiSecurityException {
        ConfPairs pairs = new ConfPairs(conf);
        String str = pairs.value("algo");
        if (str == null) {
            throw new XiSecurityException("no algo is defined in CA signerConf");
        }
        List list = StringUtil.split((String)str, (String)":");
        if (CollectionUtil.isEmpty((Collection)list)) {
            throw new XiSecurityException("empty algo is defined in CA signerConf");
        }
        ArrayList<String[]> signerConfs = new ArrayList<String[]>(list.size());
        for (String n : list) {
            String c14nAlgo;
            try {
                c14nAlgo = AlgorithmUtil.canonicalizeSignatureAlgo((String)n);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new XiSecurityException(ex.getMessage(), (Throwable)ex);
            }
            pairs.putPair("algo", c14nAlgo);
            signerConfs.add(new String[]{c14nAlgo, pairs.getEncoded()});
        }
        return signerConfs;
    }

    public NameId getIdent() {
        return this.ident;
    }

    public CertValidity getMaxValidity() {
        return this.maxValidity;
    }

    public void setMaxValidity(CertValidity maxValidity) {
        this.maxValidity = maxValidity;
    }

    public int getKeepExpiredCertInDays() {
        return this.keepExpiredCertInDays;
    }

    public void setKeepExpiredCertInDays(int days) {
        this.keepExpiredCertInDays = days;
    }

    public void setSignerConf(String signerConf) {
        this.signerConf = ParamUtil.requireNonBlank((String)"signerConf", (String)signerConf);
    }

    public String getSignerConf() {
        return this.signerConf;
    }

    public CaStatus getStatus() {
        return this.status;
    }

    public void setStatus(CaStatus status) {
        this.status = status;
    }

    public String getSignerType() {
        return this.signerType;
    }

    public void setCmpControl(CmpControl cmpControl) {
        this.cmpControl = cmpControl;
    }

    public CmpControl getCmpControl() {
        return this.cmpControl;
    }

    public void setCrlControl(CrlControl crlControl) {
        this.crlControl = crlControl;
    }

    public CrlControl getCrlControl() {
        return this.crlControl;
    }

    public void setScepControl(ScepControl scepControl) {
        this.scepControl = scepControl;
    }

    public ScepControl getScepControl() {
        return this.scepControl;
    }

    public String getCmpResponderName() {
        return this.cmpResponderName;
    }

    public void setCmpResponderName(String cmpResponderName) {
        this.cmpResponderName = cmpResponderName == null ? null : cmpResponderName.toLowerCase();
    }

    public String getScepResponderName() {
        return this.scepResponderName;
    }

    public void setScepResponderName(String scepResponderName) {
        this.scepResponderName = scepResponderName == null ? null : scepResponderName.toLowerCase();
    }

    public String getCrlSignerName() {
        return this.crlSignerName;
    }

    public void setCrlSignerName(String crlSignerName) {
        this.crlSignerName = crlSignerName == null ? null : crlSignerName.toLowerCase();
    }

    public boolean isDuplicateKeyPermitted() {
        return this.duplicateKeyPermitted;
    }

    public void setDuplicateKeyPermitted(boolean duplicateKeyPermitted) {
        this.duplicateKeyPermitted = duplicateKeyPermitted;
    }

    public boolean isDuplicateSubjectPermitted() {
        return this.duplicateSubjectPermitted;
    }

    public void setDuplicateSubjectPermitted(boolean duplicateSubjectPermitted) {
        this.duplicateSubjectPermitted = duplicateSubjectPermitted;
    }

    public ProtocolSupport getProtocoSupport() {
        return this.protocolSupport;
    }

    public void setProtocolSupport(ProtocolSupport protocolSupport) {
        this.protocolSupport = protocolSupport;
    }

    public boolean isSaveRequest() {
        return this.saveRequest;
    }

    public void setSaveRequest(boolean saveRequest) {
        this.saveRequest = saveRequest;
    }

    public ValidityMode getValidityMode() {
        return this.validityMode;
    }

    public void setValidityMode(ValidityMode mode) {
        this.validityMode = (ValidityMode)((Object)ParamUtil.requireNonNull((String)"mode", (Object)((Object)mode)));
    }

    public int getPermission() {
        return this.permission;
    }

    public void setPermission(int permission) {
        this.permission = permission;
    }

    public int getExpirationPeriod() {
        return this.expirationPeriod;
    }

    public ConfPairs getExtraControl() {
        return this.extraControl;
    }

    public void setExtraControl(ConfPairs extraControl) {
        this.extraControl = extraControl;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        return this.toString(verbose, true);
    }

    public String toString(boolean verbose, boolean ignoreSensitiveInfo) {
        String extraCtrlText;
        if (this.extraControl == null) {
            extraCtrlText = "null";
        } else {
            extraCtrlText = this.extraControl.getEncoded();
            if (!verbose && extraCtrlText.length() > 100) {
                extraCtrlText = StringUtil.concat((String)extraCtrlText.substring(0, 97), (String[])new String[]{"..."});
            }
        }
        String revInfoText = "";
        if (this.revocationInfo != null) {
            revInfoText = StringUtil.concatObjectsCap((int)30, (Object)"\n\treason: ", (Object[])new Object[]{this.revocationInfo.getReason().getDescription(), "\n\trevoked at ", this.revocationInfo.getRevocationTime()});
        }
        return StringUtil.concatObjectsCap((int)1500, (Object)"id: ", (Object[])new Object[]{this.ident.getId(), "\nname: ", this.ident.getName(), "\nstatus: ", this.status == null ? "null" : this.status.getStatus(), "\nmax. validity: ", this.maxValidity, "\nexpiration period: ", this.expirationPeriod, " days", "\nsigner type: ", this.signerType, "\nsigner conf: ", this.signerConf == null ? "null" : InternUtil.signerConfToString(this.signerConf, verbose, ignoreSensitiveInfo), "\nCMP control:\n", this.cmpControl == null ? "  null" : this.cmpControl.toString(verbose), "\nCRL control:\n", this.crlControl == null ? "  null" : this.crlControl.toString(verbose), "\nSCEP control: \n", this.scepControl == null ? "  null" : this.scepControl.toString(verbose), "\nCMP responder name: ", this.cmpResponderName, "\nSCEP responder name: ", this.scepResponderName, "\nCRL signer name: ", this.crlSignerName, "\nduplicate key: ", this.duplicateKeyPermitted, "\nduplicate subject: ", this.duplicateSubjectPermitted, "\n", this.protocolSupport, "\nsave request: ", this.saveRequest, "\nvalidity mMode: ", this.validityMode, "\npermission: ", PermissionConstants.permissionToString(this.permission), "\nkeep expired certs: ", this.keepExpiredCertInDays < 0 ? "forever" : this.keepExpiredCertInDays + " days", "\nextra control: ", extraCtrlText, "\nserial number bit length: ", this.serialNoBitLen, "\nnext CRl number: ", this.nextCrlNumber, "\n", this.caUris, "\ncert: \n", InternUtil.formatCert(this.cert, verbose), "\nrevocation: ", this.revocationInfo == null ? "not revoked" : "revoked", revInfoText});
    }

    protected static String urisToString(Collection<? extends Object> tokens) {
        if (CollectionUtil.isEmpty(tokens)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int size = tokens.size();
        int idx = 0;
        for (Object object : tokens) {
            sb.append(object);
            if (idx++ >= size - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CaEntry)) {
            return false;
        }
        return this.equals((CaEntry)obj, false, false);
    }

    public boolean equals(CaEntry obj, boolean ignoreDynamicFields, boolean ignoreId) {
        if (!ignoreDynamicFields && this.nextCrlNumber != obj.nextCrlNumber) {
            return false;
        }
        return this.ident.equals(obj.ident, ignoreId) && this.signerType.equals(obj.signerType) && CompareUtil.equalsObject((Object)((Object)this.status), (Object)((Object)obj.status)) && CompareUtil.equalsObject((Object)this.protocolSupport, (Object)obj.protocolSupport) && CompareUtil.equalsObject((Object)this.maxValidity, (Object)obj.maxValidity) && CompareUtil.equalsObject((Object)this.cmpControl, (Object)obj.cmpControl) && CompareUtil.equalsObject((Object)this.crlControl, (Object)obj.crlControl) && CompareUtil.equalsObject((Object)this.scepControl, (Object)obj.scepControl) && CompareUtil.equalsObject((Object)this.cmpResponderName, (Object)obj.cmpResponderName) && CompareUtil.equalsObject((Object)this.scepResponderName, (Object)obj.scepResponderName) && CompareUtil.equalsObject((Object)this.crlSignerName, (Object)obj.crlSignerName) && this.duplicateKeyPermitted == obj.duplicateKeyPermitted && this.duplicateSubjectPermitted == obj.duplicateSubjectPermitted && this.saveRequest == obj.saveRequest && CompareUtil.equalsObject((Object)((Object)this.validityMode), (Object)((Object)obj.validityMode)) && this.permission == obj.permission && this.expirationPeriod == obj.expirationPeriod && this.keepExpiredCertInDays == obj.keepExpiredCertInDays && CompareUtil.equalsObject((Object)this.extraControl, (Object)obj.extraControl) && CompareUtil.equalsObject((Object)this.caUris, (Object)obj.caUris) && CompareUtil.equalsObject((Object)this.cert, (Object)obj.cert) && this.serialNoBitLen == obj.serialNoBitLen && this.numCrls == obj.numCrls && CompareUtil.equalsObject((Object)this.revocationInfo, (Object)obj.revocationInfo);
    }

    public int hashCode() {
        return this.ident.hashCode();
    }

    public void setCert(X509Certificate cert) throws CaMgmtException {
        if (cert == null) {
            this.cert = null;
            this.subject = null;
            this.hexSha1OfCert = null;
        } else {
            byte[] encodedCert;
            if (!X509Util.hasKeyusage((X509Certificate)cert, (KeyUsage)KeyUsage.keyCertSign)) {
                throw new CaMgmtException("CA certificate does not have keyusage keyCertSign");
            }
            this.cert = cert;
            this.subject = X509Util.getRfc4519Name((X500Principal)cert.getSubjectX500Principal());
            try {
                encodedCert = cert.getEncoded();
            }
            catch (CertificateEncodingException ex) {
                throw new CaMgmtException("could not encoded certificate", ex);
            }
            this.hexSha1OfCert = HashAlgo.SHA1.hexHash(encodedCert);
        }
    }

    public int getSerialNoBitLen() {
        return this.serialNoBitLen;
    }

    public void setSerialNoBitLen(int serialNoBitLen) {
        this.serialNoBitLen = ParamUtil.requireMin((String)"serialNoBitLen", (int)serialNoBitLen, (int)63);
    }

    public long getNextCrlNumber() {
        return this.nextCrlNumber;
    }

    public void setNextCrlNumber(long crlNumber) {
        this.nextCrlNumber = crlNumber;
    }

    public CaUris getCaUris() {
        return this.caUris;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public int getNumCrls() {
        return this.numCrls;
    }

    public CertRevocationInfo getRevocationInfo() {
        return this.revocationInfo;
    }

    public void setRevocationInfo(CertRevocationInfo revocationInfo) {
        this.revocationInfo = revocationInfo;
    }

    public Date getCrlBaseTime() {
        return this.cert == null ? null : this.cert.getNotBefore();
    }

    public String getSubject() {
        return this.subject;
    }

    public String getHexSha1OfCert() {
        return this.hexSha1OfCert;
    }
}

