/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt.api;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.ca.server.mgmt.api.AddUserEntry;
import org.xipki.ca.server.mgmt.api.CaEntry;
import org.xipki.ca.server.mgmt.api.CaHasRequestorEntry;
import org.xipki.ca.server.mgmt.api.CaHasUserEntry;
import org.xipki.ca.server.mgmt.api.CaMgmtException;
import org.xipki.ca.server.mgmt.api.CaSystemStatus;
import org.xipki.ca.server.mgmt.api.CertListInfo;
import org.xipki.ca.server.mgmt.api.CertListOrderBy;
import org.xipki.ca.server.mgmt.api.CertWithRevocationInfo;
import org.xipki.ca.server.mgmt.api.CertprofileEntry;
import org.xipki.ca.server.mgmt.api.ChangeCaEntry;
import org.xipki.ca.server.mgmt.api.ChangeUserEntry;
import org.xipki.ca.server.mgmt.api.PublisherEntry;
import org.xipki.ca.server.mgmt.api.RequestorEntry;
import org.xipki.ca.server.mgmt.api.SignerEntry;
import org.xipki.ca.server.mgmt.api.UserEntry;
import org.xipki.ca.server.mgmt.api.conf.CaConf;
import org.xipki.security.CertRevocationInfo;
import org.xipki.security.CrlReason;

public interface CaManager {
    public static final String NULL = "null";

    public CaSystemStatus getCaSystemStatus();

    public void unlockCa() throws CaMgmtException;

    public void notifyCaChange() throws CaMgmtException;

    public void republishCertificates(String var1, List<String> var2, int var3) throws CaMgmtException;

    public void clearPublishQueue(String var1, List<String> var2) throws CaMgmtException;

    public void removeCa(String var1) throws CaMgmtException;

    public void restartCaSystem() throws CaMgmtException;

    public void addCaAlias(String var1, String var2) throws CaMgmtException;

    public void removeCaAlias(String var1) throws CaMgmtException;

    public Set<String> getAliasesForCa(String var1);

    public String getCaNameForAlias(String var1);

    public Set<String> getCaAliasNames();

    public Set<String> getCertprofileNames();

    public Set<String> getPublisherNames();

    public Set<String> getRequestorNames();

    public Set<String> getSignerNames();

    public Set<String> getCaNames();

    public Set<String> getSuccessfulCaNames();

    public Set<String> getFailedCaNames();

    public Set<String> getInactiveCaNames();

    public void addCa(CaEntry var1) throws CaMgmtException;

    public CaEntry getCa(String var1);

    public void changeCa(ChangeCaEntry var1) throws CaMgmtException;

    public void removeCertprofileFromCa(String var1, String var2) throws CaMgmtException;

    public void addCertprofileToCa(String var1, String var2) throws CaMgmtException;

    public void removePublisherFromCa(String var1, String var2) throws CaMgmtException;

    public void addPublisherToCa(String var1, String var2) throws CaMgmtException;

    public Set<String> getCertprofilesForCa(String var1);

    public Set<CaHasRequestorEntry> getRequestorsForCa(String var1);

    public RequestorEntry getRequestor(String var1);

    public void addRequestor(RequestorEntry var1) throws CaMgmtException;

    public void removeRequestor(String var1) throws CaMgmtException;

    public void changeRequestor(String var1, String var2, String var3) throws CaMgmtException;

    public void removeRequestorFromCa(String var1, String var2) throws CaMgmtException;

    public void addRequestorToCa(CaHasRequestorEntry var1, String var2) throws CaMgmtException;

    public void removeUserFromCa(String var1, String var2) throws CaMgmtException;

    public void addUserToCa(CaHasUserEntry var1, String var2) throws CaMgmtException;

    public Map<String, CaHasUserEntry> getCaHasUsersForUser(String var1) throws CaMgmtException;

    public CertprofileEntry getCertprofile(String var1);

    public void removeCertprofile(String var1) throws CaMgmtException;

    public void changeCertprofile(String var1, String var2, String var3) throws CaMgmtException;

    public void addCertprofile(CertprofileEntry var1) throws CaMgmtException;

    public void addSigner(SignerEntry var1) throws CaMgmtException;

    public void removeSigner(String var1) throws CaMgmtException;

    public SignerEntry getSigner(String var1);

    public void changeSigner(String var1, String var2, String var3, String var4) throws CaMgmtException;

    public void addPublisher(PublisherEntry var1) throws CaMgmtException;

    public List<PublisherEntry> getPublishersForCa(String var1);

    public PublisherEntry getPublisher(String var1);

    public void removePublisher(String var1) throws CaMgmtException;

    public void changePublisher(String var1, String var2, String var3) throws CaMgmtException;

    public void revokeCa(String var1, CertRevocationInfo var2) throws CaMgmtException;

    public void unrevokeCa(String var1) throws CaMgmtException;

    public void revokeCertificate(String var1, BigInteger var2, CrlReason var3, Date var4) throws CaMgmtException;

    public void unrevokeCertificate(String var1, BigInteger var2) throws CaMgmtException;

    public void removeCertificate(String var1, BigInteger var2) throws CaMgmtException;

    public X509Certificate generateCertificate(String var1, String var2, byte[] var3, Date var4, Date var5) throws CaMgmtException;

    public X509Certificate generateRootCa(CaEntry var1, String var2, byte[] var3, BigInteger var4) throws CaMgmtException;

    public void addUser(AddUserEntry var1) throws CaMgmtException;

    public void changeUser(ChangeUserEntry var1) throws CaMgmtException;

    public void removeUser(String var1) throws CaMgmtException;

    public UserEntry getUser(String var1) throws CaMgmtException;

    public X509CRL generateCrlOnDemand(String var1) throws CaMgmtException;

    public X509CRL getCrl(String var1, BigInteger var2) throws CaMgmtException;

    public X509CRL getCurrentCrl(String var1) throws CaMgmtException;

    public CertWithRevocationInfo getCert(String var1, BigInteger var2) throws CaMgmtException;

    public CertWithRevocationInfo getCert(X500Name var1, BigInteger var2) throws CaMgmtException;

    public void loadConf(CaConf var1) throws CaMgmtException;

    public void exportConf(String var1, List<String> var2) throws CaMgmtException, IOException;

    public List<CertListInfo> listCertificates(String var1, X500Name var2, Date var3, Date var4, CertListOrderBy var5, int var6) throws CaMgmtException;

    public byte[] getCertRequest(String var1, BigInteger var2) throws CaMgmtException;

    public Set<String> getSupportedSignerTypes();

    public Set<String> getSupportedCertprofileTypes();

    public Set<String> getSupportedPublisherTypes();
}

