/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt.api;

import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.xipki.ca.api.NameId;
import org.xipki.security.util.X509Util;
import org.xipki.util.LogUtil;
import org.xipki.util.ParamUtil;

public class RequestorEntry {
    public static final String TYPE_CERT = "cert";
    public static final String TYPE_PBM = "pbm";
    private final NameId ident;
    private final String type;
    private final String conf;
    private boolean faulty;

    public RequestorEntry(NameId ident, String type, String conf) {
        this.ident = (NameId)ParamUtil.requireNonNull((String)"ident", (Object)ident);
        String name = ident.getName();
        if ("BY-USER".equalsIgnoreCase(name) || "BY-CA".equalsIgnoreCase(name)) {
            throw new IllegalArgumentException("Requestor name could not be " + name);
        }
        this.type = ParamUtil.requireNonBlank((String)"type", (String)type);
        this.conf = ParamUtil.requireNonBlank((String)"conf", (String)conf);
    }

    public NameId getIdent() {
        return this.ident;
    }

    public String getType() {
        return this.type;
    }

    public String getConf() {
        return this.conf;
    }

    public void setFaulty(boolean faulty) {
        this.faulty = faulty;
    }

    public boolean isFaulty() {
        return this.faulty;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        StringBuilder sb = new StringBuilder(500);
        sb.append("id: ").append(this.ident.getId());
        sb.append("\nname: ").append(this.ident.getName());
        sb.append("\ntype: ").append(this.type);
        sb.append("\nconf: ");
        if (verbose || this.conf.length() < 101) {
            sb.append(this.conf);
        } else {
            sb.append(this.conf.substring(0, 97)).append("...");
        }
        sb.append("\nfaulty: ").append(this.faulty).append('\n');
        if (!this.faulty && TYPE_CERT.equalsIgnoreCase(this.type)) {
            try {
                X509Certificate cert = X509Util.parseCert((byte[])this.conf.getBytes());
                sb.append("cert:");
                sb.append("\n\tissuer: ").append(X509Util.getRfc4519Name((X500Principal)cert.getIssuerX500Principal()));
                sb.append("\n\tserialNumber: ").append(LogUtil.formatCsn((BigInteger)cert.getSerialNumber()));
                sb.append("\n\tsubject: ").append(X509Util.getRfc4519Name((X500Principal)cert.getSubjectX500Principal())).append('\n');
            }
            catch (CertificateException ex) {
                sb.append("cert: ERROR(").append(ex.getMessage()).append(")\n");
            }
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RequestorEntry)) {
            return false;
        }
        return this.equals((RequestorEntry)obj, false);
    }

    public boolean equals(RequestorEntry obj, boolean ignoreId) {
        return obj != null && this.ident.equals(obj.ident, ignoreId) && this.type.equals(obj.type) && this.conf.equals(obj.conf);
    }

    public int hashCode() {
        return this.ident.hashCode();
    }
}

