/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.ca.server.mgmt.api.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.ca.api.CaUris;
import org.xipki.ca.api.NameId;
import org.xipki.ca.api.profile.CertValidity;
import org.xipki.ca.server.mgmt.api.AddUserEntry;
import org.xipki.ca.server.mgmt.api.CaEntry;
import org.xipki.ca.server.mgmt.api.CaHasRequestorEntry;
import org.xipki.ca.server.mgmt.api.CaHasUserEntry;
import org.xipki.ca.server.mgmt.api.CaMgmtException;
import org.xipki.ca.server.mgmt.api.CaStatus;
import org.xipki.ca.server.mgmt.api.CertprofileEntry;
import org.xipki.ca.server.mgmt.api.CmpControl;
import org.xipki.ca.server.mgmt.api.CrlControl;
import org.xipki.ca.server.mgmt.api.PermissionConstants;
import org.xipki.ca.server.mgmt.api.ProtocolSupport;
import org.xipki.ca.server.mgmt.api.PublisherEntry;
import org.xipki.ca.server.mgmt.api.RequestorEntry;
import org.xipki.ca.server.mgmt.api.ScepControl;
import org.xipki.ca.server.mgmt.api.SignerEntry;
import org.xipki.ca.server.mgmt.api.UserEntry;
import org.xipki.ca.server.mgmt.api.ValidityMode;
import org.xipki.ca.server.mgmt.api.conf.GenSelfIssued;
import org.xipki.ca.server.mgmt.api.conf.SingleCaConf;
import org.xipki.ca.server.mgmt.api.conf.jaxb.CaHasRequestorType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.CaHasUserType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.CaInfoType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.CaType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.CaUrisType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.CaconfType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.FileOrBinaryType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.FileOrValueType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.NameValueType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.ObjectFactory;
import org.xipki.ca.server.mgmt.api.conf.jaxb.PermissionsType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.ProfileType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.PublisherType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.RequestorType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.SignerType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.UrisType;
import org.xipki.ca.server.mgmt.api.conf.jaxb.UserType;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.util.X509Util;
import org.xipki.util.Base64;
import org.xipki.util.ConfPairs;
import org.xipki.util.InvalidConfException;
import org.xipki.util.IoUtil;
import org.xipki.util.ObjectCreationException;
import org.xipki.util.ParamUtil;
import org.xipki.util.StringUtil;
import org.xipki.util.XmlUtil;
import org.xml.sax.SAXException;

public class CaConf {
    private static final Logger LOG = LoggerFactory.getLogger(CaConf.class);
    private static final String APP_DIR = "APP_DIR";
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, SignerEntry> signers = new HashMap<String, SignerEntry>();
    private final Map<String, RequestorEntry> requestors = new HashMap<String, RequestorEntry>();
    private final Map<String, Object> users = new HashMap<String, Object>();
    private final Map<String, PublisherEntry> publishers = new HashMap<String, PublisherEntry>();
    private final Map<String, CertprofileEntry> certprofiles = new HashMap<String, CertprofileEntry>();
    private final Map<String, SingleCaConf> cas = new HashMap<String, SingleCaConf>();
    private String baseDir;

    public CaConf(String confFilename, SecurityFactory securityFactory) throws IOException, InvalidConfException, CaMgmtException, JAXBException, SAXException {
        ParamUtil.requireNonNull((String)"confFilename", (Object)confFilename);
        ParamUtil.requireNonNull((String)"securityFactory", (Object)securityFactory);
        this.init(new File(confFilename), securityFactory);
    }

    public CaConf(File confFile, SecurityFactory securityFactory) throws IOException, InvalidConfException, CaMgmtException, JAXBException, SAXException {
        ParamUtil.requireNonNull((String)"confFile", (Object)confFile);
        ParamUtil.requireNonNull((String)"securityFactory", (Object)securityFactory);
        this.init(confFile, securityFactory);
    }

    public static void marshal(CaconfType jaxb, OutputStream out) throws JAXBException, SAXException {
        ParamUtil.requireNonNull((String)"jaxb", (Object)jaxb);
        ParamUtil.requireNonNull((String)"out", (Object)out);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            SchemaFactory schemaFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = CaConf.class.getResource("/xsd/caconf.xsd");
            Marshaller jaxbMarshaller = context.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            jaxbMarshaller.setProperty("com.sun.xml.internal.bind.indentString", (Object)"  ");
            jaxbMarshaller.setSchema(schemaFact.newSchema(url));
            jaxbMarshaller.marshal(new ObjectFactory().createCaconf(jaxb), out);
        }
        catch (JAXBException ex) {
            throw XmlUtil.convert((JAXBException)ex);
        }
    }

    private void init(File confFile, SecurityFactory securityFactory) throws IOException, InvalidConfException, CaMgmtException, JAXBException, SAXException {
        confFile = IoUtil.expandFilepath((File)confFile);
        String confFilename = confFile.getName();
        int fileExtIndex = confFilename.lastIndexOf(46);
        String fileExt = null;
        if (fileExtIndex != -1) {
            fileExt = confFilename.substring(fileExtIndex + 1);
        }
        ZipFile zipFile = null;
        InputStream caConfStream = null;
        try {
            if ("xml".equalsIgnoreCase(fileExt)) {
                LOG.info("read the configuration file {} as an XML file", (Object)confFilename);
                caConfStream = new FileInputStream(confFile);
            } else if ("zip".equalsIgnoreCase(fileExt)) {
                LOG.info("read the configuration file {} as a ZIP file", (Object)confFilename);
                zipFile = new ZipFile(confFile);
                caConfStream = zipFile.getInputStream(zipFile.getEntry("caconf.xml"));
            } else {
                try {
                    LOG.info("try to read the configuration file {} as a ZIP file", (Object)confFilename);
                    zipFile = new ZipFile(confFile);
                    caConfStream = zipFile.getInputStream(zipFile.getEntry("caconf.xml"));
                }
                catch (ZipException ex) {
                    LOG.info("the configuration file {} is not a ZIP file, try as an XML file", (Object)confFilename);
                    zipFile = null;
                    caConfStream = new FileInputStream(confFile);
                }
            }
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            SchemaFactory schemaFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = CaConf.class.getResource("/xsd/caconf.xsd");
            Unmarshaller jaxbUnmarshaller = context.createUnmarshaller();
            jaxbUnmarshaller.setSchema(schemaFact.newSchema(url));
            CaconfType root = (CaconfType)((JAXBElement)jaxbUnmarshaller.unmarshal(caConfStream)).getValue();
            if (zipFile == null) {
                this.baseDir = root.getBasedir();
                if (StringUtil.isBlank((String)this.baseDir)) {
                    File confFileParent = confFile.getParentFile();
                    this.baseDir = confFileParent == null ? "." : confFileParent.getPath();
                } else if (APP_DIR.equalsIgnoreCase(this.baseDir)) {
                    this.baseDir = ".";
                }
            }
            this.init(root, zipFile, securityFactory);
        }
        catch (JAXBException ex) {
            throw XmlUtil.convert((JAXBException)ex);
        }
        finally {
            if (caConfStream != null) {
                try {
                    caConfStream.close();
                }
                catch (IOException ex) {
                    LOG.info("could not clonse caConfStream", (Object)ex.getMessage());
                }
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ex) {
                    LOG.info("could not clonse zipFile", (Object)ex.getMessage());
                }
            }
        }
    }

    private void init(CaconfType jaxb, ZipFile zipFile, SecurityFactory securityFactory) throws IOException, InvalidConfException, CaMgmtException {
        if (jaxb.getProperties() != null) {
            for (NameValueType nameValueType : jaxb.getProperties().getProperty()) {
                String name = nameValueType.getName();
                if (this.properties.containsKey(name)) {
                    throw new InvalidConfException("Property " + name + " already defined");
                }
                this.properties.put(name, nameValueType.getValue());
            }
        }
        if (jaxb.getSigners() != null) {
            for (SignerType signerType : jaxb.getSigners().getSigner()) {
                SignerEntry en = new SignerEntry(signerType.getName(), this.expandConf(signerType.getType()), this.getValue(signerType.getConf(), zipFile), this.getBase64Binary(signerType.getCert(), zipFile));
                this.addSigner(en);
            }
        }
        if (jaxb.getRequestors() != null) {
            for (RequestorType requestorType : jaxb.getRequestors().getRequestor()) {
                String conf = requestorType.getConf() != null ? this.getValue(requestorType.getConf(), zipFile) : this.getBase64Binary(requestorType.getBinaryConf(), zipFile);
                RequestorEntry en = new RequestorEntry(new NameId(null, requestorType.getName()), requestorType.getType(), conf);
                this.addRequestor(en);
            }
        }
        if (jaxb.getUsers() != null) {
            for (UserType userType : jaxb.getUsers().getUser()) {
                Object en;
                boolean active = userType.isActive() != null ? userType.isActive() : true;
                String password = userType.getPassword();
                if (password != null) {
                    en = new AddUserEntry(new NameId(null, userType.getName()), active, password);
                    this.addUser((AddUserEntry)en);
                    continue;
                }
                en = new UserEntry(new NameId(null, userType.getName()), active, userType.getHashedPassword());
                this.addUser((UserEntry)en);
            }
        }
        if (jaxb.getPublishers() != null) {
            for (PublisherType publisherType : jaxb.getPublishers().getPublisher()) {
                PublisherEntry en = new PublisherEntry(new NameId(null, publisherType.getName()), this.expandConf(publisherType.getType()), this.getValue(publisherType.getConf(), zipFile));
                this.addPublisher(en);
            }
        }
        if (jaxb.getProfiles() != null) {
            for (ProfileType profileType : jaxb.getProfiles().getProfile()) {
                CertprofileEntry en = new CertprofileEntry(new NameId(null, profileType.getName()), this.expandConf(profileType.getType()), this.getValue(profileType.getConf(), zipFile));
                this.addProfile(en);
            }
        }
        if (jaxb.getCas() != null) {
            for (CaType caType : jaxb.getCas().getCa()) {
                String name = caType.getName();
                GenSelfIssued genSelfIssued = null;
                CaEntry caEntry = null;
                if (caType.getCaInfo() != null) {
                    String value;
                    Object caUris;
                    CaInfoType ci = caType.getCaInfo();
                    if (ci.getGenSelfIssued() != null) {
                        String certFilename = null;
                        if (ci.getCert() != null) {
                            if (ci.getCert().getFile() != null) {
                                certFilename = this.expandConf(ci.getCert().getFile());
                                certFilename = this.resolveFilePath(certFilename);
                            } else {
                                throw new InvalidConfException("cert.file of CA " + name + " must not be null");
                            }
                        }
                        byte[] csr = this.getBinary(ci.getGenSelfIssued().getCsr(), zipFile);
                        BigInteger serialNumber = null;
                        String str = ci.getGenSelfIssued().getSerialNumber();
                        if (str != null) {
                            serialNumber = str.startsWith("0x") || str.startsWith("0X") ? new BigInteger(str.substring(2), 16) : new BigInteger(str);
                        }
                        genSelfIssued = new GenSelfIssued(ci.getGenSelfIssued().getProfile(), csr, serialNumber, certFilename, ci.getGenSelfIssued().getCertOutform());
                    }
                    if (ci.getCaUris() == null) {
                        caUris = CaUris.EMPTY_INSTANCE;
                    } else {
                        CaUrisType uris = ci.getCaUris();
                        caUris = new CaUris(this.getUris(uris.getCacertUris()), this.getUris(uris.getOcspUris()), this.getUris(uris.getCrlUris()), this.getUris(uris.getDeltacrlUris()));
                    }
                    int exprirationPeriod = ci.getExpirationPeriod() == null ? 365 : ci.getExpirationPeriod();
                    int numCrls = ci.getNumCrls() == null ? 30 : ci.getNumCrls();
                    caEntry = new CaEntry(new NameId(null, name), ci.getSnSize(), ci.getNextCrlNo(), this.expandConf(ci.getSignerType()), this.getValue(ci.getSignerConf(), zipFile), (CaUris)caUris, numCrls, exprirationPeriod);
                    if (ci.getCmpControl() != null) {
                        caEntry.setCmpControl(new CmpControl(ci.getCmpControl()));
                    }
                    if (ci.getCrlControl() != null) {
                        caEntry.setCrlControl(new CrlControl(ci.getCrlControl()));
                    }
                    if (ci.getScepControl() != null) {
                        caEntry.setScepControl(new ScepControl(ci.getScepControl()));
                    }
                    caEntry.setCmpResponderName(ci.getCmpResponderName());
                    caEntry.setScepResponderName(ci.getScepResponderName());
                    caEntry.setCrlSignerName(ci.getCrlSignerName());
                    caEntry.setDuplicateKeyPermitted(ci.isDuplicateKey());
                    caEntry.setDuplicateSubjectPermitted(ci.isDuplicateSubject());
                    if (ci.getExtraControl() != null && (value = this.getValue(ci.getExtraControl(), zipFile)) != null) {
                        caEntry.setExtraControl(new ConfPairs(value).unmodifiable());
                    }
                    int keepExpiredCertDays = ci.getKeepExpiredCertDays() == null ? -1 : ci.getKeepExpiredCertDays();
                    caEntry.setKeepExpiredCertInDays(keepExpiredCertDays);
                    caEntry.setMaxValidity(CertValidity.getInstance((String)ci.getMaxValidity()));
                    caEntry.setPermission(CaConf.getIntPermission(ci.getPermissions()));
                    if (ci.getProtocolSupport() != null) {
                        caEntry.setProtocolSupport(new ProtocolSupport(ci.getProtocolSupport()));
                    }
                    caEntry.setSaveRequest(ci.isSaveReq());
                    caEntry.setStatus(CaStatus.forName(ci.getStatus()));
                    if (ci.getValidityMode() != null) {
                        caEntry.setValidityMode(ValidityMode.forName(ci.getValidityMode()));
                    }
                    if (ci.getGenSelfIssued() == null) {
                        ConcurrentContentSigner signer;
                        X509Certificate caCert;
                        if (ci.getCert() != null) {
                            byte[] bytes = this.getBinary(ci.getCert(), zipFile);
                            try {
                                caCert = X509Util.parseCert((byte[])bytes);
                            }
                            catch (CertificateException ex) {
                                throw new InvalidConfException("invalid certificate of CA " + name, (Throwable)ex);
                            }
                        }
                        try {
                            List<String[]> signerConfs = CaEntry.splitCaSignerConfs(this.getValue(ci.getSignerConf(), zipFile));
                            SignerConf signerConf = new SignerConf(signerConfs.get(0)[1]);
                            signer = securityFactory.createSigner(this.expandConf(ci.getSignerType()), signerConf, (X509Certificate)null);
                        }
                        catch (XiSecurityException | ObjectCreationException ex) {
                            throw new InvalidConfException("could not create CA signer for CA " + name, ex);
                        }
                        caCert = signer.getCertificate();
                        caEntry.setCert(caCert);
                    }
                }
                LinkedList<CaHasRequestorEntry> caHasRequestors = null;
                if (caType.getRequestors() != null) {
                    caHasRequestors = new LinkedList<CaHasRequestorEntry>();
                    for (CaHasRequestorType req : caType.getRequestors().getRequestor()) {
                        CaHasRequestorEntry en = new CaHasRequestorEntry(new NameId(null, req.getRequestorName()));
                        en.setRa(req.isRa());
                        if (req.getProfiles() != null && !req.getProfiles().getProfile().isEmpty()) {
                            en.setProfiles(new HashSet<String>(req.getProfiles().getProfile()));
                        }
                        en.setPermission(CaConf.getIntPermission(req.getPermissions()));
                        caHasRequestors.add(en);
                    }
                }
                LinkedList<CaHasUserEntry> caHasUsers = null;
                if (caType.getUsers() != null) {
                    caHasUsers = new LinkedList<CaHasUserEntry>();
                    for (CaHasUserType req : caType.getUsers().getUser()) {
                        CaHasUserEntry en = new CaHasUserEntry(new NameId(null, req.getUserName()));
                        en.setPermission(CaConf.getIntPermission(req.getPermissions()));
                        if (req.getProfiles() != null && !req.getProfiles().getProfile().isEmpty()) {
                            en.setProfiles(new HashSet<String>(req.getProfiles().getProfile()));
                        }
                        caHasUsers.add(en);
                    }
                }
                List<String> aliases = null;
                if (caType.getAliases() != null && !caType.getAliases().getAlias().isEmpty()) {
                    aliases = caType.getAliases().getAlias();
                }
                List<String> profileNames = null;
                if (caType.getProfiles() != null && !caType.getProfiles().getProfile().isEmpty()) {
                    profileNames = caType.getProfiles().getProfile();
                }
                List<String> publisherNames = null;
                if (caType.getPublishers() != null && !caType.getPublishers().getPublisher().isEmpty()) {
                    publisherNames = caType.getPublishers().getPublisher();
                }
                SingleCaConf singleCa = new SingleCaConf(name, genSelfIssued, caEntry, aliases, profileNames, caHasRequestors, caHasUsers, publisherNames);
                this.addSingleCa(singleCa);
            }
        }
    }

    public void addSigner(SignerEntry signer) {
        ParamUtil.requireNonNull((String)"signer", (Object)signer);
        this.signers.put(signer.getName(), signer);
    }

    public Set<String> getSignerNames() {
        return Collections.unmodifiableSet(this.signers.keySet());
    }

    public SignerEntry getSigner(String name) {
        return this.signers.get(ParamUtil.requireNonNull((String)"name", (Object)name));
    }

    public void addRequestor(RequestorEntry requestor) {
        ParamUtil.requireNonNull((String)"requestor", (Object)requestor);
        this.requestors.put(requestor.getIdent().getName(), requestor);
    }

    public void addUser(UserEntry user) {
        ParamUtil.requireNonNull((String)"user", (Object)user);
        this.users.put(user.getIdent().getName(), user);
    }

    public void addUser(AddUserEntry user) {
        ParamUtil.requireNonNull((String)"user", (Object)user);
        this.users.put(user.getIdent().getName(), user);
    }

    public Set<String> getRequestorNames() {
        return Collections.unmodifiableSet(this.requestors.keySet());
    }

    public RequestorEntry getRequestor(String name) {
        return this.requestors.get(ParamUtil.requireNonNull((String)"name", (Object)name));
    }

    public Set<String> getUserNames() {
        return Collections.unmodifiableSet(this.users.keySet());
    }

    public Object getUser(String name) {
        return this.users.get(ParamUtil.requireNonNull((String)"name", (Object)name));
    }

    public void addPublisher(PublisherEntry publisher) {
        ParamUtil.requireNonNull((String)"publisher", (Object)publisher);
        this.publishers.put(publisher.getIdent().getName(), publisher);
    }

    public Set<String> getPublisherNames() {
        return Collections.unmodifiableSet(this.publishers.keySet());
    }

    public PublisherEntry getPublisher(String name) {
        return this.publishers.get(ParamUtil.requireNonNull((String)"name", (Object)name));
    }

    public void addProfile(CertprofileEntry profile) {
        ParamUtil.requireNonNull((String)"profile", (Object)profile);
        this.certprofiles.put(profile.getIdent().getName(), profile);
    }

    public Set<String> getCertprofileNames() {
        return Collections.unmodifiableSet(this.certprofiles.keySet());
    }

    public CertprofileEntry getCertprofile(String name) {
        return this.certprofiles.get(ParamUtil.requireNonNull((String)"name", (Object)name));
    }

    public void addSingleCa(SingleCaConf singleCa) {
        ParamUtil.requireNonNull((String)"singleCa", (Object)singleCa);
        this.cas.put(singleCa.getName(), singleCa);
    }

    public Set<String> getCaNames() {
        return Collections.unmodifiableSet(this.cas.keySet());
    }

    public SingleCaConf getCa(String name) {
        return this.cas.get(ParamUtil.requireNonNull((String)"name", (Object)name));
    }

    private String getValue(FileOrValueType fileOrValue, ZipFile zipFile) throws IOException {
        InputStream is;
        if (fileOrValue == null) {
            return null;
        }
        if (fileOrValue.getValue() != null) {
            return this.expandConf(fileOrValue.getValue());
        }
        String fileName = this.expandConf(fileOrValue.getFile());
        if (zipFile != null) {
            is = zipFile.getInputStream(new ZipEntry(fileName));
            if (is == null) {
                throw new IOException("could not find ZIP entry " + fileName);
            }
        } else {
            is = new FileInputStream(this.resolveFilePath(fileName));
        }
        byte[] binary = IoUtil.read((InputStream)is);
        return this.expandConf(new String(binary, "UTF-8"));
    }

    private String getBase64Binary(FileOrBinaryType fileOrBinary, ZipFile zipFile) throws IOException {
        byte[] binary = this.getBinary(fileOrBinary, zipFile);
        return binary == null ? null : Base64.encodeToString((byte[])binary);
    }

    private byte[] getBinary(FileOrBinaryType fileOrBinary, ZipFile zipFile) throws IOException {
        InputStream is;
        if (fileOrBinary == null) {
            return null;
        }
        if (fileOrBinary.getBinary() != null) {
            return fileOrBinary.getBinary();
        }
        String fileName = this.expandConf(fileOrBinary.getFile());
        if (zipFile != null) {
            is = zipFile.getInputStream(new ZipEntry(fileName));
            if (is == null) {
                throw new IOException("could not find ZIP entry " + fileName);
            }
        } else {
            is = new FileInputStream(this.resolveFilePath(fileName));
        }
        return IoUtil.read((InputStream)is);
    }

    private List<String> getUris(UrisType jaxb) {
        if (jaxb == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>(jaxb.getUri().size());
        for (String m : jaxb.getUri()) {
            ret.add(this.expandConf(m));
        }
        return ret;
    }

    private String expandConf(String confStr) {
        if (confStr == null || !confStr.contains("${") || confStr.indexOf(125) == -1) {
            return confStr;
        }
        for (String name : this.properties.keySet()) {
            String placeHolder = "${" + name + "}";
            while (confStr.contains(placeHolder)) {
                confStr = confStr.replace(placeHolder, this.properties.get(name));
            }
        }
        return confStr;
    }

    private String resolveFilePath(String filePath) {
        File file = new File(filePath);
        return file.isAbsolute() ? filePath : new File(this.baseDir, filePath).getPath();
    }

    private static int getIntPermission(PermissionsType type) throws InvalidConfException {
        int ret = 0;
        for (String permission : type.getPermission()) {
            Integer ii = PermissionConstants.getPermissionForText(permission);
            if (ii == null) {
                throw new InvalidConfException("invalid permission " + type);
            }
            ret |= ii.intValue();
        }
        return ret;
    }
}

