/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.stream.ExecuteStreamHandler;
import org.zeroturnaround.exec.stream.InputStreamPumper;
import org.zeroturnaround.exec.stream.StreamPumper;

public class PumpStreamHandler
implements ExecuteStreamHandler {
    private static final Logger log = LoggerFactory.getLogger(PumpStreamHandler.class);
    private Thread outputThread;
    private Thread errorThread;
    private Thread inputThread;
    private final OutputStream out;
    private final OutputStream err;
    private final InputStream input;
    private InputStreamPumper inputStreamPumper;

    public PumpStreamHandler() {
        this(System.out, System.err);
    }

    public PumpStreamHandler(OutputStream outAndErr) {
        this(outAndErr, outAndErr);
    }

    public PumpStreamHandler(OutputStream out, OutputStream err) {
        this(out, err, null);
    }

    public PumpStreamHandler(OutputStream out, OutputStream err, InputStream input) {
        this.out = out;
        this.err = err;
        this.input = input;
    }

    public void setProcessOutputStream(InputStream is) {
        if (this.out != null) {
            this.createProcessOutputPump(is, this.out);
        }
    }

    public void setProcessErrorStream(InputStream is) {
        if (this.err != null) {
            this.createProcessErrorPump(is, this.err);
        }
    }

    public void setProcessInputStream(OutputStream os) {
        if (this.input != null) {
            this.inputThread = this.input == System.in ? this.createSystemInPump(this.input, os) : this.createPump(this.input, os, true);
        } else {
            try {
                os.close();
            }
            catch (IOException e) {
                log.info("Got exception while closing output stream", (Throwable)e);
            }
        }
    }

    public void start() {
        if (this.outputThread != null) {
            this.outputThread.start();
        }
        if (this.errorThread != null) {
            this.errorThread.start();
        }
        if (this.inputThread != null) {
            this.inputThread.start();
        }
    }

    public void stop() {
        if (this.inputStreamPumper != null) {
            this.inputStreamPumper.stopProcessing();
        }
        if (this.inputThread != null) {
            log.trace("Joining input thread {}...", (Object)this.inputThread);
            try {
                this.inputThread.join();
                this.inputThread = null;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.outputThread != null) {
            log.trace("Joining output thread {}...", (Object)this.outputThread);
            try {
                this.outputThread.join();
                this.outputThread = null;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.errorThread != null) {
            log.trace("Joining error thread {}...", (Object)this.errorThread);
            try {
                this.errorThread.join();
                this.errorThread = null;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.flush();
    }

    public void flush() {
        if (this.out != null) {
            log.trace("Flushing output stream {}...", (Object)this.out);
            try {
                this.out.flush();
            }
            catch (IOException e) {
                log.error("Got exception while flushing the output stream", (Throwable)e);
            }
        }
        if (this.err != null && this.err != this.out) {
            log.trace("Flushing error stream {}...", (Object)this.err);
            try {
                this.err.flush();
            }
            catch (IOException e) {
                log.error("Got exception while flushing the error stream", (Throwable)e);
            }
        }
    }

    public OutputStream getOut() {
        return this.out;
    }

    public OutputStream getErr() {
        return this.err;
    }

    public InputStream getInput() {
        return this.input;
    }

    protected void createProcessOutputPump(InputStream is, OutputStream os) {
        this.outputThread = this.createPump(is, os);
    }

    protected void createProcessErrorPump(InputStream is, OutputStream os) {
        this.errorThread = this.createPump(is, os);
    }

    protected Thread createPump(InputStream is, OutputStream os) {
        return this.createPump(is, os, false);
    }

    protected Thread createPump(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        Thread result = new Thread(new StreamPumper(is, os, closeWhenExhausted));
        result.setDaemon(true);
        return result;
    }

    private Thread createSystemInPump(InputStream is, OutputStream os) {
        this.inputStreamPumper = new InputStreamPumper(is, os);
        Thread result = new Thread(this.inputStreamPumper);
        result.setDaemon(true);
        return result;
    }
}

