/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal.parameters.toarray;

import java.util.ArrayList;
import java.util.Iterator;
import junitparams.internal.parameters.toarray.ResultToArray;

class IteratorResultToArray
implements ResultToArray {
    private Object result;

    IteratorResultToArray(Object result) {
        this.result = result;
    }

    @Override
    public boolean isApplicable() {
        return Iterator.class.isAssignableFrom(this.result.getClass());
    }

    @Override
    public Object[] convert() {
        Object iteratedElement = null;
        try {
            ArrayList<Object[]> res = new ArrayList<Object[]>();
            Iterator iterator = (Iterator)this.result;
            while (iterator.hasNext()) {
                iteratedElement = iterator.next();
                res.add((Object[])iteratedElement);
            }
            return res.toArray();
        }
        catch (ClassCastException e1) {
            ArrayList<Object[]> res = new ArrayList<Object[]>();
            Iterator iterator = (Iterator)this.result;
            res.add((Object[])iteratedElement);
            while (iterator.hasNext()) {
                res.add(new Object[]{iterator.next()});
            }
            return res.toArray();
        }
    }
}

