/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils;

import ru.curs.celesta.CallContext;
import ru.curs.celesta.Celesta;
import ru.curs.celesta.ICelesta;
import ru.curs.celesta.SystemCallContext;
import ru.curs.celesta.dbutils.IProfiler;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.syscursors.CalllogCursor;

public final class ProfilingManager
implements IProfiler {
    private final Celesta celesta;
    private final DBAdaptor dbAdaptor;
    private boolean profilemode = false;

    public ProfilingManager(Celesta celesta, DBAdaptor dbAdaptor) {
        this.celesta = celesta;
        this.dbAdaptor = dbAdaptor;
    }

    public void logCall(CallContext context) {
        if (this.profilemode && !"NO_LOG".equals(context.getProcName())) {
            try (SystemCallContext sysContext = new SystemCallContext((ICelesta)this.celesta);){
                CalllogCursor clc = new CalllogCursor((CallContext)sysContext);
                clc.setProcname(context.getProcName());
                clc.setUserid(context.getUserId());
                clc.setStarttime(context.getStartTime());
                clc.setDuration((int)(context.getDurationNs() / 1000L));
                clc.insert();
            }
        }
    }

    public boolean isProfilemode() {
        return this.profilemode;
    }

    public void setProfilemode(boolean profilemode) {
        this.profilemode = profilemode;
    }
}

