/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.completable.reactor.graph.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.fix.completable.reactor.graph.TransitionBuilder;
import ru.fix.completable.reactor.graph.Vertex;
import ru.fix.completable.reactor.graph.internal.BuilderContext;
import ru.fix.completable.reactor.graph.internal.GlTransition;
import ru.fix.completable.reactor.graph.internal.GlTransitionBuilder;
import ru.fix.completable.reactor.graph.internal.InternalGlAccessor;
import ru.fix.completable.reactor.graph.runtime.GlVertex;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lru/fix/completable/reactor/graph/internal/GlTransitionBuilder;", "Lru/fix/completable/reactor/graph/TransitionBuilder;", "vertex", "Lru/fix/completable/reactor/graph/Vertex;", "transition", "Lru/fix/completable/reactor/graph/internal/GlTransition;", "transitionReceiver", "", "(Lru/fix/completable/reactor/graph/Vertex;Lru/fix/completable/reactor/graph/internal/GlTransition;Ljava/util/List;)V", "getTransition", "()Lru/fix/completable/reactor/graph/internal/GlTransition;", "getTransitionReceiver", "()Ljava/util/List;", "getVertex", "()Lru/fix/completable/reactor/graph/Vertex;", "vx", "Lru/fix/completable/reactor/graph/runtime/GlVertex;", "complete", "handleBy", "mergeBy", "mergeTransition", "", "sourceVertex", "newTransition", "sourceVertexTransitions", "completable-reactor-graph"})
public final class GlTransitionBuilder
implements TransitionBuilder {
    private final GlVertex vx;
    @NotNull
    private final Vertex vertex;
    @NotNull
    private final GlTransition transition;
    @NotNull
    private final List<GlTransition> transitionReceiver;

    @Override
    @NotNull
    public Vertex complete() {
        this.transition.setComplete(true);
        this.mergeTransition(this.vx, this.transition, this.transitionReceiver);
        return this.vertex;
    }

    @Override
    @NotNull
    public Vertex handleBy(@NotNull Vertex vertex) {
        Intrinsics.checkParameterIsNotNull((Object)vertex, (String)"vertex");
        GlVertex targetGlVertex = InternalGlAccessor.Companion.vx(vertex);
        if (targetGlVertex.name == null) {
            targetGlVertex.name = BuilderContext.Companion.get().resolveVertexName(vertex);
        }
        this.transition.setHandleBy(targetGlVertex);
        this.mergeTransition(this.vx, this.transition, this.transitionReceiver);
        return this.vertex;
    }

    @Override
    @NotNull
    public Vertex mergeBy(@NotNull Vertex vertex) {
        Intrinsics.checkParameterIsNotNull((Object)vertex, (String)"vertex");
        GlVertex targetGlVertex = InternalGlAccessor.Companion.vx(vertex);
        if (targetGlVertex.name == null) {
            targetGlVertex.name = BuilderContext.Companion.get().resolveVertexName(vertex);
        }
        if (targetGlVertex.router != null) {
            throw (Throwable)new IllegalArgumentException(StringsKt.trimIndent((String)("\n                        MergeBy transition is targeting vertex " + targetGlVertex.name + ".\n                        Vertex " + targetGlVertex.name + " is of type Router or Mutator.\n                        Routers and Mutators are allowed to participate only in handleBy transitions.\n                        Maybe you want to use HandleBy transition instead.\n                        ")));
        }
        this.transition.setMergeBy(targetGlVertex);
        this.mergeTransition(this.vx, this.transition, this.transitionReceiver);
        return this.vertex;
    }

    /*
     * WARNING - void declaration
     */
    public final void mergeTransition(@NotNull GlVertex sourceVertex, @NotNull GlTransition newTransition, @NotNull List<GlTransition> sourceVertexTransitions) {
        Intrinsics.checkParameterIsNotNull((Object)sourceVertex, (String)"sourceVertex");
        Intrinsics.checkParameterIsNotNull((Object)newTransition, (String)"newTransition");
        Intrinsics.checkParameterIsNotNull(sourceVertexTransitions, (String)"sourceVertexTransitions");
        if (this.transition.isComplete()) {
            void $receiver$iv$iv;
            Object $receiver$iv = sourceVertexTransitions;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                GlTransition it = (GlTransition)element$iv$iv;
                if (!it.isComplete()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List existingCompleteTransitions = (List)destination$iv$iv;
            $receiver$iv = existingCompleteTransitions;
            if (!$receiver$iv.isEmpty()) {
                $receiver$iv = CollectionsKt.first((List)existingCompleteTransitions);
                GlTransition it = (GlTransition)$receiver$iv;
                it.setMergeStatuses(SetsKt.plus(it.getMergeStatuses(), (Iterable)this.transition.getMergeStatuses()));
            } else {
                sourceVertexTransitions.add(newTransition);
            }
        } else {
            Function1 targetAccessor;
            if (newTransition.getHandleBy() != null) {
                targetAccessor = mergeTransition.2.INSTANCE;
            } else if (newTransition.getMergeBy() != null) {
                targetAccessor = mergeTransition.3.INSTANCE;
            } else {
                throw (Throwable)new IllegalArgumentException("Transition does not have neither handleBy neither mergeBy target");
            }
            Object object = targetAccessor.invoke((Object)newTransition);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            GlVertex newTransitionTarget = (GlVertex)object;
            List existingTransitionToSameTarget2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)sourceVertexTransitions), (Function1)((Function1)new Function1<GlTransition, Boolean>(newTransitionTarget, targetAccessor){
                final /* synthetic */ GlVertex $newTransitionTarget;
                final /* synthetic */ Function1 $targetAccessor;

                public final boolean invoke(@NotNull GlTransition it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)((GlVertex)this.$targetAccessor.invoke((Object)it)), (Object)this.$newTransitionTarget);
                }
                {
                    this.$newTransitionTarget = glVertex;
                    this.$targetAccessor = function1;
                    super(1);
                }
            })));
            Collection $i$a$1$let = existingTransitionToSameTarget2;
            if (!$i$a$1$let.isEmpty()) {
                if (existingTransitionToSameTarget2.size() > 1) {
                    throw (Throwable)new IllegalArgumentException("More that one transition exit" + " from " + sourceVertex.name + " to " + newTransitionTarget.name + '.' + " Transition is redundant.");
                }
                GlTransition existingTransition = (GlTransition)CollectionsKt.first((List)existingTransitionToSameTarget2);
                if (existingTransition.isOnAny()) {
                    throw (Throwable)new IllegalArgumentException("" + "Unconditional transition from " + sourceVertex.name + " to " + newTransitionTarget.name + " already exist." + " Transition is redundant.");
                }
                if (existingTransition.getMergeStatuses().containsAll((Collection)newTransition.getMergeStatuses())) {
                    throw (Throwable)new IllegalArgumentException("Transition that suite given condition already exist" + " between " + sourceVertex.name + " and " + newTransitionTarget.name + '.' + " Transition is redundant.");
                }
                existingTransition.setMergeStatuses(CollectionsKt.union((Iterable)existingTransition.getMergeStatuses(), (Iterable)newTransition.getMergeStatuses()));
            } else {
                sourceVertexTransitions.add(newTransition);
            }
        }
    }

    @NotNull
    public final Vertex getVertex() {
        return this.vertex;
    }

    @NotNull
    public final GlTransition getTransition() {
        return this.transition;
    }

    @NotNull
    public final List<GlTransition> getTransitionReceiver() {
        return this.transitionReceiver;
    }

    public GlTransitionBuilder(@NotNull Vertex vertex, @NotNull GlTransition transition, @NotNull List<GlTransition> transitionReceiver) {
        Intrinsics.checkParameterIsNotNull((Object)vertex, (String)"vertex");
        Intrinsics.checkParameterIsNotNull((Object)transition, (String)"transition");
        Intrinsics.checkParameterIsNotNull(transitionReceiver, (String)"transitionReceiver");
        this.vertex = vertex;
        this.transition = transition;
        this.transitionReceiver = transitionReceiver;
        this.vx = InternalGlAccessor.Companion.vx(this.vertex);
    }
}

