/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.stdlib.concurrency.threads;

import java.util.concurrent.ForkJoinPool;
import ru.fix.aggregating.profiler.Profiler;
import ru.fix.dynamic.property.api.DynamicProperty;
import ru.fix.stdlib.concurrency.threads.ProfiledScheduledThreadPoolExecutor;
import ru.fix.stdlib.concurrency.threads.ProfiledThreadPoolExecutor;
import ru.fix.stdlib.concurrency.threads.ReschedulableScheduler;

public class NamedExecutors {
    public static ProfiledThreadPoolExecutor newDynamicPool(String poolName, DynamicProperty<Integer> maxPoolSize, Profiler profiler) {
        return new ProfiledThreadPoolExecutor(poolName, maxPoolSize, profiler);
    }

    public static ProfiledThreadPoolExecutor newSingleThreadPool(String poolName, Profiler profiler) {
        return new ProfiledThreadPoolExecutor(poolName, (DynamicProperty<Integer>)DynamicProperty.of((Object)1), profiler);
    }

    public static ReschedulableScheduler newScheduler(String poolName, DynamicProperty<Integer> maxPoolSize, Profiler profiler) {
        return new ReschedulableScheduler(poolName, maxPoolSize, profiler);
    }

    public static ReschedulableScheduler newSingleThreadScheduler(String poolName, Profiler profiler) {
        return new ReschedulableScheduler(poolName, (DynamicProperty<Integer>)DynamicProperty.of((Object)1), profiler);
    }

    public static ProfiledScheduledThreadPoolExecutor newScheduledExecutor(String poolName, DynamicProperty<Integer> maxPoolSize, Profiler profiler) {
        return new ProfiledScheduledThreadPoolExecutor(poolName, maxPoolSize, profiler);
    }

    public static ProfiledScheduledThreadPoolExecutor newSingleThreadScheduledExecutor(String poolName, Profiler profiler) {
        return new ProfiledScheduledThreadPoolExecutor(poolName, (DynamicProperty<Integer>)DynamicProperty.of((Object)1), profiler);
    }

    public static void profileCommonPool(Profiler profiler) {
        profiler.attachIndicator("pool.commonPool.poolSize", () -> ForkJoinPool.commonPool().getPoolSize());
        profiler.attachIndicator("pool.commonPool.activeThread", () -> ForkJoinPool.commonPool().getActiveThreadCount());
        profiler.attachIndicator("pool.commonPool.runningThread", () -> ForkJoinPool.commonPool().getRunningThreadCount());
        profiler.attachIndicator("pool.commonPool.queue", () -> ForkJoinPool.commonPool().getQueuedSubmissionCount());
        profiler.attachIndicator("pool.commonPool.steal", () -> ForkJoinPool.commonPool().getStealCount());
    }
}

