/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.stdlib.concurrency.threads;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import ru.fix.aggregating.profiler.ProfiledCall;
import ru.fix.aggregating.profiler.Profiler;
import ru.fix.dynamic.property.api.DynamicProperty;

public class ProfiledThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final long THREAD_IDLE_TIMEOUT_BEFORE_TERMINATION_SEC = 60L;
    final Profiler profiler;
    final ThreadLocal<ProfiledCall> runExecution = new ThreadLocal();
    private final String poolName;
    private final String queueIndicatorName;
    private final String activeThreadsIndicatorName;
    private final String poolSizeIndicatorName;
    private final String callAwaitName;
    private final String callRunName;

    private static ThreadFactory threadFactory(String poolName) {
        AtomicInteger counter = new AtomicInteger();
        return runnable -> new Thread(runnable, poolName + "-" + counter.getAndIncrement());
    }

    public ProfiledThreadPoolExecutor(String poolName, DynamicProperty<Integer> maxPoolSize, Profiler profiler) {
        super((int)((Integer)maxPoolSize.get()), (int)((Integer)maxPoolSize.get()), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ProfiledThreadPoolExecutor.threadFactory(poolName));
        this.poolName = poolName;
        this.profiler = profiler;
        String profilerPoolName = poolName.replace('.', '_');
        this.queueIndicatorName = "pool." + profilerPoolName + ".queue";
        this.activeThreadsIndicatorName = "pool." + profilerPoolName + ".activeThreads";
        this.callAwaitName = "pool." + profilerPoolName + ".await";
        this.callRunName = "pool." + profilerPoolName + ".run";
        this.poolSizeIndicatorName = "pool." + profilerPoolName + ".poolSize";
        super.allowCoreThreadTimeOut(true);
        maxPoolSize.addAndCallListener((oldVal, newVal) -> this.setMaxPoolSize((int)newVal));
        profiler.attachIndicator(this.queueIndicatorName, () -> this.getQueue().size());
        profiler.attachIndicator(this.activeThreadsIndicatorName, () -> this.getActiveCount());
        profiler.attachIndicator(this.poolSizeIndicatorName, () -> this.getPoolSize());
    }

    @Override
    public void execute(final Runnable command) {
        final ProfiledCall awaitCall = this.profiler.profiledCall(this.callAwaitName).start();
        super.execute(new ProfiledRunnable(this.poolName){

            @Override
            public void run() {
                awaitCall.stop();
                command.run();
            }
        });
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        this.runExecution.set(this.profiler.profiledCall(this.callRunName).start());
        super.beforeExecute(thread, runnable);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable thread) {
        ProfiledCall runCall = this.runExecution.get();
        if (runCall != null) {
            runCall.stop();
            this.runExecution.remove();
        }
        super.afterExecute(runnable, thread);
    }

    @Override
    protected void terminated() {
        this.profiler.detachIndicator(this.queueIndicatorName);
        this.profiler.detachIndicator(this.activeThreadsIndicatorName);
        this.profiler.detachIndicator(this.poolSizeIndicatorName);
    }

    public void setMaxPoolSize(int maxPoolSize) {
        if (maxPoolSize >= this.getMaximumPoolSize()) {
            this.setMaximumPoolSize(maxPoolSize);
            this.setCorePoolSize(maxPoolSize);
        } else {
            this.setCorePoolSize(maxPoolSize);
            this.setMaximumPoolSize(maxPoolSize);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.poolName + ")";
    }

    private abstract class ProfiledRunnable
    implements Runnable {
        private final String poolName;

        public ProfiledRunnable(String poolName) {
            this.poolName = poolName;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.poolName + ")";
        }
    }
}

