/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import ru.vyarus.java.generics.resolver.context.container.ExplicitTypeVariable;
import ru.vyarus.java.generics.resolver.context.container.ParameterizedTypeImpl;
import ru.vyarus.java.generics.resolver.error.UnknownGenericException;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeUtils;
import ru.vyarus.java.generics.resolver.util.map.IgnoreGenericsMap;
import ru.vyarus.java.generics.resolver.util.map.PrintableGenericsMap;

public final class TypeToStringUtils {
    private TypeToStringUtils() {
    }

    public static String toStringType(Type type, Map<String, Type> generics) {
        String res = type instanceof Class ? ((Class)type).getSimpleName() : (type instanceof ParameterizedType ? TypeToStringUtils.processParametrizedType((ParameterizedType)type, generics) : (type instanceof GenericArrayType ? TypeToStringUtils.toStringType(((GenericArrayType)type).getGenericComponentType(), generics) + "[]" : (type instanceof WildcardType ? TypeToStringUtils.processWildcardType((WildcardType)type, generics) : (type instanceof ExplicitTypeVariable ? type.toString() : TypeToStringUtils.toStringType(TypeToStringUtils.declaredGeneric((TypeVariable)type, generics), generics)))));
        return res;
    }

    public static String toStringWithNamedGenerics(Class<?> type) {
        return TypeToStringUtils.toStringType(new ParameterizedTypeImpl(type, (Type[])type.getTypeParameters()), new PrintableGenericsMap());
    }

    public static String toStringWithGenerics(Class<?> type, Map<String, Type> generics) {
        Map<String, Type> actual = GenericsUtils.extractTypeGenerics(type, generics);
        return TypeToStringUtils.toStringType(new ParameterizedTypeImpl(type, actual.values().toArray(new Type[0])), actual);
    }

    public static String toStringMethod(Method method, Map<String, Type> generics) {
        return String.format("%s %s(%s)", TypeToStringUtils.toStringType(method.getGenericReturnType(), generics), method.getName(), TypeToStringUtils.join(method.getGenericParameterTypes(), generics));
    }

    public static String toStringConstructor(Constructor constructor, Map<String, Type> generics) {
        return String.format("%s(%s)", constructor.getDeclaringClass().getSimpleName(), TypeToStringUtils.join(constructor.getGenericParameterTypes(), generics));
    }

    private static String processParametrizedType(ParameterizedType parametrized, Map<String, Type> generics) {
        StringBuilder res = new StringBuilder(50);
        Type outer = TypeUtils.getOuter(parametrized);
        if (outer != null) {
            res.append(TypeToStringUtils.toStringType(outer, new IgnoreGenericsMap((Map<? extends String, ? extends Type>)generics))).append('.');
        }
        res.append(TypeToStringUtils.toStringType(parametrized.getRawType(), generics));
        Type[] args = parametrized.getActualTypeArguments();
        if (args.length > 0) {
            res.append('<').append(TypeToStringUtils.join(args, generics)).append('>');
        }
        return res.toString();
    }

    private static String processWildcardType(WildcardType wildcard, Map<String, Type> generics) {
        String res;
        if (wildcard.getLowerBounds().length == 0) {
            StringBuilder bounds = new StringBuilder(wildcard.getUpperBounds().length * 10);
            boolean first = true;
            for (Type type : wildcard.getUpperBounds()) {
                if (!first) {
                    bounds.append(" & ");
                }
                bounds.append(TypeToStringUtils.toStringType(GenericsUtils.resolveClass(type, generics), generics));
                first = false;
            }
            res = "? extends " + bounds.toString();
        } else {
            res = "? super " + TypeToStringUtils.toStringType(GenericsUtils.resolveClass(wildcard.getLowerBounds()[0], generics), generics);
        }
        return res;
    }

    private static String join(Type[] args, Map<String, Type> generics) {
        String res;
        if (args.length == 0) {
            res = "";
        } else if (args.length == 1) {
            res = TypeToStringUtils.toStringType(args[0], generics);
        } else {
            StringBuilder buf = new StringBuilder(args.length * 20);
            boolean first = true;
            for (Type type : args) {
                if (!first) {
                    buf.append(", ");
                }
                buf.append(TypeToStringUtils.toStringType(type, generics));
                first = false;
            }
            res = buf.toString();
        }
        return res;
    }

    private static Type declaredGeneric(TypeVariable generic, Map<String, Type> declarations) {
        String name = generic.getName();
        Type result = declarations.get(name);
        if (result == null || result instanceof TypeVariable) {
            throw new UnknownGenericException(name, (GenericDeclaration)generic.getGenericDeclaration());
        }
        return result;
    }
}

