package ru.vyarus.gradle.plugin.pom

import groovy.transform.CompileStatic

/**
 * Pom modifications configuration.
 *
 * @author Vyacheslav Rusakov
 * @since 27.05.2021
 */
@CompileStatic
class PomExtension {

    boolean forcedVersions
    boolean removedDependencyManagement
    boolean disabledScopesCorrection
    boolean disabledBomsReorder

    /**
     * Force dependency versions in the generated pom. Useful when gradle platforms used (by default generated pom
     * would rely on dependenciesManagement section).
     * <p>
     * Activated automatically for {@link #removeDependencyManagement()}.
     * <p>
     * Uses <a
     * href="https://docs.gradle.org/current/userguide/publishing_maven.html#publishing_maven:resolved_dependencies">
     * officially recommended way</a>.
     */
    void forceVersions() {
        forcedVersions = true
    }

    /**
     * Removes dependencyManagement section (generated by gradle for imported platforms). Also, forces dependency
     * versions ({@link #forceVersions()}) because without boms pom become invalid otherwise.
     * <p>
     * Option assumed to be used when gradle platforms used for dependency management, but it is not desired to
     * preserve platforms in the generated pom.
     * <p>
     * Compatible with spring dependency management plugin.
     */
    void removeDependencyManagement() {
        removedDependencyManagement = true
        forceVersions()
    }

    /**
     * Disables dependencies scopes fixes performed by the plugin. May be used to see the default gradle behaviour.
     * <p>
     * Optional and provided configurations dependencies would be generated with correct scopes in any case.
     */
    void disableScopesCorrection() {
        disabledScopesCorrection = true
    }

    /**
     * Gradle java-platform plugin always put used BOMs after other dependencies in the generated pom. Pom plugin fixes
     * this by putting all BOMs at the top (unifies with spring plugin behaviour).
     * <p>
     * Option disables BOMs reordering to see native gradle behaviour.
     */
    void disableBomsReorder() {
        disabledBomsReorder = true
    }
}
