/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseEntry;
import java.math.BigInteger;

public class BigIntegerBinding
extends TupleBinding {
    public Object entryToObject(TupleInput input) {
        return input.readBigInteger();
    }

    public void objectToEntry(Object object, TupleOutput output) {
        output.writeBigInteger((BigInteger)object);
    }

    protected TupleOutput getTupleOutput(Object object) {
        return BigIntegerBinding.sizedOutput((BigInteger)object);
    }

    public static BigInteger entryToBigInteger(DatabaseEntry entry) {
        return BigIntegerBinding.entryToInput(entry).readBigInteger();
    }

    public static void bigIntegerToEntry(BigInteger val, DatabaseEntry entry) {
        BigIntegerBinding.outputToEntry(BigIntegerBinding.sizedOutput(val).writeBigInteger(val), entry);
    }

    private static TupleOutput sizedOutput(BigInteger val) {
        int len = TupleOutput.getBigIntegerByteLength(val);
        return new TupleOutput(new byte[len]);
    }
}

