/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.utilint.DaemonRunner;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class DaemonThread
implements DaemonRunner,
Runnable {
    private static final int JOIN_MILLIS = 10;
    private long waitTime;
    private Object synchronizer = new Object();
    private Thread thread;
    private EnvironmentImpl env;
    protected String name;
    protected Set workQueue;
    protected Latch workQueueLatch;
    protected int nWakeupRequests;
    protected boolean stifleExceptionChatter = false;
    private volatile boolean shutdownRequest = false;
    private volatile boolean paused = false;
    private boolean running = false;

    public DaemonThread(long waitTime, String name, EnvironmentImpl env) {
        this.waitTime = waitTime;
        this.name = name;
        this.env = env;
        this.workQueue = new HashSet();
        this.workQueueLatch = LatchSupport.makeLatch(name + " work queue", env);
    }

    public Thread getThread() {
        return this.thread;
    }

    public void runOrPause(boolean run) {
        if (run) {
            this.paused = false;
            if (this.thread != null) {
                this.wakeup();
            } else {
                this.thread = new Thread((Runnable)this, this.name);
                this.thread.setDaemon(true);
                this.thread.start();
            }
        } else {
            this.paused = true;
        }
    }

    public void requestShutdown() {
        this.shutdownRequest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.thread != null) {
            this.shutdownRequest = true;
            while (this.thread.isAlive()) {
                Object object = this.synchronizer;
                synchronized (object) {
                    this.synchronizer.notifyAll();
                }
                try {
                    this.thread.join(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.thread = null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<DaemonThread name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    public void addToQueue(Object o) throws DatabaseException {
        this.workQueueLatch.acquire();
        this.workQueue.add(o);
        this.wakeup();
        this.workQueueLatch.release();
    }

    public int getQueueSize() throws DatabaseException {
        this.workQueueLatch.acquire();
        int count = this.workQueue.size();
        this.workQueueLatch.release();
        return count;
    }

    public void addToQueueAlreadyLatched(Collection c) throws DatabaseException {
        this.workQueue.addAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        if (!this.paused) {
            Object object = this.synchronizer;
            synchronized (object) {
                this.synchronizer.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.shutdownRequest) {
            try {
                Object object;
                this.workQueueLatch.acquire();
                boolean nothingToDo = this.workQueue.size() == 0;
                this.workQueueLatch.release();
                if (nothingToDo) {
                    object = this.synchronizer;
                    synchronized (object) {
                        if (this.waitTime == 0L) {
                            this.synchronizer.wait();
                        } else {
                            this.synchronizer.wait(this.waitTime);
                        }
                    }
                }
                if (this.shutdownRequest) break;
                if (this.paused) {
                    object = this.synchronizer;
                    synchronized (object) {
                        this.synchronizer.wait();
                        continue;
                    }
                }
                int numTries = 0;
                int maxRetries = this.nDeadlockRetries();
                do {
                    try {
                        ++this.nWakeupRequests;
                        this.running = true;
                        this.onWakeup();
                        break;
                    }
                    catch (DeadlockException e) {
                    }
                    finally {
                        this.running = false;
                    }
                } while (!this.shutdownRequest && ++numTries <= maxRetries);
                if (!this.shutdownRequest) continue;
                break;
            }
            catch (InterruptedException IE) {
                ExceptionListener exceptionListener = this.env.getExceptionListener();
                if (exceptionListener != null) {
                    exceptionListener.exceptionThrown(DbInternal.makeExceptionEvent(IE, this.name));
                }
                if (!this.stifleExceptionChatter) {
                    System.err.println("Shutting down " + this + " due to exception: " + IE);
                }
                this.shutdownRequest = true;
            }
            catch (Exception E) {
                ExceptionListener exceptionListener = this.env.getExceptionListener();
                if (exceptionListener != null) {
                    exceptionListener.exceptionThrown(DbInternal.makeExceptionEvent(E, this.name));
                }
                if (!this.stifleExceptionChatter) {
                    System.err.println(this + " caught exception: " + E);
                    E.printStackTrace(System.err);
                }
                if (this.env.mayNotWrite()) {
                    if (!this.stifleExceptionChatter) {
                        System.err.println("Exiting");
                    }
                    this.shutdownRequest = true;
                    continue;
                }
                if (this.stifleExceptionChatter) continue;
                System.err.println("Continuing");
            }
        }
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return 0;
    }

    protected abstract void onWakeup() throws DatabaseException;

    protected boolean isShutdownRequested() {
        return this.shutdownRequest;
    }

    protected boolean isPaused() {
        return this.paused;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getNWakeupRequests() {
        return this.nWakeupRequests;
    }
}

