/*
 * Decompiled with CFR 0.152.
 */
package software.reinvent.headless.chrome;

import com.assertthat.selenium_shutterbug.core.PageSnapshot;
import com.assertthat.selenium_shutterbug.core.Shutterbug;
import com.assertthat.selenium_shutterbug.utils.web.ScrollStrategy;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class HeadlessDriverUtils {
    public static void takeFullScreenshot(WebDriver webDriver, File file) throws IOException {
        HeadlessDriverUtils.takeFullScreenshot(webDriver, file, null);
    }

    public static void takeFullScreenshot(WebDriver webDriver, File file, By ... byArray) throws IOException {
        PageSnapshot pageSnapshot = Shutterbug.shootPage((WebDriver)webDriver, (ScrollStrategy)ScrollStrategy.BOTH_DIRECTIONS);
        if (ArrayUtils.isNotEmpty((Object[])byArray)) {
            Arrays.stream(byArray).map(arg_0 -> ((WebDriver)webDriver).findElements(arg_0)).flatMap(Collection::stream).forEach(arg_0 -> ((PageSnapshot)pageSnapshot).highlight(arg_0));
        }
        FileUtils.forceMkdirParent((File)file);
        pageSnapshot.withName(file.getName());
        pageSnapshot.save(file.getParent());
        FileUtils.deleteQuietly((File)file);
        FileUtils.moveFile((File)new File(file.getPath() + ".png"), (File)file);
    }
}

