/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.swing.table.TableModel;
import org.opends.guitools.statuspanel.BaseDNDescriptor;
import org.opends.guitools.statuspanel.ConfigException;
import org.opends.guitools.statuspanel.ConfigFromFile;
import org.opends.guitools.statuspanel.ConfigFromLDAP;
import org.opends.guitools.statuspanel.ConnectionProtocolPolicy;
import org.opends.guitools.statuspanel.DatabaseDescriptor;
import org.opends.guitools.statuspanel.ListenerDescriptor;
import org.opends.guitools.statuspanel.ServerStatusDescriptor;
import org.opends.guitools.statuspanel.StatusCliArgumentParser;
import org.opends.guitools.statuspanel.ui.DatabasesTableModel;
import org.opends.guitools.statuspanel.ui.ListenersTableModel;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.SecureConnectionCliArgs;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.LDAPManagementContextFactory;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.DynamicConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.LDAPConnectionConsoleInteraction;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

class StatusCli
extends ConsoleApplication {
    private boolean displayMustAuthenticateLegend;
    private boolean displayMustStartLegend;
    public static final String LOG_FILE_PREFIX = "opends-status-";
    public static final String LOG_FILE_SUFFIX = ".log";
    private TrustManager interactiveTrustManager;
    private boolean useInteractiveTrustManager;
    private static final Logger LOG = Logger.getLogger(StatusCli.class.getName());
    private StatusCliArgumentParser argParser;

    public StatusCli(PrintStream out, PrintStream err, InputStream in) {
        super(in, (OutputStream)out, (OutputStream)err);
    }

    public static void main(String[] args) {
        int retCode = StatusCli.mainCLI(args, true, System.out, System.err, System.in);
        if (retCode != 0) {
            System.exit(retCode);
        }
    }

    public static int mainCLI(String[] args) {
        return StatusCli.mainCLI(args, true, System.out, System.err, System.in);
    }

    public static int mainCLI(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream, InputStream inStream) {
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, LOG_FILE_SUFFIX), "org.opends.guitools.statuspanel");
            QuickSetupLog.disableConsoleLogging();
        }
        catch (Throwable t) {
            System.err.println("Unable to initialize log");
            t.printStackTrace();
        }
        StatusCli statusCli = new StatusCli(out, err, inStream);
        return statusCli.execute(args, initializeServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(String[] args, boolean initializeServer) {
        if (initializeServer) {
            DirectoryServer.bootstrapClient();
        }
        this.argParser = new StatusCliArgumentParser(StatusCli.class.getName());
        try {
            this.argParser.initializeGlobalArguments(this.getOutputStream());
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            this.println(message);
            return ErrorReturnCode.ERROR_UNEXPECTED.getReturnCode();
        }
        try {
            this.argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            this.println(message);
            this.println();
            this.println(Message.raw(this.argParser.getUsage(), new Object[0]));
            return ErrorReturnCode.ERROR_PARSING_ARGS.getReturnCode();
        }
        if (this.argParser.usageOrVersionDisplayed()) {
            return ErrorReturnCode.SUCCESSFUL_NOP.getReturnCode();
        }
        int v = this.argParser.validateGlobalOptions(this.getErrorStream());
        if (v != DsFrameworkCliReturnCode.SUCCESSFUL_NOP.getReturnCode()) {
            this.println(Message.raw(this.argParser.getUsage(), new Object[0]));
            return v;
        }
        boolean isServerRunning = Installation.getLocal().getStatus().isServerRunning();
        ConfigFromFile offLineConf = new ConfigFromFile();
        offLineConf.readConfiguration();
        boolean authProvided = false;
        try {
            ServerStatusDescriptor desc;
            String bindPwd;
            String bindDn;
            if (!isServerRunning) {
                ServerStatusDescriptor desc2 = this.createServerStatusDescriptor(null, null);
                this.updateDescriptorWithOffLineInfo(desc2, offLineConf);
                this.writeStatus(desc2);
                return ErrorReturnCode.SUCCESSFUL.getReturnCode();
            }
            boolean useSSL = this.argParser.useSSL();
            boolean useStartTLS = this.argParser.useStartTLS();
            if (this.argParser.isInteractive()) {
                ManagementContext ctx = null;
                boolean canUseSSL = offLineConf.getLDAPSURL() != null;
                boolean canUseStartTLS = offLineConf.getStartTLSURL() != null;
                SecureConnectionCliArgs secureArgsList = this.argParser.getSecureArgsList();
                secureArgsList.hostNameArg.setPresent(true);
                secureArgsList.portArg.setPresent(true);
                secureArgsList.hostNameArg.addValue(secureArgsList.hostNameArg.getDefaultValue());
                secureArgsList.portArg.addValue(secureArgsList.portArg.getDefaultValue());
                if (!canUseSSL) {
                    if (useSSL) {
                        throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
                    }
                    secureArgsList.useSSLArg.setValueSetByProperty(true);
                }
                if (!canUseStartTLS) {
                    if (useStartTLS) {
                        throw new ConfigException(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
                    }
                    secureArgsList.useStartTLSArg.setValueSetByProperty(true);
                }
                LDAPConnectionConsoleInteraction ci = new LDAPConnectionConsoleInteraction(this, this.argParser.getSecureArgsList());
                try {
                    ci.run(canUseSSL, canUseStartTLS);
                    bindDn = ci.getBindDN();
                    bindPwd = ci.getBindPassword();
                    useSSL = ci.useSSL();
                    useStartTLS = ci.useStartTLS();
                    int port = 389;
                    String ldapUrl = offLineConf.getURL(ConnectionProtocolPolicy.getConnectionPolicy(useSSL, useStartTLS));
                    try {
                        URI uri = new URI(ldapUrl);
                        port = uri.getPort();
                        ci.setPortNumber(port);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.SEVERE, "Error parsing url: " + ldapUrl);
                    }
                    LDAPManagementContextFactory factory = new LDAPManagementContextFactory();
                    ctx = factory.getManagementContext(this, ci);
                    this.interactiveTrustManager = ci.getTrustManager();
                    this.useInteractiveTrustManager = true;
                }
                catch (ConfigException ce) {
                    LOG.log(Level.WARNING, "Error reading config file: " + ce, ce);
                    this.println();
                    this.println(AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get());
                    this.println();
                    int ldapUrl = ErrorReturnCode.USER_CANCELLED_OR_DATA_ERROR.getReturnCode();
                    return ldapUrl;
                }
                catch (ArgumentException e) {
                    this.println(e.getMessageObject());
                    int ldapUrl = ErrorReturnCode.USER_CANCELLED_OR_DATA_ERROR.getReturnCode();
                    return ldapUrl;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    catch (ClientException e2) {
                        this.println(e2.getMessageObject());
                        ServerStatusDescriptor desc3 = this.createServerStatusDescriptor(null, null);
                        this.updateDescriptorWithOffLineInfo(desc3, offLineConf);
                        this.writeStatus(desc3);
                        int n = ErrorReturnCode.USER_CANCELLED_OR_DATA_ERROR.getReturnCode();
                        return n;
                    }
                }
                finally {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable t) {}
                    }
                }
            }
            bindDn = this.argParser.getBindDN();
            bindPwd = this.argParser.getBindPassword();
            boolean bl = authProvided = bindPwd != null;
            if (bindDn == null) {
                bindDn = "";
            }
            if (bindPwd == null) {
                bindPwd = "";
            }
            if (authProvided) {
                desc = this.createServerStatusDescriptor(bindDn, bindPwd);
                ConfigFromLDAP onLineConf = new ConfigFromLDAP();
                ConnectionProtocolPolicy policy = ConnectionProtocolPolicy.getConnectionPolicy(useSSL, useStartTLS);
                onLineConf.setConnectionInfo(offLineConf, policy, bindDn, bindPwd, this.getTrustManager());
                onLineConf.readConfiguration();
                this.updateDescriptorWithOnLineInfo(desc, onLineConf);
                this.writeStatus(desc);
                if (desc.getErrorMessage() == null) return ErrorReturnCode.SUCCESSFUL.getReturnCode();
                return ErrorReturnCode.ERROR_READING_CONFIGURATION_WITH_LDAP.getReturnCode();
            }
            desc = this.createServerStatusDescriptor(null, null);
            this.updateDescriptorWithOffLineInfo(desc, offLineConf);
            this.writeStatus(desc);
            return ErrorReturnCode.SUCCESSFUL.getReturnCode();
        }
        catch (ConfigException ce) {
            this.println();
            this.println(ce.getMessageObject());
            return ErrorReturnCode.USER_CANCELLED_OR_DATA_ERROR.getReturnCode();
        }
    }

    private ServerStatusDescriptor createServerStatusDescriptor(String dn, String pwd) {
        ServerStatusDescriptor desc = new ServerStatusDescriptor();
        desc.setAuthenticated(dn != null && pwd != null);
        if (Installation.getLocal().getStatus().isServerRunning()) {
            desc.setStatus(ServerStatusDescriptor.ServerStatus.STARTED);
        } else {
            desc.setStatus(ServerStatusDescriptor.ServerStatus.STOPPED);
        }
        desc.setInstallPath(new File(Utils.getInstallPathFromClasspath()));
        desc.setOpenDSVersion(DynamicConstants.FULL_VERSION_STRING);
        return desc;
    }

    private void updateDescriptorWithOffLineInfo(ServerStatusDescriptor desc, ConfigFromFile offLineConf) {
        desc.setAdministrativeUsers(offLineConf.getAdministrativeUsers());
        desc.setDatabases(offLineConf.getDatabases());
        desc.setListeners(offLineConf.getListeners());
        desc.setErrorMessage(offLineConf.getErrorMessage());
        desc.setOpenConnections(-1);
        desc.setJavaVersion(null);
    }

    private void updateDescriptorWithOnLineInfo(ServerStatusDescriptor desc, ConfigFromLDAP onLineConf) {
        desc.setAdministrativeUsers(onLineConf.getAdministrativeUsers());
        desc.setDatabases(onLineConf.getDatabases());
        desc.setListeners(onLineConf.getListeners());
        desc.setErrorMessage(onLineConf.getErrorMessage());
        desc.setJavaVersion(onLineConf.getJavaVersion());
        desc.setOpenConnections(onLineConf.getOpenConnections());
    }

    private void writeStatus(ServerStatusDescriptor desc) {
        Message[] labels = new Message[]{AdminToolMessages.INFO_SERVER_STATUS_LABEL.get(), AdminToolMessages.INFO_CONNECTIONS_LABEL.get(), AdminToolMessages.INFO_HOSTNAME_LABEL.get(), AdminToolMessages.INFO_ADMINISTRATIVE_USERS_LABEL.get(), AdminToolMessages.INFO_INSTALLATION_PATH_LABEL.get(), AdminToolMessages.INFO_OPENDS_VERSION_LABEL.get(), AdminToolMessages.INFO_JAVA_VERSION_LABEL.get()};
        int labelWidth = 0;
        Message title = AdminToolMessages.INFO_SERVER_STATUS_TITLE.get();
        if (!this.isScriptFriendly()) {
            for (int i = 0; i < labels.length; ++i) {
                labelWidth = Math.max(labelWidth, labels[i].length());
            }
            this.getOutputStream().println();
            this.getOutputStream().println(this.centerTitle(title));
        }
        this.writeStatusContents(desc, labelWidth);
        this.writeCurrentConnectionContents(desc, labelWidth);
        if (!this.isScriptFriendly()) {
            this.getOutputStream().println();
        }
        title = AdminToolMessages.INFO_SERVER_DETAILS_TITLE.get();
        if (!this.isScriptFriendly()) {
            this.getOutputStream().println(this.centerTitle(title));
        }
        this.writeHostnameContents(desc, labelWidth);
        this.writeAdministrativeUserContents(desc, labelWidth);
        this.writeInstallPathContents(desc, labelWidth);
        this.writeVersionContents(desc, labelWidth);
        this.writeJavaVersionContents(desc, labelWidth);
        if (!this.isScriptFriendly()) {
            this.getOutputStream().println();
        }
        this.writeListenerContents(desc);
        if (!this.isScriptFriendly()) {
            this.getOutputStream().println();
        }
        this.writeDatabaseContents(desc);
        this.writeErrorContents(desc);
        if (!this.isScriptFriendly()) {
            if (this.displayMustStartLegend) {
                this.getOutputStream().println();
                this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NOT_AVAILABLE_SERVER_DOWN_CLI_LEGEND.get()));
            } else if (this.displayMustAuthenticateLegend) {
                this.getOutputStream().println();
                this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_CLI_LEGEND.get()));
            }
        }
        this.getOutputStream().println();
    }

    private void writeStatusContents(ServerStatusDescriptor desc, int maxLabelWidth) {
        Message status;
        switch (desc.getStatus()) {
            case STARTED: {
                status = AdminToolMessages.INFO_SERVER_STARTED_LABEL.get();
                break;
            }
            case STOPPED: {
                status = AdminToolMessages.INFO_SERVER_STOPPED_LABEL.get();
                break;
            }
            case STARTING: {
                status = AdminToolMessages.INFO_SERVER_STARTING_LABEL.get();
                break;
            }
            case STOPPING: {
                status = AdminToolMessages.INFO_SERVER_STOPPING_LABEL.get();
                break;
            }
            case UNKNOWN: {
                status = AdminToolMessages.INFO_SERVER_UNKNOWN_STATUS_LABEL.get();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown status: " + (Object)((Object)desc.getStatus()));
            }
        }
        this.writeLabelValue(AdminToolMessages.INFO_SERVER_STATUS_LABEL.get(), status, maxLabelWidth);
    }

    private void writeCurrentConnectionContents(ServerStatusDescriptor desc, int maxLabelWidth) {
        int nConn;
        Message text = desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED ? ((nConn = desc.getOpenConnections()) >= 0 ? Message.raw(String.valueOf(nConn), new Object[0]) : (!desc.isAuthenticated() || desc.getErrorMessage() != null ? this.getNotAvailableBecauseAuthenticationIsRequiredText() : this.getNotAvailableText())) : this.getNotAvailableBecauseServerIsDownText();
        this.writeLabelValue(AdminToolMessages.INFO_CONNECTIONS_LABEL.get(), text, maxLabelWidth);
    }

    private void writeHostnameContents(ServerStatusDescriptor desc, int maxLabelWidth) {
        this.writeLabelValue(AdminToolMessages.INFO_HOSTNAME_LABEL.get(), Message.raw(desc.getHostname(), new Object[0]), maxLabelWidth);
    }

    private void writeAdministrativeUserContents(ServerStatusDescriptor desc, int maxLabelWidth) {
        Set<String> administrators = desc.getAdministrativeUsers();
        if (administrators.size() > 0) {
            TreeSet<String> ordered = new TreeSet<String>();
            ordered.addAll(administrators);
            String first = (String)ordered.iterator().next();
            this.writeLabelValue(AdminToolMessages.INFO_ADMINISTRATIVE_USERS_LABEL.get(), Message.raw(first, new Object[0]), maxLabelWidth);
            Iterator it = ordered.iterator();
            it.next();
            while (it.hasNext()) {
                this.writeLabelValue(AdminToolMessages.INFO_ADMINISTRATIVE_USERS_LABEL.get(), Message.raw((CharSequence)it.next(), new Object[0]), maxLabelWidth);
            }
        } else {
            Message text = desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED ? (!desc.isAuthenticated() || desc.getErrorMessage() != null ? this.getNotAvailableBecauseAuthenticationIsRequiredText() : this.getNotAvailableText()) : this.getNotAvailableText();
            this.writeLabelValue(AdminToolMessages.INFO_ADMINISTRATIVE_USERS_LABEL.get(), text, maxLabelWidth);
        }
    }

    private void writeInstallPathContents(ServerStatusDescriptor desc, int maxLabelWidth) {
        File path = desc.getInstallPath();
        this.writeLabelValue(AdminToolMessages.INFO_INSTALLATION_PATH_LABEL.get(), Message.raw(path.toString(), new Object[0]), maxLabelWidth);
    }

    private void writeVersionContents(ServerStatusDescriptor desc, int maxLabelWidth) {
        String openDSVersion = desc.getOpenDSVersion();
        this.writeLabelValue(AdminToolMessages.INFO_OPENDS_VERSION_LABEL.get(), Message.raw(openDSVersion, new Object[0]), maxLabelWidth);
    }

    private void writeJavaVersionContents(ServerStatusDescriptor desc, int maxLabelWidth) {
        Message text;
        if (desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED) {
            text = Message.raw(desc.getJavaVersion(), new Object[0]);
            if (text == null) {
                text = !desc.isAuthenticated() || desc.getErrorMessage() != null ? this.getNotAvailableBecauseAuthenticationIsRequiredText() : this.getNotAvailableText();
            }
        } else {
            text = this.getNotAvailableBecauseServerIsDownText();
        }
        this.writeLabelValue(AdminToolMessages.INFO_JAVA_VERSION_LABEL.get(), text, maxLabelWidth);
    }

    private void writeListenerContents(ServerStatusDescriptor desc) {
        if (!this.isScriptFriendly()) {
            Message title = AdminToolMessages.INFO_LISTENERS_TITLE.get();
            this.getOutputStream().println(this.centerTitle(title));
        }
        Set<ListenerDescriptor> allListeners = desc.getListeners();
        LinkedHashSet<ListenerDescriptor> listeners = new LinkedHashSet<ListenerDescriptor>();
        for (ListenerDescriptor listener : allListeners) {
            if (listener.getProtocol() == ListenerDescriptor.Protocol.LDIF) continue;
            listeners.add(listener);
        }
        if (listeners.size() == 0) {
            if (desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED) {
                if (!desc.isAuthenticated()) {
                    this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_CLI_LABEL.get()));
                } else {
                    this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NO_LISTENERS_FOUND.get()));
                }
            } else {
                this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NO_LISTENERS_FOUND.get()));
            }
        } else {
            ListenersTableModel listenersTableModel = new ListenersTableModel();
            listenersTableModel.setData(listeners);
            this.writeTableModel(listenersTableModel, desc);
        }
    }

    private void writeDatabaseContents(ServerStatusDescriptor desc) {
        Set<DatabaseDescriptor> databases;
        Message title = AdminToolMessages.INFO_DATABASES_TITLE.get();
        if (!this.isScriptFriendly()) {
            this.getOutputStream().println(this.centerTitle(title));
        }
        if ((databases = desc.getDatabases()).size() == 0) {
            if (desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED) {
                if (!desc.isAuthenticated()) {
                    this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_CLI_LABEL.get()));
                } else {
                    this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NO_DBS_FOUND.get()));
                }
            } else {
                this.getOutputStream().println(this.wrapText(AdminToolMessages.INFO_NO_DBS_FOUND.get()));
            }
        } else {
            DatabasesTableModel databasesTableModel = new DatabasesTableModel(true);
            HashSet<BaseDNDescriptor> replicas = new HashSet<BaseDNDescriptor>();
            Set<DatabaseDescriptor> dbs = desc.getDatabases();
            for (DatabaseDescriptor db : dbs) {
                replicas.addAll(db.getBaseDns());
            }
            databasesTableModel.setData(replicas);
            this.writeDatabasesTableModel(databasesTableModel, desc);
        }
    }

    private void writeErrorContents(ServerStatusDescriptor desc) {
        Message errorMsg = desc.getErrorMessage();
        if (errorMsg != null) {
            this.getOutputStream().println();
            this.getOutputStream().println(this.wrapText(errorMsg));
        }
    }

    private Message getNotAvailableBecauseServerIsDownText() {
        this.displayMustStartLegend = true;
        return AdminToolMessages.INFO_NOT_AVAILABLE_SERVER_DOWN_CLI_LABEL.get();
    }

    private Message getNotAvailableBecauseAuthenticationIsRequiredText() {
        this.displayMustAuthenticateLegend = true;
        return AdminToolMessages.INFO_NOT_AVAILABLE_AUTHENTICATION_REQUIRED_CLI_LABEL.get();
    }

    private Message getNotAvailableText() {
        return QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get();
    }

    private void writeTableModel(TableModel tableModel, ServerStatusDescriptor desc) {
        if (this.isScriptFriendly()) {
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                this.getOutputStream().println("-");
                for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                    MessageBuilder line = new MessageBuilder();
                    line.append(tableModel.getColumnName(j) + ": ");
                    line.append(this.getCellValue(tableModel.getValueAt(i, j), desc));
                    this.getOutputStream().println(this.wrapText(line.toMessage()));
                }
            }
        } else {
            int i;
            TableBuilder table = new TableBuilder();
            for (i = 0; i < tableModel.getColumnCount(); ++i) {
                table.appendHeading(Message.raw(tableModel.getColumnName(i), new Object[0]));
            }
            for (i = 0; i < tableModel.getRowCount(); ++i) {
                table.startRow();
                for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                    table.appendCell(this.getCellValue(tableModel.getValueAt(i, j), desc));
                }
            }
            TextTablePrinter printer = new TextTablePrinter(this.getOutputStream());
            printer.setColumnSeparator(":");
            table.print(printer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Message getCellValue(Object v, ServerStatusDescriptor desc) {
        Message s = null;
        if (v == null) return this.getNotAvailableText();
        if (v instanceof String) {
            return Message.raw((String)v, new Object[0]);
        }
        if (!(v instanceof Integer)) throw new IllegalStateException("Unknown object type: " + v);
        int nEntries = (Integer)v;
        if (nEntries >= 0) {
            return Message.raw(String.valueOf(nEntries), new Object[0]);
        }
        if (!desc.isAuthenticated()) return this.getNotAvailableBecauseAuthenticationIsRequiredText();
        if (desc.getErrorMessage() == null) return this.getNotAvailableText();
        return this.getNotAvailableBecauseAuthenticationIsRequiredText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeDatabasesTableModel(DatabasesTableModel tableModel, ServerStatusDescriptor desc) {
        boolean isRunning = desc.getStatus() == ServerStatusDescriptor.ServerStatus.STARTED;
        int labelWidth = 0;
        int labelWidthWithoutReplicated = 0;
        Message[] labels = new Message[tableModel.getColumnCount()];
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            Message header = i == 5 ? AdminToolMessages.INFO_AGE_OF_OLDEST_MISSING_CHANGE_COLUMN_CLI.get() : Message.raw(tableModel.getColumnName(i), new Object[0]);
            labels[i] = new MessageBuilder(header).append(":").toMessage();
            labelWidth = Math.max(labelWidth, labels[i].length());
            if (i == 4 || i == 5) continue;
            labelWidthWithoutReplicated = Math.max(labelWidthWithoutReplicated, labels[i].length());
        }
        Message replicatedLabel = AdminToolMessages.INFO_BASEDN_REPLICATED_LABEL.get();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (this.isScriptFriendly()) {
                this.getOutputStream().println("-");
            } else if (i > 0) {
                this.getOutputStream().println();
            }
            for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                Message value;
                Object v = tableModel.getValueAt(i, j);
                if (v != null) {
                    if (v instanceof String) {
                        value = Message.raw((String)v, new Object[0]);
                    } else if (v instanceof Message) {
                        value = (Message)v;
                    } else {
                        if (!(v instanceof Integer)) throw new IllegalStateException("Unknown object type: " + v);
                        int nEntries = (Integer)v;
                        if (nEntries >= 0) {
                            value = Message.raw(String.valueOf(nEntries), new Object[0]);
                        } else {
                            if (!isRunning) {
                                value = this.getNotAvailableBecauseServerIsDownText();
                            }
                            value = !desc.isAuthenticated() || desc.getErrorMessage() != null ? this.getNotAvailableBecauseAuthenticationIsRequiredText() : this.getNotAvailableText();
                        }
                    }
                } else {
                    value = Message.EMPTY;
                }
                if (value.equals(this.getNotAvailableText())) {
                    if (!isRunning) {
                        value = this.getNotAvailableBecauseServerIsDownText();
                    }
                    if (!desc.isAuthenticated() || desc.getErrorMessage() != null) {
                        value = this.getNotAvailableBecauseAuthenticationIsRequiredText();
                    }
                }
                boolean doWrite = true;
                boolean isReplicated = replicatedLabel.equals(tableModel.getValueAt(i, 3));
                if (j == 4 || j == 5) {
                    doWrite = isReplicated;
                }
                if (!doWrite) continue;
                this.writeLabelValue(labels[j], value, isReplicated ? labelWidth : labelWidthWithoutReplicated);
            }
        }
    }

    private void writeLabelValue(Message label, Message value, int maxLabelWidth) {
        MessageBuilder buf = new MessageBuilder();
        buf.append(label);
        int extra = maxLabelWidth - label.length();
        for (int i = 0; i < extra; ++i) {
            buf.append(" ");
        }
        buf.append(" ").append(String.valueOf(value));
        this.getOutputStream().println(this.wrapText(buf.toMessage()));
    }

    private Message centerTitle(Message text) {
        Message centered;
        if (text.length() <= Utils.getCommandLineMaxLineWidth() - 8) {
            MessageBuilder buf = new MessageBuilder();
            int extra = Math.min(10, (Utils.getCommandLineMaxLineWidth() - 8 - text.length()) / 2);
            for (int i = 0; i < extra; ++i) {
                buf.append(" ");
            }
            buf.append("--- " + text + " ---");
            centered = buf.toMessage();
        } else {
            centered = text;
        }
        return centered;
    }

    private TrustManager getTrustManager() {
        if (this.useInteractiveTrustManager) {
            return this.interactiveTrustManager;
        }
        return this.argParser.getTrustManager();
    }

    public boolean isAdvancedMode() {
        return false;
    }

    public boolean isInteractive() {
        return this.argParser.isInteractive();
    }

    public boolean isMenuDrivenMode() {
        return true;
    }

    public boolean isQuiet() {
        return false;
    }

    public boolean isScriptFriendly() {
        return this.argParser.isScriptFriendly();
    }

    public boolean isVerbose() {
        return true;
    }

    private Message wrapText(Message text) {
        return Message.raw(StaticUtils.wrapText(text, Utils.getCommandLineMaxLineWidth()), new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ErrorReturnCode {
        SUCCESSFUL(0),
        SUCCESSFUL_NOP(0),
        ERROR_UNEXPECTED(1),
        ERROR_PARSING_ARGS(2),
        USER_CANCELLED_OR_DATA_ERROR(3),
        ERROR_READING_CONFIGURATION_WITH_LDAP(4);

        private int returnCode;

        private ErrorReturnCode(int returnCode) {
            this.returnCode = returnCode;
        }

        public int getReturnCode() {
            return this.returnCode;
        }
    }
}

