/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel;

import java.io.OutputStream;
import java.util.ArrayList;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.client.cli.SecureConnectionCliArgs;
import org.opends.server.admin.client.cli.SecureConnectionCliParser;
import org.opends.server.tools.ToolConstants;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class StatusCliArgumentParser
extends SecureConnectionCliParser {
    private BooleanArgument noPromptArg;
    private BooleanArgument scriptFriendlyArg;

    public StatusCliArgumentParser(String mainClassName) {
        super(mainClassName, AdminToolMessages.INFO_STATUS_CLI_USAGE_DESCRIPTION.get(), false);
    }

    public void initializeGlobalArguments(OutputStream outStream) throws ArgumentException {
        ArrayList<Argument> defaultArgs = new ArrayList<Argument>(this.createGlobalArguments(outStream));
        defaultArgs.remove(this.secureArgsList.portArg);
        defaultArgs.remove(this.secureArgsList.hostNameArg);
        defaultArgs.remove(this.verboseArg);
        defaultArgs.remove(this.noPropertiesFileArg);
        defaultArgs.remove(this.propertiesFileArg);
        this.noPromptArg = new BooleanArgument("no-prompt", ToolConstants.OPTION_SHORT_NO_PROMPT, "no-prompt", ToolMessages.INFO_DESCRIPTION_NO_PROMPT.get());
        defaultArgs.add(0, this.noPromptArg);
        this.scriptFriendlyArg = new BooleanArgument("script-friendly", Character.valueOf('s'), "script-friendly", ToolMessages.INFO_DESCRIPTION_SCRIPT_FRIENDLY.get());
        defaultArgs.add(1, this.scriptFriendlyArg);
        StringArgument propertiesFileArgument = new StringArgument("propertiesFilePath", null, "propertiesFilePath", false, false, true, ToolMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get());
        defaultArgs.add(propertiesFileArgument);
        this.setFilePropertiesArgument(propertiesFileArgument);
        BooleanArgument noPropertiesFileArgument = new BooleanArgument("noPropertiesFileArgument", null, "noPropertiesFile", ToolMessages.INFO_DESCRIPTION_NO_PROP_FILE.get());
        defaultArgs.add(noPropertiesFileArgument);
        this.setNoPropertiesFileArgument(noPropertiesFileArgument);
        this.initializeGlobalArguments(defaultArgs);
    }

    SecureConnectionCliArgs getSecureArgsList() {
        return this.secureArgsList;
    }

    public boolean isInteractive() {
        return !this.noPromptArg.isPresent();
    }

    public boolean isScriptFriendly() {
        return this.scriptFriendlyArg.isPresent();
    }

    public String getExplicitBindDn() {
        String dn = null;
        if (this.secureArgsList.bindDnArg.isPresent()) {
            dn = this.secureArgsList.bindDnArg.getValue();
        }
        return dn;
    }

    public String getDefaultBindDn() {
        return this.secureArgsList.bindDnArg.getDefaultValue();
    }
}

