/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.statuspanel.ui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import org.opends.guitools.statuspanel.ListenerDescriptor;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.quicksetup.ui.SortableTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenersTableModel
extends AbstractTableModel
implements SortableTableModel,
Comparator<ListenerDescriptor> {
    private static final long serialVersionUID = -1121308303480078376L;
    private HashSet<ListenerDescriptor> data = new HashSet();
    private ArrayList<ListenerDescriptor> dataArray = new ArrayList();
    private final Message[] COLUMN_NAMES = new Message[]{AdminToolMessages.INFO_ADDRESS_PORT_COLUMN.get(), AdminToolMessages.INFO_PROTOCOL_COLUMN.get(), AdminToolMessages.INFO_STATE_COLUMN.get()};
    private int sortColumn = 0;
    private boolean sortAscending = true;

    public void setData(Set<ListenerDescriptor> newData) {
        if (!((Object)newData).equals(this.data)) {
            this.data.clear();
            this.data.addAll(newData);
            this.dataArray.clear();
            TreeSet<ListenerDescriptor> sortedSet = new TreeSet<ListenerDescriptor>(this);
            sortedSet.addAll(this.data);
            this.dataArray.addAll(sortedSet);
            this.fireTableDataChanged();
        }
    }

    @Override
    public void forceResort() {
        this.dataArray.clear();
        TreeSet<ListenerDescriptor> sortedSet = new TreeSet<ListenerDescriptor>(this);
        sortedSet.addAll(this.data);
        this.dataArray.addAll(sortedSet);
        this.fireTableDataChanged();
    }

    @Override
    public int compare(ListenerDescriptor desc1, ListenerDescriptor desc2) {
        int result = 0;
        if (this.sortColumn == 0) {
            result = desc1.getAddressPort().compareTo(desc2.getAddressPort());
            if (result == 0) {
                result = desc1.getProtocolDescription().compareTo(desc2.getProtocolDescription());
            }
            if (result == 0) {
                result = desc1.getState().compareTo(desc2.getState());
            }
        } else if (this.sortColumn == 1) {
            result = desc1.getProtocolDescription().compareTo(desc2.getProtocolDescription());
            if (result == 0) {
                result = desc1.getAddressPort().compareTo(desc2.getAddressPort());
            }
            if (result == 0) {
                result = desc1.getState().compareTo(desc2.getState());
            }
        } else {
            result = desc1.getState().compareTo(desc2.getState());
            if (result == 0) {
                result = desc1.getAddressPort().compareTo(desc2.getAddressPort());
            }
            if (result == 0) {
                result = desc1.getProtocolDescription().compareTo(desc2.getProtocolDescription());
            }
        }
        if (!this.sortAscending) {
            result = -result;
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.dataArray.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        String v;
        ListenerDescriptor desc = this.dataArray.get(row);
        if (col == 0) {
            v = desc.getAddressPort();
        } else if (col == 1) {
            v = desc.getProtocolDescription().toString();
        } else {
            switch (desc.getState()) {
                case ENABLED: {
                    v = AdminToolMessages.INFO_ENABLED_LABEL.get().toString();
                    break;
                }
                case DISABLED: {
                    v = AdminToolMessages.INFO_DISABLED_LABEL.get().toString();
                    break;
                }
                case UNKNOWN: {
                    v = AdminToolMessages.INFO_UNKNOWN_LABEL.get().toString();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state: " + (Object)((Object)desc.getState()));
                }
            }
        }
        return v;
    }

    @Override
    public String getColumnName(int col) {
        return this.COLUMN_NAMES[col].toString();
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(int sortColumn) {
        this.sortColumn = sortColumn;
    }
}

