/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.DynamicConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildInformation
implements Comparable {
    private static final Logger LOG = Logger.getLogger(BuildInformation.class.getName());
    private Map<String, String> values = new HashMap<String, String>();

    public static BuildInformation create(Installation installation) throws ApplicationException {
        BuildInformation bi = new BuildInformation();
        ArrayList<String> args = new ArrayList<String>();
        args.add(Utils.getScriptPath(Utils.getPath(installation.getServerStartCommandFile())));
        args.add("-F");
        ProcessBuilder pb = new ProcessBuilder(args);
        InputStream is = null;
        OutputStream out = null;
        final boolean[] done = new boolean[]{false};
        try {
            Map<String, String> env = pb.environment();
            env.put("OPENDS_JAVA_HOME", System.getProperty("java.home"));
            env.put("OPENDS_EXIT_NO_BACKGROUND", "true");
            Process process = pb.start();
            is = process.getInputStream();
            final OutputStream fOut = out = process.getOutputStream();
            if (Utils.isWindows()) {
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        while (!done[0]) {
                            try {
                                Thread.sleep(5000L);
                                if (done[0]) continue;
                                fOut.write(Constants.LINE_SEPARATOR.getBytes());
                                fOut.flush();
                            }
                            catch (Throwable t) {
                                LOG.log(Level.WARNING, "Error writing to process: " + t, t);
                            }
                        }
                    }
                });
                t.start();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            bi.values.put("Name", line);
            StringBuilder sb = new StringBuilder();
            while (null != (line = reader.readLine())) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(line);
                int colonIndex = line.indexOf(58);
                if (-1 == colonIndex) continue;
                String name = line.substring(0, colonIndex).trim();
                String value = line.substring(colonIndex + 1).trim();
                bi.values.put(name, value);
            }
            int resultCode = process.waitFor();
            if (resultCode != 0) {
                if (sb.length() == 0) {
                    throw new ApplicationException(ReturnCode.START_ERROR, QuickSetupMessages.INFO_ERROR_CREATING_BUILD_INFO.get(), null);
                }
                throw new ApplicationException(ReturnCode.START_ERROR, QuickSetupMessages.INFO_ERROR_CREATING_BUILD_INFO_MSG.get(sb.toString()), null);
            }
        }
        catch (IOException e) {
            throw new ApplicationException(ReturnCode.START_ERROR, QuickSetupMessages.INFO_ERROR_CREATING_BUILD_INFO.get(), e);
        }
        catch (InterruptedException ie) {
            throw new ApplicationException(ReturnCode.START_ERROR, QuickSetupMessages.INFO_ERROR_CREATING_BUILD_INFO.get(), ie);
        }
        finally {
            done[0] = true;
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        BuildInformation.checkNotNull(bi.values, "Name", "Major Version", "Minor Version", "Point Version", "Revision Number");
        return bi;
    }

    public static BuildInformation fromBuildString(String bn) throws IllegalArgumentException {
        Pattern p = Pattern.compile("((\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+))");
        Matcher m = p.matcher(bn);
        if (!m.matches()) {
            throw new IllegalArgumentException("'" + bn + "' is not a build string");
        }
        BuildInformation bi = new BuildInformation();
        try {
            bi.values.put("Major Version", m.group(2));
            bi.values.put("Minor Version", m.group(3));
            bi.values.put("Point Version", m.group(4));
            bi.values.put("Revision Number", m.group(5));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing build number " + bn);
        }
        return bi;
    }

    public static BuildInformation getCurrent() throws ApplicationException {
        BuildInformation bi = new BuildInformation();
        bi.values.put("Name", DynamicConstants.FULL_VERSION_STRING);
        bi.values.put("Build ID", "20080610152800Z");
        bi.values.put("Major Version", String.valueOf(1));
        bi.values.put("Minor Version", String.valueOf(0));
        bi.values.put("Point Version", String.valueOf(0));
        bi.values.put("Version Qualifier", String.valueOf(""));
        bi.values.put("Revision Number", String.valueOf(4337L));
        bi.values.put("Fix IDs", "");
        bi.values.put("Debug Build", String.valueOf(false));
        bi.values.put("Build OS", "SunOS 5.10 x86");
        bi.values.put("Build User", "builds");
        bi.values.put("Build Java Version", "1.5.0_12");
        bi.values.put("Build Java Vendor", "Sun Microsystems Inc.");
        bi.values.put("Build JVM Version", "1.5.0_12-b04");
        bi.values.put("Build JVM Vendor", "Sun Microsystems Inc.");
        BuildInformation.checkNotNull(bi.values, "Name", "Major Version", "Minor Version", "Point Version", "Revision Number");
        return bi;
    }

    public String getName() {
        return this.values.get("Name");
    }

    public String getBuildId() {
        return this.values.get("Build ID");
    }

    public Integer getMajorVersion() {
        return new Integer(this.values.get("Major Version"));
    }

    public Integer getMinorVersion() {
        return new Integer(this.values.get("Minor Version"));
    }

    public Integer getPointVersion() {
        return new Integer(this.values.get("Point Version"));
    }

    public String getVersionQualifier() {
        return this.values.get("Version Qualifier");
    }

    public Integer getRevisionNumber() {
        return new Integer(this.values.get("Revision Number"));
    }

    public Set<Integer> getIncompatibilityEventIds() {
        HashSet<Integer> ids = null;
        String idString = this.values.get("Upgrade Event IDs");
        if (idString != null) {
            String[] sa;
            ids = new HashSet<Integer>();
            for (String s : sa = idString.split(",")) {
                try {
                    ids.add(Integer.parseInt(s));
                }
                catch (NumberFormatException nfe) {
                    LOG.log(Level.INFO, "invalid upgrade incompatibility ID " + s);
                }
            }
        }
        return ids;
    }

    public String getBuildString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMajorVersion());
        sb.append(".");
        sb.append(this.getMinorVersion());
        sb.append(".");
        sb.append(this.getPointVersion());
        sb.append(".");
        sb.append(this.getRevisionNumber());
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        String id = this.getBuildId();
        if (id != null) {
            sb.append(" (").append(QuickSetupMessages.INFO_GENERAL_BUILD_ID.get()).append(": ").append(id).append(")");
        }
        return sb.toString();
    }

    public int compareTo(Object o) {
        BuildInformation bi = (BuildInformation)o;
        if (this.getMajorVersion().equals(bi.getMajorVersion())) {
            if (this.getMinorVersion().equals(bi.getMinorVersion())) {
                if (this.getPointVersion().equals(bi.getPointVersion())) {
                    if (this.getRevisionNumber().equals(bi.getRevisionNumber())) {
                        return 0;
                    }
                    if (this.getRevisionNumber() < bi.getRevisionNumber()) {
                        return -1;
                    }
                } else if (this.getPointVersion() < bi.getPointVersion()) {
                    return -1;
                }
            } else if (this.getMinorVersion() < bi.getMinorVersion()) {
                return -1;
            }
        } else if (this.getMajorVersion() < bi.getMajorVersion()) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.compareTo(o) == 0;
    }

    public int hashCode() {
        int hc = 11;
        hc = 31 * hc + this.getMajorVersion().hashCode();
        hc = 31 * hc + this.getMinorVersion().hashCode();
        hc = 31 * hc + this.getPointVersion().hashCode();
        hc = 31 * hc + this.getRevisionNumber().hashCode();
        return hc;
    }

    private static void checkNotNull(Map values, String ... props) throws ApplicationException {
        for (String prop : props) {
            if (null != values.get(prop)) continue;
            throw new ApplicationException(ReturnCode.TOOL_ERROR, QuickSetupMessages.INFO_ERROR_PROP_VALUE.get(prop), null);
        }
    }
}

