/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.util.FileManager;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stage {
    private static final Logger LOG = Logger.getLogger(Stage.class.getName());
    private File root;
    private FileManager fm;
    private List<Message> messages = new LinkedList<Message>();

    public Stage(File root) {
        this.root = root;
        this.fm = new FileManager();
    }

    public void move(File destination, FileFilter fileFilter) throws ApplicationException {
        for (String fileName : this.root.list()) {
            File dest = new File(destination, fileName);
            File src = this.getSourceForCopy(fileName, dest);
            this.fm.copyRecursively(src, destination, fileFilter, true);
        }
    }

    public List<Message> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    private File getSourceForCopy(String fileName, File dest) {
        File src = new File(this.root, fileName);
        if ("upgrade.bat".equals(fileName) && Utils.isWindows()) {
            try {
                if (this.fm.filesDiffer(src, dest)) {
                    File renamedUpgradeBatFile = new File(this.root, "upgrade.bat.NEW");
                    if (src.renameTo(renamedUpgradeBatFile)) {
                        src = renamedUpgradeBatFile;
                        this.messages.add(QuickSetupMessages.INFO_NEW_UPGRADE_SCRIPT_AVAILABLE.get("upgrade.bat", "upgrade.bat.NEW"));
                    } else {
                        LOG.log(Level.INFO, "Failed to rename new version of 'upgrade.bat' to 'upgrade.bat.NEW'");
                    }
                }
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Exception comparing files " + e.getMessage());
            }
        }
        return src;
    }
}

