/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.RDN;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Reference<C extends ConfigurationClient, S extends Configuration> {
    private final String name;
    private final ManagedObjectPath<C, S> path;
    private final InstantiableRelationDefinition<C, S> relation;

    public static <C extends ConfigurationClient, S extends Configuration> Reference<C, S> parseDN(ManagedObjectPath<?, ?> p, InstantiableRelationDefinition<C, S> rd, String s) throws IllegalArgumentException {
        DN dn;
        AbstractManagedObjectDefinition<?, ?> d = p.getManagedObjectDefinition();
        RelationDefinition<?, ?> tmp = d.getRelationDefinition(rd.getName());
        if (tmp != rd) {
            throw new IllegalArgumentException("The relation \"" + rd.getName() + "\" is not associated with the definition \"" + d.getName() + "\"");
        }
        try {
            dn = DN.decode(s);
        }
        catch (DirectoryException e) {
            throw new IllegalArgumentException("Unabled to decode the DN string: \"" + s + "\"");
        }
        RDN rdn = dn.getRDN();
        if (rdn == null) {
            throw new IllegalArgumentException("Unabled to decode the DN string: \"" + s + "\"");
        }
        AttributeValue av = rdn.getAttributeValue(0);
        if (av == null) {
            throw new IllegalArgumentException("Unabled to decode the DN string: \"" + s + "\"");
        }
        String name = av.getStringValue();
        DN expected = p.child(rd, name).toDN();
        if (!dn.equals(expected)) {
            throw new IllegalArgumentException("Unabled to decode the DN string: \"" + s + "\"");
        }
        return new Reference<C, S>(p, rd, name);
    }

    public static <C extends ConfigurationClient, S extends Configuration> Reference<C, S> parseName(ManagedObjectPath<?, ?> p, InstantiableRelationDefinition<C, S> rd, String s) throws IllegalArgumentException {
        AbstractManagedObjectDefinition<?, ?> d = p.getManagedObjectDefinition();
        RelationDefinition<?, ?> tmp = d.getRelationDefinition(rd.getName());
        if (tmp != rd) {
            throw new IllegalArgumentException("The relation \"" + rd.getName() + "\" is not associated with the definition \"" + d.getName() + "\"");
        }
        if (s.trim().length() == 0) {
            throw new IllegalArgumentException("Empty names are not allowed");
        }
        return new Reference<C, S>(p, rd, s);
    }

    private Reference(ManagedObjectPath<?, ?> parent, InstantiableRelationDefinition<C, S> relation, String name) throws IllegalArgumentException {
        this.relation = relation;
        this.name = name;
        this.path = parent.child(relation, name);
    }

    public String getName() {
        return this.name;
    }

    public String getNormalizedName() {
        PropertyDefinition<?> pd = this.relation.getNamingPropertyDefinition();
        return this.normalizeName(pd);
    }

    public DN toDN() {
        return this.path.toDN();
    }

    public String toString() {
        return this.name;
    }

    private <T> String normalizeName(PropertyDefinition<T> pd) {
        if (pd != null) {
            try {
                T tvalue = pd.decodeValue(this.name);
                return pd.normalizeValue(tvalue);
            }
            catch (IllegalPropertyValueStringException e) {
                // empty catch block
            }
        }
        String s = this.name.trim().replaceAll(" +", " ");
        return StaticUtils.toLowerCase(s);
    }
}

