/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.client.AdminClientException;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationRejectedException
extends AdminClientException {
    private static final long serialVersionUID = 8547688890613079044L;
    private final Collection<Message> messages;
    private final OperationType type;
    private final Message ufn;

    private static Message getDefaultMessage(Collection<Message> messages) {
        Validator.ensureNotNull(messages);
        Validator.ensureTrue(!messages.isEmpty());
        if (messages.size() == 1) {
            return AdminMessages.ERR_OPERATION_REJECTED_EXCEPTION_SINGLE.get(messages.iterator().next());
        }
        return AdminMessages.ERR_OPERATION_REJECTED_EXCEPTION_PLURAL.get(OperationRejectedException.getSingleMessage(messages));
    }

    private static Message getSingleMessage(Collection<Message> messages) {
        if (messages.size() == 1) {
            return messages.iterator().next();
        }
        MessageBuilder builder = new MessageBuilder();
        boolean isFirst = true;
        for (Message m : messages) {
            if (!isFirst) {
                builder.append(";  ");
            }
            builder.append(m);
            isFirst = false;
        }
        return builder.toMessage();
    }

    public OperationRejectedException(OperationType type, Message ufn) {
        this(type, ufn, AdminMessages.ERR_OPERATION_REJECTED_DEFAULT.get());
    }

    public OperationRejectedException(OperationType type, Message ufn, Collection<Message> messages) {
        super(OperationRejectedException.getDefaultMessage(messages));
        this.messages = new ArrayList<Message>(messages);
        this.type = type;
        this.ufn = ufn;
    }

    public OperationRejectedException(OperationType type, Message ufn, Message message) {
        this(type, ufn, Collections.singleton(message));
    }

    public Collection<Message> getMessages() {
        return Collections.unmodifiableCollection(this.messages);
    }

    public Message getMessagesAsSingleMessage() {
        return OperationRejectedException.getSingleMessage(this.messages);
    }

    public OperationType getOperationType() {
        return this.type;
    }

    public Message getUserFriendlyName() {
        return this.ufn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperationType {
        CREATE,
        DELETE,
        MODIFY;

    }
}

