/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.List;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.MatchingRuleCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class MatchingRule<T extends MatchingRuleCfg> {
    public abstract void initializeMatchingRule(T var1) throws ConfigException, InitializationException;

    public boolean isConfigurationAcceptable(MatchingRuleCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public void finalizeMatchingRule() {
    }

    public abstract String getName();

    public abstract String getOID();

    public final String getNameOrOID() {
        String name = this.getName();
        if (name == null || name.length() == 0) {
            return this.getOID();
        }
        return name;
    }

    public abstract String getDescription();

    public abstract String getSyntaxOID();

    public boolean isObsolete() {
        return false;
    }

    public abstract ByteString normalizeValue(ByteString var1) throws DirectoryException;

    public abstract ConditionResult valuesMatch(ByteString var1, ByteString var2);

    public final int hashCode() {
        int hashCode = 0;
        String oidString = this.getOID();
        int oidLength = oidString.length();
        for (int i = 0; i < oidLength; ++i) {
            hashCode += oidString.charAt(i);
        }
        return hashCode;
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchingRule)) {
            return false;
        }
        return this.getOID().equals(((MatchingRule)o).getOID());
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public final void toString(StringBuilder buffer) {
        buffer.append("( ");
        buffer.append(this.getOID());
        buffer.append(" NAME '");
        buffer.append(this.getName());
        String description = this.getDescription();
        if (description != null && description.length() > 0) {
            buffer.append("' DESC '");
            buffer.append(description);
        }
        if (this.isObsolete()) {
            buffer.append("' OBSOLETE SYNTAX ");
        } else {
            buffer.append("' SYNTAX ");
        }
        buffer.append(this.getSyntaxOID());
        buffer.append(" )");
    }
}

