/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.List;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.PasswordStorageSchemeCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class PasswordStorageScheme<T extends PasswordStorageSchemeCfg> {
    public abstract void initializePasswordStorageScheme(T var1) throws ConfigException, InitializationException;

    public boolean isConfigurationAcceptable(PasswordStorageSchemeCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public void finalizePasswordStorageScheme() {
    }

    public abstract String getStorageSchemeName();

    public abstract ByteString encodePassword(ByteString var1) throws DirectoryException;

    public abstract ByteString encodePasswordWithScheme(ByteString var1) throws DirectoryException;

    public abstract boolean passwordMatches(ByteString var1, ByteString var2);

    public abstract boolean supportsAuthPasswordSyntax();

    public String getAuthPasswordSchemeName() {
        return this.getStorageSchemeName();
    }

    public abstract ByteString encodeAuthPassword(ByteString var1) throws DirectoryException;

    public abstract boolean authPasswordMatches(ByteString var1, String var2, String var3);

    public abstract boolean isReversible();

    public abstract ByteString getPlaintextValue(ByteString var1) throws DirectoryException;

    public abstract ByteString getAuthPasswordPlaintextValue(String var1, String var2) throws DirectoryException;

    public abstract boolean isStorageSchemeSecure();
}

