/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.Aci;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.AciTargetMatchContext;
import org.opends.server.authorization.dseecompat.EnumTargetOperator;
import org.opends.server.authorization.dseecompat.TargAttrFilterList;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.SearchFilter;

public class TargAttrFilters {
    TargAttrFilterList firstFilterList = null;
    TargAttrFilterList secondFilterList = null;
    private static final int firstOpPos = 1;
    private static final int restOfExpressionPos = 2;
    private static final String ADD_OR_DEL_KEYWORD_GROUP = "(add|del)";
    private static final String secondOpSeparator = "\\)\\s*,";
    public static final String secondOp = "[,]{1}\\s*del|add\\s*={1}\\s*";
    private static final String firstOp = "^(add|del)\\s*={1}\\s*";
    private static String restOfExpression = "(.+)";
    private static String keywordFullPattern = "^(add|del)\\s*={1}\\s*" + restOfExpression;
    EnumTargetOperator op;
    private int operationMask;

    public TargAttrFilters(EnumTargetOperator op, TargAttrFilterList firstFilterList, TargAttrFilterList secondFilterList) {
        this.op = op;
        this.firstFilterList = firstFilterList;
        this.operationMask = firstFilterList.getMask();
        if (secondFilterList != null) {
            this.operationMask |= secondFilterList.getMask();
            this.secondFilterList = secondFilterList;
        }
    }

    public static TargAttrFilters decode(EnumTargetOperator type, String expression) throws AciException {
        String opPattern;
        Pattern fullPattern = Pattern.compile(keywordFullPattern);
        Matcher matcher = fullPattern.matcher(expression);
        if (!matcher.find()) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGATTRFILTERS_EXPRESSION.get(expression);
            throw new AciException(message);
        }
        String firstOp = matcher.group(1);
        String subExpression = matcher.group(2);
        String[] temp = subExpression.split(opPattern = "[,]{1}\\s*" + firstOp + "\\s*" + "={1}" + "\\s*");
        if (temp.length > 1) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGATTRFILTERS_OPS_MATCH.get(expression);
            throw new AciException(message);
        }
        String[] filterLists = subExpression.split(secondOp, -1);
        if (filterLists.length > 2) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGATTRFILTERS_MAX_FILTER_LISTS.get(expression);
            throw new AciException(message);
        }
        if (filterLists.length == 1) {
            String rg;
            String[] filterList2 = subExpression.split(secondOpSeparator);
            if (filterList2.length == 2) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGATTRFILTERS_EXPRESSION.get(expression);
                throw new AciException(message);
            }
            String sOp = "del";
            if (TargAttrFilters.getMask(firstOp) == 8192) {
                sOp = "add";
            }
            if (subExpression.indexOf(rg = sOp + "=") != -1) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGATTRFILTERS_EXPRESSION.get(expression);
                throw new AciException(message);
            }
        }
        filterLists[0] = filterLists[0].trim();
        if (!filterLists[0].endsWith(")")) {
            Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGATTRFILTERS_EXPRESSION.get(expression);
            throw new AciException(message);
        }
        TargAttrFilterList firstFilterList = TargAttrFilterList.decode(TargAttrFilters.getMask(firstOp), filterLists[0]);
        TargAttrFilterList secondFilterList = null;
        if (filterLists.length == 2) {
            String filterList = filterLists[1].trim();
            if (!filterList.startsWith("=")) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_TARGATTRFILTERS_EXPRESSION.get(expression);
                throw new AciException(message);
            }
            String temp2 = filterList.substring(1, filterList.length());
            String secondOp = "del";
            if (TargAttrFilters.getMask(firstOp) == 8192) {
                secondOp = "add";
            }
            secondFilterList = TargAttrFilterList.decode(TargAttrFilters.getMask(secondOp), temp2);
        }
        return new TargAttrFilters(type, firstFilterList, secondFilterList);
    }

    private static int getMask(String op) {
        if (op.equals("add")) {
            return 4096;
        }
        return 8192;
    }

    public TargAttrFilterList getTargAttrFilterList(AciTargetMatchContext matchCtx) {
        TargAttrFilterList filterList = null;
        int mask = 0;
        if ((matchCtx.hasRights(2048) || matchCtx.hasRights(32)) && this.hasMask(4096)) {
            mask = 4096;
        } else if ((matchCtx.hasRights(1024) || matchCtx.hasRights(16)) && this.hasMask(8192)) {
            mask = 8192;
        }
        if (this.firstFilterList.hasMask(mask)) {
            filterList = this.firstFilterList;
        } else if (this.secondFilterList != null && this.secondFilterList.hasMask(mask)) {
            filterList = this.secondFilterList;
        }
        return filterList;
    }

    public boolean isApplicableMod(AciTargetMatchContext matchCtx, Aci aci) {
        TargAttrFilterList attrFilterList = this.getTargAttrFilterList(matchCtx);
        if (attrFilterList == null) {
            return true;
        }
        LinkedHashMap<AttributeType, SearchFilter> filterList = attrFilterList.getAttributeTypeFilterList();
        boolean attrMatched = true;
        AttributeType attrType = matchCtx.getCurrentAttributeType();
        if (attrType != null && filterList.containsKey(attrType)) {
            AttributeValue value = matchCtx.getCurrentAttributeValue();
            SearchFilter filter = filterList.get(attrType);
            attrMatched = this.matchFilterAttributeValue(attrType, value, filter);
            matchCtx.setTargAttrFiltersMatch(true);
            if (matchCtx.isGetEffectiveRightsEval()) {
                matchCtx.setTargAttrFiltersAciName(aci.getName());
                matchCtx.addTargAttrFiltersMatchAci(aci);
            }
            if (this.op.equals((Object)EnumTargetOperator.NOT_EQUALITY)) {
                attrMatched = !attrMatched;
            }
        }
        return attrMatched;
    }

    public boolean isApplicableAddDel(AciTargetMatchContext matchCtx) {
        TargAttrFilterList attrFilterList = this.getTargAttrFilterList(matchCtx);
        if (attrFilterList == null) {
            return true;
        }
        LinkedHashMap<AttributeType, SearchFilter> filterList = attrFilterList.getAttributeTypeFilterList();
        boolean attrMatched = true;
        Entry resEntry = matchCtx.getResourceEntry();
        for (Map.Entry<AttributeType, SearchFilter> e : filterList.entrySet()) {
            AttributeType attrType = e.getKey();
            SearchFilter f = e.getValue();
            if (resEntry.hasAttribute(attrType)) {
                ListIterator<Attribute> attrIterator = resEntry.getAttribute(attrType).listIterator();
                while (attrIterator.hasNext() && attrMatched) {
                    Attribute a = attrIterator.next();
                    attrMatched = this.matchFilterAttributeValues(a, attrType, f);
                }
            }
            if (attrMatched) continue;
            break;
        }
        if (this.op.equals((Object)EnumTargetOperator.NOT_EQUALITY)) {
            attrMatched = !attrMatched;
        }
        return attrMatched;
    }

    private boolean matchFilterAttributeValues(Attribute a, AttributeType attrType, SearchFilter filter) {
        boolean filterMatch = true;
        Iterator valIterator = a.getValues().iterator();
        while (valIterator.hasNext() && filterMatch) {
            AttributeValue value = (AttributeValue)valIterator.next();
            filterMatch = this.matchFilterAttributeValue(attrType, value, filter);
        }
        return filterMatch;
    }

    private boolean matchFilterAttributeValue(AttributeType attrType, AttributeValue value, SearchFilter filter) {
        boolean filterMatch;
        LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>();
        values.add(new AttributeValue(attrType, value.getValue()));
        Attribute attr = new Attribute(attrType, attrType.toString(), values);
        Entry e = new Entry(DN.nullDN(), null, null, null);
        e.addAttribute(attr, new ArrayList<AttributeValue>());
        try {
            filterMatch = filter.matchesEntry(e);
        }
        catch (DirectoryException ex) {
            filterMatch = false;
        }
        return filterMatch;
    }

    public boolean hasMask(int mask) {
        return (this.operationMask & mask) != 0;
    }
}

