/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import java.util.LinkedList;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.SortValues;
import org.opends.server.backends.jeb.VLVIndex;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.SortKey;

public class SortValuesSet {
    private long[] entryIDs;
    private int[] valuesBytesOffsets;
    private byte[] valuesBytes;
    private byte[] keyBytes;
    private VLVIndex vlvIndex;

    public SortValuesSet(VLVIndex vlvIndex) {
        this.keyBytes = new byte[0];
        this.entryIDs = null;
        this.valuesBytes = null;
        this.valuesBytesOffsets = null;
        this.vlvIndex = vlvIndex;
    }

    public SortValuesSet(byte[] keyBytes, byte[] dataBytes, VLVIndex vlvIndex) {
        this.keyBytes = keyBytes;
        this.vlvIndex = vlvIndex;
        if (dataBytes == null) {
            this.entryIDs = new long[0];
            return;
        }
        this.entryIDs = SortValuesSet.getEncodedIDs(dataBytes, 0);
        int valuesBytesOffset = this.entryIDs.length * 8 + 4;
        int valuesBytesLength = dataBytes.length - valuesBytesOffset;
        this.valuesBytes = new byte[valuesBytesLength];
        System.arraycopy(dataBytes, valuesBytesOffset, this.valuesBytes, 0, valuesBytesLength);
        this.valuesBytesOffsets = null;
    }

    private SortValuesSet() {
    }

    public boolean add(long entryID, AttributeValue[] values) throws DatabaseException, DirectoryException {
        if (values == null) {
            return false;
        }
        if (this.entryIDs == null || this.entryIDs.length == 0) {
            this.entryIDs = new long[1];
            this.entryIDs[0] = entryID;
            this.valuesBytes = this.attributeValuesToDatabase(values);
            if (this.valuesBytesOffsets != null) {
                this.valuesBytesOffsets = new int[1];
                this.valuesBytesOffsets[0] = 0;
            }
            return true;
        }
        if (this.vlvIndex.comparator.compare(this, this.entryIDs.length - 1, entryID, values) < 0) {
            long[] updatedEntryIDs = new long[this.entryIDs.length + 1];
            System.arraycopy(this.entryIDs, 0, updatedEntryIDs, 0, this.entryIDs.length);
            updatedEntryIDs[this.entryIDs.length] = entryID;
            byte[] newValuesBytes = this.attributeValuesToDatabase(values);
            byte[] updatedValuesBytes = new byte[this.valuesBytes.length + newValuesBytes.length];
            System.arraycopy(this.valuesBytes, 0, updatedValuesBytes, 0, this.valuesBytes.length);
            System.arraycopy(newValuesBytes, 0, updatedValuesBytes, this.valuesBytes.length, newValuesBytes.length);
            if (this.valuesBytesOffsets != null) {
                int[] updatedValuesBytesOffsets = new int[this.valuesBytesOffsets.length + 1];
                System.arraycopy(this.valuesBytesOffsets, 0, updatedValuesBytesOffsets, 0, this.valuesBytesOffsets.length);
                updatedValuesBytesOffsets[this.valuesBytesOffsets.length] = updatedValuesBytes.length - newValuesBytes.length;
                this.valuesBytesOffsets = updatedValuesBytesOffsets;
            }
            this.entryIDs = updatedEntryIDs;
            this.valuesBytes = updatedValuesBytes;
            return true;
        }
        int pos = this.binarySearch(entryID, values);
        if (pos >= 0) {
            if (this.entryIDs[pos] == entryID) {
                return false;
            }
        } else {
            pos = -(pos + 1);
        }
        long[] updatedEntryIDs = new long[this.entryIDs.length + 1];
        System.arraycopy(this.entryIDs, 0, updatedEntryIDs, 0, pos);
        System.arraycopy(this.entryIDs, pos, updatedEntryIDs, pos + 1, this.entryIDs.length - pos);
        updatedEntryIDs[pos] = entryID;
        byte[] newValuesBytes = this.attributeValuesToDatabase(values);
        int valuesPos = this.valuesBytesOffsets[pos];
        byte[] updatedValuesBytes = new byte[this.valuesBytes.length + newValuesBytes.length];
        System.arraycopy(this.valuesBytes, 0, updatedValuesBytes, 0, valuesPos);
        System.arraycopy(this.valuesBytes, valuesPos, updatedValuesBytes, valuesPos + newValuesBytes.length, this.valuesBytes.length - valuesPos);
        System.arraycopy(newValuesBytes, 0, updatedValuesBytes, valuesPos, newValuesBytes.length);
        if (this.valuesBytesOffsets != null) {
            int[] updatedValuesBytesOffsets = new int[this.valuesBytesOffsets.length + 1];
            System.arraycopy(this.valuesBytesOffsets, 0, updatedValuesBytesOffsets, 0, pos);
            for (int i = pos; i < this.valuesBytesOffsets.length; ++i) {
                updatedValuesBytesOffsets[i + 1] = this.valuesBytesOffsets[i] + newValuesBytes.length;
            }
            updatedValuesBytesOffsets[pos] = this.valuesBytesOffsets[pos];
            this.valuesBytesOffsets = updatedValuesBytesOffsets;
        }
        this.entryIDs = updatedEntryIDs;
        this.valuesBytes = updatedValuesBytes;
        return true;
    }

    public boolean remove(long entryID, AttributeValue[] values) throws DatabaseException, DirectoryException {
        int pos;
        if (this.entryIDs == null || this.entryIDs.length == 0) {
            return false;
        }
        if (this.valuesBytesOffsets == null) {
            this.updateValuesBytesOffsets();
        }
        if ((pos = this.binarySearch(entryID, values)) < 0) {
            return false;
        }
        long[] updatedEntryIDs = new long[this.entryIDs.length - 1];
        System.arraycopy(this.entryIDs, 0, updatedEntryIDs, 0, pos);
        System.arraycopy(this.entryIDs, pos + 1, updatedEntryIDs, pos, this.entryIDs.length - pos - 1);
        int valuesPos = this.valuesBytesOffsets[pos];
        int valuesLength = pos < this.valuesBytesOffsets.length - 1 ? this.valuesBytesOffsets[pos + 1] - valuesPos : this.valuesBytes.length - valuesPos;
        byte[] updatedValuesBytes = new byte[this.valuesBytes.length - valuesLength];
        System.arraycopy(this.valuesBytes, 0, updatedValuesBytes, 0, valuesPos);
        System.arraycopy(this.valuesBytes, valuesPos + valuesLength, updatedValuesBytes, valuesPos, this.valuesBytes.length - valuesPos - valuesLength);
        int[] updatedValuesBytesOffsets = new int[this.valuesBytesOffsets.length - 1];
        System.arraycopy(this.valuesBytesOffsets, 0, updatedValuesBytesOffsets, 0, pos);
        for (int i = pos + 1; i < this.valuesBytesOffsets.length; ++i) {
            updatedValuesBytesOffsets[i - 1] = this.valuesBytesOffsets[i] - valuesLength;
        }
        this.entryIDs = updatedEntryIDs;
        this.valuesBytes = updatedValuesBytes;
        this.valuesBytesOffsets = updatedValuesBytesOffsets;
        return true;
    }

    public SortValuesSet split(int splitLength) {
        if (this.valuesBytesOffsets == null) {
            this.updateValuesBytesOffsets();
        }
        long[] splitEntryIDs = new long[splitLength];
        byte[] splitValuesBytes = new byte[this.valuesBytes.length - this.valuesBytesOffsets[this.valuesBytesOffsets.length - splitLength]];
        int[] splitValuesBytesOffsets = new int[splitLength];
        long[] updatedEntryIDs = new long[this.entryIDs.length - splitEntryIDs.length];
        System.arraycopy(this.entryIDs, 0, updatedEntryIDs, 0, updatedEntryIDs.length);
        System.arraycopy(this.entryIDs, updatedEntryIDs.length, splitEntryIDs, 0, splitEntryIDs.length);
        byte[] updatedValuesBytes = new byte[this.valuesBytesOffsets[this.valuesBytesOffsets.length - splitLength]];
        System.arraycopy(this.valuesBytes, 0, updatedValuesBytes, 0, updatedValuesBytes.length);
        System.arraycopy(this.valuesBytes, updatedValuesBytes.length, splitValuesBytes, 0, splitValuesBytes.length);
        int[] updatedValuesBytesOffsets = new int[this.valuesBytesOffsets.length - splitValuesBytesOffsets.length];
        System.arraycopy(this.valuesBytesOffsets, 0, updatedValuesBytesOffsets, 0, updatedValuesBytesOffsets.length);
        for (int i = updatedValuesBytesOffsets.length; i < this.valuesBytesOffsets.length; ++i) {
            splitValuesBytesOffsets[i - updatedValuesBytesOffsets.length] = this.valuesBytesOffsets[i] - this.valuesBytesOffsets[updatedValuesBytesOffsets.length];
        }
        SortValuesSet splitValuesSet = new SortValuesSet();
        splitValuesSet.entryIDs = splitEntryIDs;
        splitValuesSet.keyBytes = this.keyBytes;
        splitValuesSet.valuesBytes = splitValuesBytes;
        splitValuesSet.valuesBytesOffsets = splitValuesBytesOffsets;
        splitValuesSet.vlvIndex = this.vlvIndex;
        this.entryIDs = updatedEntryIDs;
        this.valuesBytes = updatedValuesBytes;
        this.valuesBytesOffsets = updatedValuesBytesOffsets;
        this.keyBytes = null;
        return splitValuesSet;
    }

    public byte[] toDatabase() {
        if (this.size() == 0) {
            return null;
        }
        byte[] entryIDBytes = JebFormat.entryIDListToDatabase(this.entryIDs);
        byte[] concatBytes = new byte[entryIDBytes.length + this.valuesBytes.length + 4];
        int v = this.entryIDs.length;
        for (int j = 3; j >= 0; --j) {
            concatBytes[j] = (byte)(v & 0xFF);
            v >>>= 8;
        }
        System.arraycopy(entryIDBytes, 0, concatBytes, 4, entryIDBytes.length);
        System.arraycopy(this.valuesBytes, 0, concatBytes, entryIDBytes.length + 4, this.valuesBytes.length);
        return concatBytes;
    }

    public static int getEncodedSize(byte[] bytes, int offset) {
        int v = 0;
        for (int i = offset; i < offset + 4; ++i) {
            v <<= 8;
            v |= bytes[i] & 0xFF;
        }
        return v;
    }

    public static long[] getEncodedIDs(byte[] bytes, int offset) {
        int length = SortValuesSet.getEncodedSize(bytes, offset);
        byte[] entryIDBytes = new byte[length * 8];
        System.arraycopy(bytes, offset + 4, entryIDBytes, 0, entryIDBytes.length);
        return JebFormat.entryIDListFromDatabase(entryIDBytes);
    }

    int binarySearch(long entryID, AttributeValue[] values) throws DatabaseException, DirectoryException {
        if (this.entryIDs == null || this.entryIDs.length == 0) {
            return -1;
        }
        int i = 0;
        int j = this.entryIDs.length - 1;
        while (i <= j) {
            int k = i + j >> 1;
            int l = this.vlvIndex.comparator.compare(this, k, entryID, values);
            if (l < 0) {
                i = k + 1;
                continue;
            }
            if (l > 0) {
                j = k - 1;
                continue;
            }
            return k;
        }
        return -(i + 1);
    }

    public int size() {
        if (this.entryIDs == null) {
            return 0;
        }
        return this.entryIDs.length;
    }

    public long[] getEntryIDs() {
        return this.entryIDs;
    }

    private byte[] attributeValuesToDatabase(AttributeValue[] values) throws DirectoryException {
        int totalValueBytes = 0;
        LinkedList<byte[]> valueBytes = new LinkedList<byte[]>();
        for (AttributeValue v : values) {
            byte[] vBytes = v == null ? new byte[]{} : v.getNormalizedValueBytes();
            byte[] vLength = ASN1Element.encodeLength(vBytes.length);
            valueBytes.add(vLength);
            valueBytes.add(vBytes);
            totalValueBytes += vLength.length + vBytes.length;
        }
        byte[] attrBytes = new byte[totalValueBytes];
        int pos = 0;
        for (byte[] b : valueBytes) {
            System.arraycopy(b, 0, attrBytes, pos, b.length);
            pos += b.length;
        }
        return attrBytes;
    }

    public byte[] getKeyBytes() throws DatabaseException, DirectoryException {
        if (this.entryIDs == null || this.entryIDs.length == 0) {
            return null;
        }
        if (this.keyBytes != null) {
            return this.keyBytes;
        }
        if (this.valuesBytesOffsets == null) {
            this.updateValuesBytesOffsets();
        }
        int vBytesPos = this.valuesBytesOffsets[this.valuesBytesOffsets.length - 1];
        int vBytesLength = this.valuesBytes.length - vBytesPos;
        byte[] idBytes = JebFormat.entryIDToDatabase(this.entryIDs[this.entryIDs.length - 1]);
        this.keyBytes = new byte[vBytesLength + idBytes.length];
        System.arraycopy(this.valuesBytes, vBytesPos, this.keyBytes, 0, vBytesLength);
        System.arraycopy(idBytes, 0, this.keyBytes, vBytesLength, idBytes.length);
        return this.keyBytes;
    }

    public SortValues getKeySortValues() throws DatabaseException, DirectoryException {
        if (this.entryIDs == null || this.entryIDs.length == 0) {
            return null;
        }
        if (this.keyBytes != null && this.keyBytes.length == 0) {
            return null;
        }
        EntryID id = new EntryID(this.entryIDs[this.entryIDs.length - 1]);
        SortKey[] sortKeys = this.vlvIndex.sortOrder.getSortKeys();
        int numValues = sortKeys.length;
        AttributeValue[] values = new AttributeValue[numValues];
        int i = (this.entryIDs.length - 1) * numValues;
        int j = 0;
        while (i < this.entryIDs.length * numValues) {
            values[j] = new AttributeValue(sortKeys[j].getAttributeType(), (ByteString)new ASN1OctetString(this.getValue(i)));
            ++i;
            ++j;
        }
        return new SortValues(id, values, this.vlvIndex.sortOrder);
    }

    public SortValues getSortValues(int index) throws JebException, DatabaseException, DirectoryException {
        if (this.entryIDs == null || this.entryIDs.length == 0) {
            return null;
        }
        EntryID id = new EntryID(this.entryIDs[index]);
        SortKey[] sortKeys = this.vlvIndex.sortOrder.getSortKeys();
        int numValues = sortKeys.length;
        AttributeValue[] values = new AttributeValue[numValues];
        int i = index * numValues;
        int j = 0;
        while (i < (index + 1) * numValues) {
            byte[] value = this.getValue(i);
            if (value != null) {
                values[j] = new AttributeValue(sortKeys[j].getAttributeType(), (ByteString)new ASN1OctetString(value));
            }
            ++i;
            ++j;
        }
        return new SortValues(id, values, this.vlvIndex.sortOrder);
    }

    private void updateValuesBytesOffsets() {
        this.valuesBytesOffsets = new int[this.entryIDs.length];
        int vBytesPos = 0;
        int numAttributes = this.vlvIndex.sortOrder.getSortKeys().length;
        for (int pos = 0; pos < this.entryIDs.length; ++pos) {
            this.valuesBytesOffsets[pos] = vBytesPos;
            for (int i = 0; i < numAttributes; ++i) {
                int valueLength = this.valuesBytes[vBytesPos] & 0x7F;
                if (valueLength != this.valuesBytes[vBytesPos++]) {
                    int valueLengthBytes = valueLength;
                    valueLength = 0;
                    int j = 0;
                    while (j < valueLengthBytes) {
                        valueLength = valueLength << 8 | this.valuesBytes[vBytesPos] & 0xFF;
                        ++j;
                        ++vBytesPos;
                    }
                }
                vBytesPos += valueLength;
            }
        }
    }

    public byte[] getValue(int index) throws DatabaseException, DirectoryException {
        if (this.valuesBytesOffsets == null) {
            this.updateValuesBytesOffsets();
        }
        int numAttributes = this.vlvIndex.sortOrder.getSortKeys().length;
        int vIndex = index / numAttributes;
        int vOffset = index % numAttributes;
        int vBytesPos = this.valuesBytesOffsets[vIndex];
        for (int i = 0; i <= vOffset; ++i) {
            int valueLength = this.valuesBytes[vBytesPos] & 0x7F;
            if (valueLength != this.valuesBytes[vBytesPos++]) {
                int valueLengthBytes = valueLength;
                valueLength = 0;
                int j = 0;
                while (j < valueLengthBytes) {
                    valueLength = valueLength << 8 | this.valuesBytes[vBytesPos] & 0xFF;
                    ++j;
                    ++vBytesPos;
                }
            }
            if (i == vOffset) {
                if (valueLength == 0) {
                    return null;
                }
                byte[] valueBytes = new byte[valueLength];
                System.arraycopy(this.valuesBytes, vBytesPos, valueBytes, 0, valueLength);
                return valueBytes;
            }
            vBytesPos += valueLength;
        }
        return new byte[0];
    }
}

