/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPException;
import org.opends.server.types.SearchFilter;

public class LDAPAssertionRequestControl
extends Control {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private LDAPFilter rawFilter;
    private SearchFilter filter;

    public LDAPAssertionRequestControl(boolean isCritical, LDAPFilter rawFilter) {
        super("1.3.6.1.1.12", isCritical, new ASN1OctetString(rawFilter.encode().encode()));
        this.rawFilter = rawFilter;
        this.filter = null;
    }

    public LDAPAssertionRequestControl(String oid, boolean isCritical, LDAPFilter rawFilter) {
        super(oid, isCritical, new ASN1OctetString(rawFilter.encode().encode()));
        this.rawFilter = rawFilter;
        this.filter = null;
    }

    private LDAPAssertionRequestControl(String oid, boolean isCritical, LDAPFilter rawFilter, ASN1OctetString encodedValue) {
        super(oid, isCritical, encodedValue);
        this.rawFilter = rawFilter;
        this.filter = null;
    }

    public static LDAPAssertionRequestControl decodeControl(Control control) throws LDAPException {
        ASN1Element valueElement;
        if (!control.hasValue()) {
            Message message = ProtocolMessages.ERR_LDAPASSERT_NO_CONTROL_VALUE.get();
            throw new LDAPException(2, message);
        }
        try {
            valueElement = ASN1Element.decode(control.getValue().value());
        }
        catch (ASN1Exception ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            Message message = ProtocolMessages.ERR_LDAPASSERT_INVALID_CONTROL_VALUE.get(ae.getMessage());
            throw new LDAPException(2, message, ae);
        }
        return new LDAPAssertionRequestControl(control.getOID(), control.isCritical(), LDAPFilter.decode(valueElement), control.getValue());
    }

    public LDAPFilter getRawFilter() {
        return this.rawFilter;
    }

    public void setRawFilter(LDAPFilter rawFilter) {
        this.rawFilter = rawFilter;
        this.filter = null;
        this.setValue(new ASN1OctetString(rawFilter.encode().encode()));
    }

    public SearchFilter getSearchFilter() throws DirectoryException {
        if (this.filter == null) {
            this.filter = this.rawFilter.toSearchFilter();
        }
        return this.filter;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("LDAPAssertionRequestControl(criticality=");
        buffer.append(this.isCritical());
        buffer.append(",filter=\"");
        this.rawFilter.toString(buffer);
        buffer.append("\")");
    }
}

