/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.MatchedValuesFilter;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Control;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchedValuesControl
extends Control {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    ArrayList<MatchedValuesFilter> filters;

    public MatchedValuesControl(boolean isCritical, ArrayList<MatchedValuesFilter> filters) {
        super("1.2.826.0.1.3344810.2.3", isCritical, MatchedValuesControl.encodeValue(filters));
        this.filters = filters;
    }

    public MatchedValuesControl(String oid, boolean isCritical, ArrayList<MatchedValuesFilter> filters) {
        super(oid, isCritical, MatchedValuesControl.encodeValue(filters));
        this.filters = filters;
    }

    private MatchedValuesControl(String oid, boolean isCritical, ArrayList<MatchedValuesFilter> filters, ASN1OctetString encodedValue) {
        super(oid, isCritical, encodedValue);
        this.filters = filters;
    }

    private static ASN1OctetString encodeValue(ArrayList<MatchedValuesFilter> filters) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(filters.size());
        for (MatchedValuesFilter f : filters) {
            elements.add(f.encode());
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public static MatchedValuesControl decodeControl(Control control) throws LDAPException {
        ArrayList<ASN1Element> elements;
        if (!control.hasValue()) {
            Message message = ProtocolMessages.ERR_MATCHEDVALUES_NO_CONTROL_VALUE.get();
            throw new LDAPException(2, message);
        }
        try {
            elements = ASN1Sequence.decodeAsSequence(control.getValue().value()).elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_MATCHEDVALUES_CANNOT_DECODE_VALUE_AS_SEQUENCE.get(StaticUtils.getExceptionMessage(e));
            throw new LDAPException(2, message);
        }
        if (elements.isEmpty()) {
            Message message = ProtocolMessages.ERR_MATCHEDVALUES_NO_FILTERS.get();
            throw new LDAPException(2, message);
        }
        ArrayList<MatchedValuesFilter> filters = new ArrayList<MatchedValuesFilter>(elements.size());
        for (ASN1Element e : elements) {
            filters.add(MatchedValuesFilter.decode(e));
        }
        return new MatchedValuesControl(control.getOID(), control.isCritical(), filters, control.getValue());
    }

    public ArrayList<MatchedValuesFilter> getFilters() {
        return this.filters;
    }

    public boolean valueMatches(AttributeType type, AttributeValue value) {
        for (MatchedValuesFilter f : this.filters) {
            try {
                if (!f.valueMatches(type, value)) continue;
                return true;
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        if (this.filters.size() == 1) {
            buffer.append("MatchedValuesControl(filter=\"");
            this.filters.get(0).toString(buffer);
            buffer.append("\")");
        } else {
            buffer.append("MatchedValuesControl(filters=\"(");
            for (MatchedValuesFilter f : this.filters) {
                f.toString(buffer);
            }
            buffer.append(")\")");
        }
    }
}

