/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.AccessControlHandlerCfgDefn;
import org.opends.server.admin.std.server.AccessControlHandlerCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.AccessControlHandler;
import org.opends.server.api.AlertGenerator;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DefaultAccessControlHandler;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccessControlConfigManager
implements AlertGenerator,
ConfigurationChangeListener<AccessControlHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.core.AccessControlConfigManager";
    private static AccessControlConfigManager instance = null;
    private AtomicReference<AccessControlHandler> accessControlHandler = new AtomicReference<DefaultAccessControlHandler>(new DefaultAccessControlHandler());
    private AccessControlHandlerCfg currentConfiguration = null;

    private AccessControlConfigManager() {
    }

    public static AccessControlConfigManager getInstance() {
        if (instance == null) {
            instance = new AccessControlConfigManager();
        }
        return instance;
    }

    public boolean isAccessControlEnabled() {
        return this.currentConfiguration.isEnabled();
    }

    public AccessControlHandler getAccessControlHandler() {
        return this.accessControlHandler.get();
    }

    public void initializeAccessControl() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        AccessControlHandlerCfg accessControlConfiguration = rootConfiguration.getAccessControlHandler();
        accessControlConfiguration.addChangeListener(this);
        this.currentConfiguration = null;
        this.updateConfiguration(accessControlConfiguration);
    }

    private void updateConfiguration(AccessControlHandlerCfg newConfiguration) throws ConfigException, InitializationException {
        String newHandlerClass = null;
        boolean enabledOld = false;
        boolean enabledNew = newConfiguration.isEnabled();
        if (this.currentConfiguration == null) {
            newHandlerClass = enabledNew ? newConfiguration.getJavaClass() : DefaultAccessControlHandler.class.getName();
            this.accessControlHandler.getAndSet(this.getHandler(newHandlerClass, newConfiguration, true, false));
        } else {
            enabledOld = this.currentConfiguration.isEnabled();
            if (enabledNew) {
                newHandlerClass = newConfiguration.getJavaClass();
                String oldHandlerClass = this.currentConfiguration.getJavaClass();
                if (!enabledOld) {
                    AccessControlHandler<? extends AccessControlHandlerCfg> oldHandler = this.accessControlHandler.getAndSet(this.getHandler(newHandlerClass, newConfiguration, true, true));
                    oldHandler.finalizeAccessControlHandler();
                } else if (!newHandlerClass.equals(oldHandlerClass)) {
                    AccessControlHandler<? extends AccessControlHandlerCfg> oldHandler = this.accessControlHandler.getAndSet(this.getHandler(newHandlerClass, newConfiguration, true, true));
                    oldHandler.finalizeAccessControlHandler();
                } else {
                    this.getHandler(newHandlerClass, newConfiguration, false, false);
                }
            } else if (enabledOld && !enabledNew) {
                newHandlerClass = DefaultAccessControlHandler.class.getName();
                AccessControlHandler<? extends AccessControlHandlerCfg> oldHandler = this.accessControlHandler.getAndSet(this.getHandler(newHandlerClass, newConfiguration, false, true));
                oldHandler.finalizeAccessControlHandler();
            }
        }
        this.currentConfiguration = newConfiguration;
    }

    AccessControlHandler<? extends AccessControlHandlerCfg> getHandler(String handlerClassName, AccessControlHandlerCfg config, boolean initHandler, boolean logMessage) throws InitializationException {
        AccessControlHandler newHandler;
        try {
            if (handlerClassName.equals(DefaultAccessControlHandler.class.getName())) {
                newHandler = new DefaultAccessControlHandler();
                newHandler.initializeAccessControlHandler(null);
                if (logMessage) {
                    Message message = ConfigMessages.WARN_CONFIG_AUTHZ_DISABLED.get();
                    ErrorLogger.logError(message);
                    if (this.currentConfiguration != null) {
                        DirectoryServer.sendAlertNotification(this, "org.opends.server.AccessControlDisabled", message);
                    }
                }
            } else {
                newHandler = this.loadHandler(handlerClassName, config, initHandler);
                if (logMessage) {
                    Message message = ConfigMessages.NOTE_CONFIG_AUTHZ_ENABLED.get(handlerClassName);
                    ErrorLogger.logError(message);
                    if (this.currentConfiguration != null) {
                        DirectoryServer.sendAlertNotification(this, "org.opends.server.AccessControlEnabled", message);
                    }
                }
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_AUTHZ_UNABLE_TO_INSTANTIATE_HANDLER.get(handlerClassName, String.valueOf(config.dn().toString()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
        return newHandler;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(AccessControlHandlerCfg configuration, List<Message> unacceptableReasons) {
        try {
            if (configuration.isEnabled()) {
                this.loadHandler(configuration.getJavaClass(), configuration, false);
            }
        }
        catch (InitializationException e) {
            unacceptableReasons.add(e.getMessageObject());
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(AccessControlHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            this.updateConfiguration(configuration);
        }
        catch (ConfigException e) {
            messages.add(e.getMessageObject());
            resultCode = ResultCode.CONSTRAINT_VIOLATION;
        }
        catch (InitializationException e) {
            messages.add(e.getMessageObject());
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        return new ConfigChangeResult(resultCode, false, messages);
    }

    @Override
    public DN getComponentEntryDN() {
        return this.currentConfiguration.dn();
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.AccessControlDisabled", "This alert type will be used to notify administrators that the access control handler has been disabled.");
        alerts.put("org.opends.server.AccessControlEnabled", "This alert type will be used to notify administrators that the access control handler has been enabled.");
        return alerts;
    }

    private AccessControlHandler<? extends AccessControlHandlerCfg> loadHandler(String className, AccessControlHandlerCfg configuration, boolean initialize) throws InitializationException {
        try {
            AccessControlHandlerCfgDefn definition = AccessControlHandlerCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<AccessControlHandler> providerClass = propertyDefinition.loadClass(className, AccessControlHandler.class);
            AccessControlHandler provider = providerClass.newInstance();
            if (configuration != null) {
                Method method = provider.getClass().getMethod("initializeAccessControlHandler", configuration.configurationClass());
                if (initialize) {
                    method.invoke((Object)provider, configuration);
                }
            } else {
                Method method = provider.getClass().getMethod("isConfigurationAcceptable", AccessControlHandlerCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)provider, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_AUTHZ_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return provider;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_AUTHZ_UNABLE_TO_INSTANTIATE_HANDLER.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

