/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.PasswordStorageSchemeCfgDefn;
import org.opends.server.admin.std.server.PasswordStorageSchemeCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordStorageSchemeConfigManager
implements ConfigurationChangeListener<PasswordStorageSchemeCfg>,
ConfigurationAddListener<PasswordStorageSchemeCfg>,
ConfigurationDeleteListener<PasswordStorageSchemeCfg> {
    private ConcurrentHashMap<DN, PasswordStorageScheme> storageSchemes = new ConcurrentHashMap();

    public void initializePasswordStorageSchemes() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addPasswordStorageSchemeAddListener(this);
        rootConfiguration.addPasswordStorageSchemeDeleteListener(this);
        for (String schemeName : rootConfiguration.listPasswordStorageSchemes()) {
            PasswordStorageSchemeCfg config = rootConfiguration.getPasswordStorageScheme(schemeName);
            config.addChangeListener(this);
            if (!config.isEnabled()) continue;
            String className = config.getJavaClass();
            this.loadAndInstallPasswordStorageScheme(className, config);
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(PasswordStorageSchemeCfg configuration, List<Message> unacceptableReasons) {
        boolean status = true;
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadPasswordStorageScheme(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                status = false;
            }
        }
        return status;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(PasswordStorageSchemeCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        DN configEntryDN = configuration.dn();
        PasswordStorageScheme storageScheme = this.storageSchemes.get(configEntryDN);
        if (!configuration.isEnabled()) {
            if (storageScheme != null) {
                this.uninstallPasswordStorageScheme(configEntryDN);
            }
            return changeResult;
        }
        String newClassName = configuration.getJavaClass();
        if (storageScheme != null) {
            boolean classIsNew;
            String curClassName = storageScheme.getClass().getName();
            boolean bl = classIsNew = !newClassName.equals(curClassName);
            if (classIsNew) {
                changeResult.setAdminActionRequired(true);
            }
            return changeResult;
        }
        try {
            this.loadAndInstallPasswordStorageScheme(newClassName, configuration);
        }
        catch (InitializationException ie) {
            changeResult.addMessage(ie.getMessageObject());
            changeResult.setResultCode(DirectoryServer.getServerErrorResultCode());
            return changeResult;
        }
        return changeResult;
    }

    @Override
    public boolean isConfigurationAddAcceptable(PasswordStorageSchemeCfg configuration, List<Message> unacceptableReasons) {
        boolean status = true;
        DN configEntryDN = configuration.dn();
        if (this.storageSchemes.containsKey(configEntryDN)) {
            Message message = ConfigMessages.ERR_CONFIG_PWSCHEME_EXISTS.get(String.valueOf(configEntryDN));
            unacceptableReasons.add(message);
            status = false;
        } else if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadPasswordStorageScheme(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                status = false;
            }
        }
        return status;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(PasswordStorageSchemeCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        configuration.addChangeListener(this);
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadAndInstallPasswordStorageScheme(className, configuration);
            }
            catch (InitializationException ie) {
                changeResult.addMessage(ie.getMessageObject());
                changeResult.setResultCode(DirectoryServer.getServerErrorResultCode());
                return changeResult;
            }
        }
        return changeResult;
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(PasswordStorageSchemeCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(PasswordStorageSchemeCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        this.uninstallPasswordStorageScheme(configuration.dn());
        return changeResult;
    }

    private void loadAndInstallPasswordStorageScheme(String className, PasswordStorageSchemeCfg configuration) throws InitializationException {
        PasswordStorageScheme<? extends PasswordStorageSchemeCfg> schemeClass = this.loadPasswordStorageScheme(className, configuration, true);
        DN configEntryDN = configuration.dn();
        this.storageSchemes.put(configEntryDN, schemeClass);
        DirectoryServer.registerPasswordStorageScheme(configEntryDN, schemeClass);
    }

    private PasswordStorageScheme<? extends PasswordStorageSchemeCfg> loadPasswordStorageScheme(String className, PasswordStorageSchemeCfg configuration, boolean initialize) throws InitializationException {
        try {
            PasswordStorageSchemeCfgDefn definition = PasswordStorageSchemeCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<PasswordStorageScheme> schemeClass = propertyDefinition.loadClass(className, PasswordStorageScheme.class);
            PasswordStorageScheme passwordStorageScheme = schemeClass.newInstance();
            if (initialize) {
                Method method = passwordStorageScheme.getClass().getMethod("initializePasswordStorageScheme", configuration.configurationClass());
                method.invoke((Object)passwordStorageScheme, configuration);
            } else {
                Method method = passwordStorageScheme.getClass().getMethod("isConfigurationAcceptable", PasswordStorageSchemeCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)passwordStorageScheme, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_PWSCHEME_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return passwordStorageScheme;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_PWSCHEME_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    private void uninstallPasswordStorageScheme(DN configEntryDN) {
        PasswordStorageScheme scheme = this.storageSchemes.remove(configEntryDN);
        if (scheme != null) {
            DirectoryServer.deregisterPasswordStorageScheme(configEntryDN);
            scheme.finalizePasswordStorageScheme();
        }
    }
}

