/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Arrays;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.ClearPasswordStorageSchemeCfg;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearPasswordStorageScheme
extends PasswordStorageScheme<ClearPasswordStorageSchemeCfg> {
    @Override
    public void initializePasswordStorageScheme(ClearPasswordStorageSchemeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getStorageSchemeName() {
        return "CLEAR";
    }

    @Override
    public ByteString encodePassword(ByteString plaintext) throws DirectoryException {
        return plaintext.duplicate();
    }

    @Override
    public ByteString encodePasswordWithScheme(ByteString plaintext) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        buffer.append("CLEAR");
        buffer.append('}');
        buffer.append(plaintext.stringValue());
        return ByteStringFactory.create(buffer.toString());
    }

    @Override
    public boolean passwordMatches(ByteString plaintextPassword, ByteString storedPassword) {
        return Arrays.equals(plaintextPassword.value(), storedPassword.value());
    }

    @Override
    public boolean isReversible() {
        return true;
    }

    @Override
    public ByteString getPlaintextValue(ByteString storedPassword) throws DirectoryException {
        return storedPassword.duplicate();
    }

    @Override
    public boolean supportsAuthPasswordSyntax() {
        return false;
    }

    @Override
    public ByteString encodeAuthPassword(ByteString plaintext) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean authPasswordMatches(ByteString plaintextPassword, String authInfo, String authValue) {
        return false;
    }

    @Override
    public ByteString getAuthPasswordPlaintextValue(String authInfo, String authValue) throws DirectoryException {
        Message message = ExtensionMessages.ERR_PWSCHEME_DOES_NOT_SUPPORT_AUTH_PASSWORD.get(this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean isStorageSchemeSecure() {
        return false;
    }
}

