/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.DigestMD5SASLMechanismHandlerCfg;
import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.extensions.DigestMD5StateInfo;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LockManager;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestMD5SASLMechanismHandler
extends SASLMechanismHandler<DigestMD5SASLMechanismHandlerCfg>
implements ConfigurationChangeListener<DigestMD5SASLMechanismHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DigestMD5SASLMechanismHandlerCfg currentConfig;
    private IdentityMapper<?> identityMapper;
    private MessageDigest md5Digest;
    private Object digestLock;
    private SecureRandom randomGenerator;

    @Override
    public void initializeSASLMechanismHandler(DigestMD5SASLMechanismHandlerCfg configuration) throws ConfigException, InitializationException {
        configuration.addDigestMD5ChangeListener(this);
        this.currentConfig = configuration;
        this.digestLock = new Object();
        this.randomGenerator = new SecureRandom();
        try {
            this.md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_SASLDIGESTMD5_CANNOT_GET_MESSAGE_DIGEST.get(StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
        DN identityMapperDN = configuration.getIdentityMapperDN();
        this.identityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        DirectoryServer.registerSASLMechanismHandler("DIGEST-MD5", this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        this.currentConfig.removeDigestMD5ChangeListener(this);
        DirectoryServer.deregisterSASLMechanismHandler("DIGEST-MD5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void processSASLBind(BindOperation bindOperation) {
        byte[] responseAuth;
        List<ByteString> clearPasswords;
        Entry authZEntry;
        Entry userEntry;
        String responseAuthzID;
        String responseCharset;
        byte[] responseDigest;
        String responseDigestURI;
        String responseQoP;
        String responseNonceCountStr;
        String responseCNonce;
        String responseNonce;
        String responseRealm;
        String responseUserName;
        DigestMD5StateInfo stateInfo;
        block99: {
            AuthenticationInfo tempAuthInfo;
            InternalClientConnection tempConn;
            String lowerAuthzID;
            IdentityMapper<?> identityMapper;
            block100: {
                DN authzDN;
                DN userDN;
                Message message;
                DigestMD5SASLMechanismHandlerCfg config = this.currentConfig;
                identityMapper = this.identityMapper;
                String realm = config.getRealm();
                boolean initialAuth = true;
                ClientConnection clientConnection = bindOperation.getClientConnection();
                Object saslStateInfo = clientConnection.getSASLAuthStateInfo();
                if (saslStateInfo != null && saslStateInfo instanceof DigestMD5StateInfo) {
                    initialAuth = false;
                }
                if (initialAuth) {
                    StringBuilder challengeBuffer = new StringBuilder();
                    if (realm == null) {
                        Map<DN, Backend> suffixes = DirectoryServer.getPublicNamingContexts();
                        if (!suffixes.isEmpty()) {
                            Iterator<DN> iterator = suffixes.keySet().iterator();
                            challengeBuffer.append("realm=\"");
                            challengeBuffer.append(iterator.next().toNormalizedString());
                            challengeBuffer.append("\"");
                            while (iterator.hasNext()) {
                                challengeBuffer.append(",realm=\"");
                                challengeBuffer.append(iterator.next().toNormalizedString());
                                challengeBuffer.append("\"");
                            }
                        }
                    } else {
                        challengeBuffer.append("realm=\"");
                        challengeBuffer.append(realm);
                        challengeBuffer.append("\"");
                    }
                    String nonce = this.generateNonce();
                    if (challengeBuffer.length() > 0) {
                        challengeBuffer.append(",");
                    }
                    challengeBuffer.append("nonce=\"");
                    challengeBuffer.append(nonce);
                    challengeBuffer.append("\"");
                    challengeBuffer.append(",qop=\"auth\"");
                    challengeBuffer.append(",charset=utf-8");
                    challengeBuffer.append(",algorithm=md5-sess");
                    ASN1OctetString challenge = new ASN1OctetString(challengeBuffer.toString());
                    if (challenge.value().length >= 2048) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        Message message2 = ExtensionMessages.WARN_SASLDIGESTMD5_CHALLENGE_TOO_LONG.get(challenge.value().length);
                        bindOperation.setAuthFailureReason(message2);
                        ErrorLogger.logError(message2);
                        return;
                    }
                    DigestMD5StateInfo stateInfo2 = new DigestMD5StateInfo(nonce, "00000000");
                    clientConnection.setSASLAuthStateInfo(stateInfo2);
                    bindOperation.setResultCode(ResultCode.SASL_BIND_IN_PROGRESS);
                    bindOperation.setServerSASLCredentials(challenge);
                    return;
                }
                ASN1OctetString clientCredentials = bindOperation.getSASLCredentials();
                if (clientCredentials == null || clientCredentials.value().length == 0) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message3 = ExtensionMessages.ERR_SASLDIGESTMD5_NO_CREDENTIALS.get();
                    bindOperation.setAuthFailureReason(message3);
                    return;
                }
                stateInfo = (DigestMD5StateInfo)saslStateInfo;
                clientConnection.setSASLAuthStateInfo(null);
                responseUserName = null;
                responseRealm = null;
                responseNonce = null;
                responseCNonce = null;
                int responseNonceCount = -1;
                responseNonceCountStr = null;
                responseQoP = "auth";
                responseDigestURI = null;
                responseDigest = null;
                responseCharset = "ISO-8859-1";
                responseAuthzID = null;
                byte[] credBytes = clientCredentials.value();
                String credString = null;
                String lowerCreds = null;
                try {
                    credString = new String(credBytes, responseCharset);
                    lowerCreds = StaticUtils.toLowerCase(credString);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ErrorLogger.logError(ExtensionMessages.WARN_SASLDIGESTMD5_CANNOT_PARSE_ISO_CREDENTIALS.get(responseCharset, StaticUtils.getExceptionMessage(e)));
                }
                if (credString == null || lowerCreds.indexOf("charset=utf-8") >= 0) {
                    try {
                        credString = new String(credBytes, "UTF-8");
                        lowerCreds = StaticUtils.toLowerCase(credString);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        Message message4 = ExtensionMessages.WARN_SASLDIGESTMD5_CANNOT_PARSE_UTF8_CREDENTIALS.get(StaticUtils.getExceptionMessage(e));
                        bindOperation.setAuthFailureReason(message4);
                        return;
                    }
                }
                int pos = 0;
                int length = credString.length();
                while (pos < length) {
                    Message message5;
                    String tokenValue;
                    int equalPos = credString.indexOf(61, pos + 1);
                    if (equalPos < 0) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        Message message6 = ExtensionMessages.ERR_SASLDIGESTMD5_INVALID_TOKEN_IN_CREDENTIALS.get(credString, pos);
                        bindOperation.setAuthFailureReason(message6);
                        return;
                    }
                    String tokenName = lowerCreds.substring(pos, equalPos);
                    try {
                        StringBuilder valueBuffer = new StringBuilder();
                        pos = this.readToken(credString, equalPos + 1, length, valueBuffer);
                        tokenValue = valueBuffer.toString();
                    }
                    catch (DirectoryException de) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        bindOperation.setAuthFailureReason(de.getMessageObject());
                        return;
                    }
                    if (tokenName.equals("charset")) {
                        if (tokenValue.equalsIgnoreCase("utf-8")) continue;
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        message5 = ExtensionMessages.ERR_SASLDIGESTMD5_INVALID_CHARSET.get(tokenValue);
                        bindOperation.setAuthFailureReason(message5);
                        return;
                    }
                    if (tokenName.equals("username")) {
                        responseUserName = tokenValue;
                        continue;
                    }
                    if (tokenName.equals("realm")) {
                        responseRealm = tokenValue;
                        if (realm == null || responseRealm.equals(realm)) continue;
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        message5 = ExtensionMessages.ERR_SASLDIGESTMD5_INVALID_REALM.get(responseRealm);
                        bindOperation.setAuthFailureReason(message5);
                        return;
                    }
                    if (tokenName.equals("nonce")) {
                        responseNonce = tokenValue;
                        String requestNonce = stateInfo.getNonce();
                        if (responseNonce.equals(requestNonce)) continue;
                        message = ExtensionMessages.ERR_SASLDIGESTMD5_INVALID_NONCE.get();
                        clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, message);
                        return;
                    }
                    if (tokenName.equals("cnonce")) {
                        responseCNonce = tokenValue;
                        continue;
                    }
                    if (tokenName.equals("nc")) {
                        int storedNonce;
                        try {
                            responseNonceCountStr = tokenValue;
                            responseNonceCount = Integer.parseInt(responseNonceCountStr, 16);
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            message = ExtensionMessages.ERR_SASLDIGESTMD5_CANNOT_DECODE_NONCE_COUNT.get(tokenValue);
                            bindOperation.setAuthFailureReason(message);
                            return;
                        }
                        try {
                            storedNonce = Integer.parseInt(stateInfo.getNonceCount(), 16);
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            Message message7 = ExtensionMessages.ERR_SASLDIGESTMD5_CANNOT_DECODE_STORED_NONCE_COUNT.get(StaticUtils.getExceptionMessage(e));
                            bindOperation.setAuthFailureReason(message7);
                            return;
                        }
                        if (responseNonceCount == storedNonce + 1) continue;
                        message = ExtensionMessages.ERR_SASLDIGESTMD5_INVALID_NONCE_COUNT.get();
                        clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, message);
                        return;
                    }
                    if (tokenName.equals("qop")) {
                        responseQoP = tokenValue;
                        if (responseQoP.equals("auth")) continue;
                        if (responseQoP.equals("auth-int")) {
                            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            message5 = ExtensionMessages.ERR_SASLDIGESTMD5_INTEGRITY_NOT_SUPPORTED.get();
                            bindOperation.setAuthFailureReason(message5);
                            return;
                        }
                        if (responseQoP.equals("auth-conf")) {
                            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            message5 = ExtensionMessages.ERR_SASLDIGESTMD5_CONFIDENTIALITY_NOT_SUPPORTED.get();
                            bindOperation.setAuthFailureReason(message5);
                            return;
                        }
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        message5 = ExtensionMessages.ERR_SASLDIGESTMD5_INVALID_QOP.get(responseQoP);
                        bindOperation.setAuthFailureReason(message5);
                        return;
                    }
                    if (tokenName.equals("digest-uri")) {
                        String expectedDigestURI;
                        responseDigestURI = tokenValue;
                        String serverFQDN = config.getServerFqdn();
                        if (serverFQDN == null || serverFQDN.length() <= 0 || (expectedDigestURI = "ldap/" + serverFQDN).equalsIgnoreCase(responseDigestURI)) continue;
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        Message message8 = ExtensionMessages.ERR_SASLDIGESTMD5_INVALID_DIGEST_URI.get(responseDigestURI, expectedDigestURI);
                        bindOperation.setAuthFailureReason(message8);
                        return;
                    }
                    if (tokenName.equals("response")) {
                        try {
                            responseDigest = StaticUtils.hexStringToByteArray(tokenValue);
                            continue;
                        }
                        catch (ParseException pe) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, pe);
                            }
                            message = ExtensionMessages.ERR_SASLDIGESTMD5_CANNOT_PARSE_RESPONSE_DIGEST.get(StaticUtils.getExceptionMessage(pe));
                            bindOperation.setAuthFailureReason(message);
                            return;
                        }
                    }
                    if (tokenName.equals("authzid")) {
                        responseAuthzID = tokenValue;
                        continue;
                    }
                    if (tokenName.equals("maxbuf") || tokenName.equals("cipher")) continue;
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    message5 = ExtensionMessages.ERR_SASLDIGESTMD5_INVALID_RESPONSE_TOKEN.get(tokenName);
                    bindOperation.setAuthFailureReason(message5);
                    return;
                }
                if (responseUserName == null || responseUserName.length() == 0) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message9 = ExtensionMessages.ERR_SASLDIGESTMD5_NO_USERNAME_IN_RESPONSE.get();
                    bindOperation.setAuthFailureReason(message9);
                    return;
                }
                if (responseNonce == null) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message10 = ExtensionMessages.ERR_SASLDIGESTMD5_NO_NONCE_IN_RESPONSE.get();
                    bindOperation.setAuthFailureReason(message10);
                    return;
                }
                if (responseCNonce == null) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message11 = ExtensionMessages.ERR_SASLDIGESTMD5_NO_CNONCE_IN_RESPONSE.get();
                    bindOperation.setAuthFailureReason(message11);
                    return;
                }
                if (responseNonceCount < 0) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message12 = ExtensionMessages.ERR_SASLDIGESTMD5_NO_NONCE_COUNT_IN_RESPONSE.get();
                    bindOperation.setAuthFailureReason(message12);
                    return;
                }
                if (responseDigest == null) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message13 = ExtensionMessages.ERR_SASLDIGESTMD5_NO_DIGEST_IN_RESPONSE.get();
                    bindOperation.setAuthFailureReason(message13);
                    return;
                }
                if (responseDigestURI == null) {
                    responseDigestURI = "";
                }
                if (responseRealm == null) {
                    responseRealm = "";
                }
                userEntry = null;
                String lowerUserName = StaticUtils.toLowerCase(responseUserName);
                if (!lowerUserName.startsWith("dn:")) {
                    String userName = responseUserName;
                    if (lowerUserName.startsWith("u:")) {
                        if (lowerUserName.equals("u:")) {
                            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            Message message14 = ExtensionMessages.ERR_SASLDIGESTMD5_ZERO_LENGTH_USERNAME.get();
                            bindOperation.setAuthFailureReason(message14);
                            return;
                        }
                        userName = responseUserName.substring(2);
                    }
                    try {
                        userEntry = identityMapper.getEntryForID(userName);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        message = ExtensionMessages.ERR_SASLDIGESTMD5_CANNOT_MAP_USERNAME.get(String.valueOf(responseUserName), de.getMessageObject());
                        bindOperation.setAuthFailureReason(message);
                        return;
                    }
                }
                try {
                    userDN = DN.decode(responseUserName.substring(3));
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    message = ExtensionMessages.ERR_SASLDIGESTMD5_CANNOT_DECODE_USERNAME_AS_DN.get(responseUserName, de.getMessageObject());
                    bindOperation.setAuthFailureReason(message);
                    return;
                }
                if (userDN.isNullDN()) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message15 = ExtensionMessages.ERR_SASLDIGESTMD5_USERNAME_IS_NULL_DN.get();
                    bindOperation.setAuthFailureReason(message15);
                    return;
                }
                DN rootDN = DirectoryServer.getActualRootBindDN(userDN);
                if (rootDN != null) {
                    userDN = rootDN;
                }
                Lock readLock = null;
                for (int i = 0; i < 3 && (readLock = LockManager.lockRead(userDN)) == null; ++i) {
                }
                if (readLock == null) {
                    bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                    Message message16 = ExtensionMessages.INFO_SASLDIGESTMD5_CANNOT_LOCK_ENTRY.get(String.valueOf(userDN));
                    bindOperation.setAuthFailureReason(message16);
                    return;
                }
                try {
                    userEntry = DirectoryServer.getEntry(userDN);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message17 = ExtensionMessages.ERR_SASLDIGESTMD5_CANNOT_GET_ENTRY_BY_DN.get(String.valueOf(userDN), de.getMessageObject());
                    bindOperation.setAuthFailureReason(message17);
                    return;
                }
                finally {
                    LockManager.unlock(userDN, readLock);
                }
                if (userEntry == null) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message18 = ExtensionMessages.ERR_SASLDIGESTMD5_NO_MATCHING_ENTRIES.get(responseUserName);
                    bindOperation.setAuthFailureReason(message18);
                    return;
                }
                bindOperation.setSASLAuthUserEntry(userEntry);
                authZEntry = userEntry;
                if (responseAuthzID == null) break block99;
                if (responseAuthzID.length() == 0) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message19 = ExtensionMessages.ERR_SASLDIGESTMD5_EMPTY_AUTHZID.get();
                    bindOperation.setAuthFailureReason(message19);
                    return;
                }
                if (responseAuthzID.equals(responseUserName)) break block99;
                lowerAuthzID = StaticUtils.toLowerCase(responseAuthzID);
                if (!lowerAuthzID.startsWith("dn:")) break block100;
                try {
                    authzDN = DN.decode(responseAuthzID.substring(3));
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message20 = ExtensionMessages.ERR_SASLDIGESTMD5_AUTHZID_INVALID_DN.get(responseAuthzID, de.getMessageObject());
                    bindOperation.setAuthFailureReason(message20);
                    return;
                }
                DN actualAuthzDN = DirectoryServer.getActualRootBindDN(authzDN);
                if (actualAuthzDN != null) {
                    authzDN = actualAuthzDN;
                }
                if (authzDN.equals(userEntry.getDN())) break block99;
                AuthenticationInfo tempAuthInfo2 = new AuthenticationInfo(userEntry, DirectoryServer.isRootDN(userEntry.getDN()));
                InternalClientConnection tempConn2 = new InternalClientConnection(tempAuthInfo2);
                if (!tempConn2.hasPrivilege(Privilege.PROXIED_AUTH, bindOperation)) {
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message21 = ExtensionMessages.ERR_SASLDIGESTMD5_AUTHZID_INSUFFICIENT_PRIVILEGES.get(String.valueOf(userEntry.getDN()));
                    bindOperation.setAuthFailureReason(message21);
                    return;
                }
                if (authzDN.isNullDN()) {
                    authZEntry = null;
                    break block99;
                } else {
                    try {
                        authZEntry = DirectoryServer.getEntry(authzDN);
                        if (authZEntry == null) {
                            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            Message message22 = ExtensionMessages.ERR_SASLDIGESTMD5_AUTHZID_NO_SUCH_ENTRY.get(String.valueOf(authzDN));
                            bindOperation.setAuthFailureReason(message22);
                            return;
                        }
                        break block99;
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        Message message23 = ExtensionMessages.ERR_SASLDIGESTMD5_AUTHZID_CANNOT_GET_ENTRY.get(String.valueOf(authzDN), de.getMessageObject());
                        bindOperation.setAuthFailureReason(message23);
                        return;
                    }
                }
            }
            String idStr = lowerAuthzID.startsWith("u:") ? responseAuthzID.substring(2) : responseAuthzID;
            if (idStr.length() == 0) {
                authZEntry = null;
            } else {
                try {
                    authZEntry = identityMapper.getEntryForID(idStr);
                    if (authZEntry == null) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        Message message = ExtensionMessages.ERR_SASLDIGESTMD5_AUTHZID_NO_MAPPED_ENTRY.get(responseAuthzID);
                        bindOperation.setAuthFailureReason(message);
                        return;
                    }
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    Message message = ExtensionMessages.ERR_SASLDIGESTMD5_CANNOT_MAP_AUTHZID.get(responseAuthzID, de.getMessageObject());
                    bindOperation.setAuthFailureReason(message);
                    return;
                }
            }
            if (!(authZEntry != null && authZEntry.getDN().equals(userEntry.getDN()) || (tempConn = new InternalClientConnection(tempAuthInfo = new AuthenticationInfo(userEntry, DirectoryServer.isRootDN(userEntry.getDN())))).hasPrivilege(Privilege.PROXIED_AUTH, bindOperation))) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                Message message = ExtensionMessages.ERR_SASLDIGESTMD5_AUTHZID_INSUFFICIENT_PRIVILEGES.get(String.valueOf(userEntry.getDN()));
                bindOperation.setAuthFailureReason(message);
                return;
            }
        }
        try {
            PasswordPolicyState pwPolicyState = new PasswordPolicyState(userEntry, false);
            clearPasswords = pwPolicyState.getClearPasswords();
            if (clearPasswords == null || clearPasswords.isEmpty()) {
                bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                Message message = ExtensionMessages.ERR_SASLDIGESTMD5_NO_REVERSIBLE_PASSWORDS.get(String.valueOf(userEntry.getDN()));
                bindOperation.setAuthFailureReason(message);
                return;
            }
        }
        catch (Exception e) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            Message message = ExtensionMessages.ERR_SASLDIGESTMD5_CANNOT_GET_REVERSIBLE_PASSWORDS.get(String.valueOf(userEntry.getDN()), String.valueOf(e));
            bindOperation.setAuthFailureReason(message);
            return;
        }
        boolean matchFound = false;
        byte[] passwordBytes = null;
        for (ByteString clearPassword : clearPasswords) {
            byte[] generatedDigest;
            try {
                generatedDigest = this.generateResponseDigest(responseUserName, responseAuthzID, clearPassword.value(), responseRealm, responseNonce, responseCNonce, responseNonceCountStr, responseDigestURI, responseQoP, responseCharset);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                ErrorLogger.logError(ExtensionMessages.WARN_SASLDIGESTMD5_CANNOT_GENERATE_RESPONSE_DIGEST.get(StaticUtils.getExceptionMessage(e)));
                continue;
            }
            if (!Arrays.equals(responseDigest, generatedDigest)) continue;
            matchFound = true;
            passwordBytes = clearPassword.value();
            break;
        }
        if (!matchFound) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            Message message = ExtensionMessages.ERR_SASLDIGESTMD5_INVALID_CREDENTIALS.get();
            bindOperation.setAuthFailureReason(message);
            return;
        }
        try {
            responseAuth = this.generateResponseAuthDigest(responseUserName, responseAuthzID, passwordBytes, responseRealm, responseNonce, responseCNonce, responseNonceCountStr, responseDigestURI, responseQoP, responseCharset);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            Message message = ExtensionMessages.ERR_SASLDIGESTMD5_CANNOT_GENERATE_RESPONSE_AUTH_DIGEST.get(StaticUtils.getExceptionMessage(e));
            bindOperation.setAuthFailureReason(message);
            return;
        }
        ASN1OctetString responseAuthStr = new ASN1OctetString("rspauth=" + this.getHexString(responseAuth));
        stateInfo.setNonceCount(responseNonceCountStr);
        bindOperation.setResultCode(ResultCode.SUCCESS);
        bindOperation.setServerSASLCredentials(responseAuthStr);
        AuthenticationInfo authInfo = new AuthenticationInfo(userEntry, authZEntry, "DIGEST-MD5", DirectoryServer.isRootDN(userEntry.getDN()));
        bindOperation.setAuthenticationInfo(authInfo);
    }

    private String generateNonce() {
        byte[] nonceBytes = new byte[16];
        this.randomGenerator.nextBytes(nonceBytes);
        return Base64.encode(nonceBytes);
    }

    private int readToken(String credentials, int startPos, int length, StringBuilder token) throws DirectoryException {
        char c;
        if (startPos >= length) {
            return startPos;
        }
        boolean isEscaped = false;
        boolean isQuoted = false;
        int pos = startPos;
        if ((c = credentials.charAt(pos++)) == ',') {
            return pos;
        }
        if (c == '\"') {
            isQuoted = true;
        } else if (c == '\\') {
            isEscaped = true;
        } else {
            token.append(c);
        }
        while (pos < length) {
            c = credentials.charAt(pos++);
            if (isEscaped) {
                token.append(c);
                isEscaped = false;
                continue;
            }
            if (c == ',') {
                if (!isQuoted) break;
                token.append(c);
                continue;
            }
            if (c == '\"') {
                if (isQuoted) {
                    char c2;
                    if (pos >= length || (c2 = credentials.charAt(pos++)) == ',') break;
                    Message message = ExtensionMessages.ERR_SASLDIGESTMD5_INVALID_CLOSING_QUOTE_POS.get(pos - 2);
                    throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, message);
                }
                token.append(c);
                continue;
            }
            if (c == '\\') {
                isEscaped = true;
                continue;
            }
            token.append(c);
        }
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateResponseDigest(String userName, String authzID, byte[] password, String realm, String nonce, String cnonce, String nonceCount, String digestURI, String qop, String charset) throws UnsupportedEncodingException {
        Object object = this.digestLock;
        synchronized (object) {
            StringBuilder a1String1 = new StringBuilder();
            a1String1.append(userName);
            a1String1.append(':');
            a1String1.append(realm);
            a1String1.append(':');
            byte[] a1Bytes1a = a1String1.toString().getBytes(charset);
            byte[] a1Bytes1 = new byte[a1Bytes1a.length + password.length];
            System.arraycopy(a1Bytes1a, 0, a1Bytes1, 0, a1Bytes1a.length);
            System.arraycopy(password, 0, a1Bytes1, a1Bytes1a.length, password.length);
            byte[] urpHash = this.md5Digest.digest(a1Bytes1);
            StringBuilder a1String2 = new StringBuilder();
            a1String2.append(':');
            a1String2.append(nonce);
            a1String2.append(':');
            a1String2.append(cnonce);
            if (authzID != null) {
                a1String2.append(':');
                a1String2.append(authzID);
            }
            byte[] a1Bytes2a = a1String2.toString().getBytes(charset);
            byte[] a1Bytes2 = new byte[urpHash.length + a1Bytes2a.length];
            System.arraycopy(urpHash, 0, a1Bytes2, 0, urpHash.length);
            System.arraycopy(a1Bytes2a, 0, a1Bytes2, urpHash.length, a1Bytes2a.length);
            byte[] a1Hash = this.md5Digest.digest(a1Bytes2);
            byte[] a2Bytes = ("AUTHENTICATE:" + digestURI).getBytes(charset);
            byte[] a2Hash = this.md5Digest.digest(a2Bytes);
            String a1HashHex = this.getHexString(a1Hash);
            String a2HashHex = this.getHexString(a2Hash);
            StringBuilder kdString = new StringBuilder();
            kdString.append(a1HashHex);
            kdString.append(':');
            kdString.append(nonce);
            kdString.append(':');
            kdString.append(nonceCount);
            kdString.append(':');
            kdString.append(cnonce);
            kdString.append(':');
            kdString.append(qop);
            kdString.append(':');
            kdString.append(a2HashHex);
            return this.md5Digest.digest(kdString.toString().getBytes(charset));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateResponseAuthDigest(String userName, String authzID, byte[] password, String realm, String nonce, String cnonce, String nonceCount, String digestURI, String qop, String charset) throws UnsupportedEncodingException {
        Object object = this.digestLock;
        synchronized (object) {
            StringBuilder a1String1 = new StringBuilder();
            a1String1.append(userName);
            a1String1.append(':');
            a1String1.append(realm);
            a1String1.append(':');
            byte[] a1Bytes1a = a1String1.toString().getBytes(charset);
            byte[] a1Bytes1 = new byte[a1Bytes1a.length + password.length];
            System.arraycopy(a1Bytes1a, 0, a1Bytes1, 0, a1Bytes1a.length);
            System.arraycopy(password, 0, a1Bytes1, a1Bytes1a.length, password.length);
            byte[] urpHash = this.md5Digest.digest(a1Bytes1);
            StringBuilder a1String2 = new StringBuilder();
            a1String2.append(':');
            a1String2.append(nonce);
            a1String2.append(':');
            a1String2.append(cnonce);
            if (authzID != null) {
                a1String2.append(':');
                a1String2.append(authzID);
            }
            byte[] a1Bytes2a = a1String2.toString().getBytes(charset);
            byte[] a1Bytes2 = new byte[urpHash.length + a1Bytes2a.length];
            System.arraycopy(urpHash, 0, a1Bytes2, 0, urpHash.length);
            System.arraycopy(a1Bytes2a, 0, a1Bytes2, urpHash.length, a1Bytes2a.length);
            byte[] a1Hash = this.md5Digest.digest(a1Bytes2);
            String a2String = ":" + digestURI;
            if (qop.equals("auth-int") || qop.equals("auth-conf")) {
                a2String = a2String + ":00000000000000000000000000000000";
            }
            byte[] a2Bytes = a2String.getBytes(charset);
            byte[] a2Hash = this.md5Digest.digest(a2Bytes);
            String a1HashHex = this.getHexString(a1Hash);
            String a2HashHex = this.getHexString(a2Hash);
            StringBuilder kdString = new StringBuilder();
            kdString.append(a1HashHex);
            kdString.append(':');
            kdString.append(nonce);
            kdString.append(':');
            kdString.append(nonceCount);
            kdString.append(':');
            kdString.append(cnonce);
            kdString.append(':');
            kdString.append(qop);
            kdString.append(':');
            kdString.append(a2HashHex);
            return this.md5Digest.digest(kdString.toString().getBytes(charset));
        }
    }

    private String getHexString(byte[] byteArray) {
        StringBuilder buffer = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            buffer.append(StaticUtils.byteToLowerHex(b));
        }
        return buffer.toString();
    }

    @Override
    public boolean isPasswordBased(String mechanism) {
        return true;
    }

    @Override
    public boolean isSecure(String mechanism) {
        return true;
    }

    @Override
    public boolean isConfigurationAcceptable(SASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        DigestMD5SASLMechanismHandlerCfg config = (DigestMD5SASLMechanismHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(DigestMD5SASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(DigestMD5SASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DN identityMapperDN = configuration.getIdentityMapperDN();
        this.identityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
        this.currentConfig = configuration;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

