/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.FileBasedTrustManagerProviderCfg;
import org.opends.server.admin.std.server.TrustManagerProviderCfg;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.ExpirationCheckTrustManager;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedTrustManagerProvider
extends TrustManagerProvider<FileBasedTrustManagerProviderCfg>
implements ConfigurationChangeListener<FileBasedTrustManagerProviderCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN configEntryDN;
    private char[] trustStorePIN;
    private FileBasedTrustManagerProviderCfg currentConfig;
    private String trustStoreFile;
    private String trustStoreType;

    @Override
    public void initializeTrustManagerProvider(FileBasedTrustManagerProviderCfg configuration) throws ConfigException, InitializationException {
        this.currentConfig = configuration;
        this.configEntryDN = configuration.dn();
        configuration.addFileBasedChangeListener(this);
        this.trustStoreFile = configuration.getTrustStoreFile();
        File f = StaticUtils.getFileForPath(this.trustStoreFile);
        if (!f.exists() || !f.isFile()) {
            Message message = ExtensionMessages.ERR_FILE_TRUSTMANAGER_NO_SUCH_FILE.get(String.valueOf(this.trustStoreFile), String.valueOf(this.configEntryDN));
            throw new InitializationException(message);
        }
        this.trustStoreType = configuration.getTrustStoreType();
        if (this.trustStoreType == null) {
            this.trustStoreType = KeyStore.getDefaultType();
        }
        try {
            KeyStore.getInstance(this.trustStoreType);
        }
        catch (KeyStoreException kse) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, kse);
            }
            Message message = ExtensionMessages.ERR_FILE_TRUSTMANAGER_INVALID_TYPE.get(String.valueOf(this.trustStoreType), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(kse));
            throw new InitializationException(message);
        }
        String pinProperty = configuration.getTrustStorePinProperty();
        if (pinProperty == null) {
            String pinEnVar = configuration.getTrustStorePinEnvironmentVariable();
            if (pinEnVar == null) {
                String pinFilePath = configuration.getTrustStorePinFile();
                if (pinFilePath == null) {
                    String pinStr = configuration.getTrustStorePin();
                    this.trustStorePIN = (char[])(pinStr == null ? null : pinStr.toCharArray());
                } else {
                    String pinStr;
                    File pinFile = StaticUtils.getFileForPath(pinFilePath);
                    if (!pinFile.exists()) {
                        Message message = ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_NO_SUCH_FILE.get(String.valueOf(pinFilePath), String.valueOf(this.configEntryDN));
                        throw new InitializationException(message);
                    }
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new FileReader(pinFile));
                        pinStr = br.readLine();
                    }
                    catch (IOException ioe) {
                        Message message = ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_FILE_CANNOT_READ.get(String.valueOf(pinFilePath), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(ioe));
                        throw new InitializationException(message, (Throwable)ioe);
                    }
                    finally {
                        try {
                            br.close();
                        }
                        catch (Exception e) {}
                    }
                    if (pinStr == null) {
                        Message message = ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_FILE_EMPTY.get(String.valueOf(pinFilePath), String.valueOf(this.configEntryDN));
                        throw new InitializationException(message);
                    }
                    this.trustStorePIN = pinStr.toCharArray();
                }
            } else {
                String pinStr = System.getenv(pinEnVar);
                if (pinStr == null) {
                    Message message = ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_ENVAR_NOT_SET.get(String.valueOf(pinProperty), String.valueOf(this.configEntryDN));
                    throw new InitializationException(message);
                }
                this.trustStorePIN = pinStr.toCharArray();
            }
        } else {
            String pinStr = System.getProperty(pinProperty);
            if (pinStr == null) {
                Message message = ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_PROPERTY_NOT_SET.get(String.valueOf(pinProperty), String.valueOf(this.configEntryDN));
                throw new InitializationException(message);
            }
            this.trustStorePIN = pinStr.toCharArray();
        }
    }

    @Override
    public void finalizeTrustManagerProvider() {
        this.currentConfig.removeFileBasedChangeListener(this);
    }

    @Override
    public TrustManager[] getTrustManagers() throws DirectoryException {
        KeyStore trustStore;
        try {
            trustStore = KeyStore.getInstance(this.trustStoreType);
            FileInputStream inputStream = new FileInputStream(StaticUtils.getFileForPath(this.trustStoreFile));
            trustStore.load(inputStream, this.trustStorePIN);
            inputStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_FILE_TRUSTMANAGER_CANNOT_LOAD.get(this.trustStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        try {
            String trustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerAlgorithm);
            trustManagerFactory.init(trustStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            TrustManager[] newTrustManagers = new TrustManager[trustManagers.length];
            for (int i = 0; i < trustManagers.length; ++i) {
                newTrustManagers[i] = new ExpirationCheckTrustManager((X509TrustManager)trustManagers[i]);
            }
            return newTrustManagers;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_FILE_TRUSTMANAGER_CANNOT_CREATE_FACTORY.get(this.trustStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    @Override
    public boolean isConfigurationAcceptable(TrustManagerProviderCfg configuration, List<Message> unacceptableReasons) {
        FileBasedTrustManagerProviderCfg config = (FileBasedTrustManagerProviderCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConfigurationChangeAcceptable(FileBasedTrustManagerProviderCfg configuration, List<Message> unacceptableReasons) {
        String pinFile;
        String pinEnVar;
        String pinProp;
        Message message;
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        String newTrustStoreFile = configuration.getTrustStoreFile();
        try {
            File f = StaticUtils.getFileForPath(newTrustStoreFile);
            if (!f.exists() || !f.isFile()) {
                unacceptableReasons.add(ExtensionMessages.ERR_FILE_TRUSTMANAGER_NO_SUCH_FILE.get(String.valueOf(newTrustStoreFile), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            unacceptableReasons.add(ExtensionMessages.ERR_FILE_TRUSTMANAGER_CANNOT_DETERMINE_FILE.get(String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(e)));
            configAcceptable = false;
        }
        String storeType = configuration.getTrustStoreType();
        if (storeType != null) {
            try {
                KeyStore.getInstance(storeType);
            }
            catch (KeyStoreException kse) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, kse);
                }
                message = ExtensionMessages.ERR_FILE_TRUSTMANAGER_INVALID_TYPE.get(String.valueOf(storeType), String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(kse));
                unacceptableReasons.add(message);
                configAcceptable = false;
            }
        }
        if ((pinProp = configuration.getTrustStorePinProperty()) != null && System.getProperty(pinProp) == null) {
            message = ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_PROPERTY_NOT_SET.get(String.valueOf(pinProp), String.valueOf(cfgEntryDN));
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        if ((pinEnVar = configuration.getTrustStorePinEnvironmentVariable()) != null && System.getenv(pinEnVar) == null) {
            Message message2 = ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_ENVAR_NOT_SET.get(String.valueOf(pinEnVar), String.valueOf(cfgEntryDN));
            unacceptableReasons.add(message2);
            configAcceptable = false;
        }
        if ((pinFile = configuration.getTrustStorePinFile()) != null) {
            File f = new File(pinFile);
            if (f.exists()) {
                String pinStr = null;
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(pinFile));
                    pinStr = br.readLine();
                }
                catch (IOException ioe) {
                    Message message3 = ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_FILE_CANNOT_READ.get(String.valueOf(pinFile), String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(ioe));
                    unacceptableReasons.add(message3);
                    configAcceptable = false;
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
                if (pinStr == null) {
                    Message message4 = ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_FILE_EMPTY.get(String.valueOf(pinFile), String.valueOf(cfgEntryDN));
                    unacceptableReasons.add(message4);
                    configAcceptable = false;
                }
            } else {
                Message message5 = ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_NO_SUCH_FILE.get(String.valueOf(pinFile), String.valueOf(cfgEntryDN));
                unacceptableReasons.add(message5);
                configAcceptable = false;
            }
        }
        return configAcceptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(FileBasedTrustManagerProviderCfg configuration) {
        String newTrustStoreType;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        String newTrustStoreFile = configuration.getTrustStoreFile();
        File f = StaticUtils.getFileForPath(newTrustStoreFile);
        if (!f.exists() || !f.isFile()) {
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(ExtensionMessages.ERR_FILE_TRUSTMANAGER_NO_SUCH_FILE.get(String.valueOf(newTrustStoreFile), String.valueOf(this.configEntryDN)));
        }
        if ((newTrustStoreType = configuration.getTrustStoreType()) == null) {
            newTrustStoreType = KeyStore.getDefaultType();
        }
        try {
            KeyStore.getInstance(newTrustStoreType);
        }
        catch (KeyStoreException kse) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, kse);
            }
            messages.add(ExtensionMessages.ERR_FILE_TRUSTMANAGER_INVALID_TYPE.get(String.valueOf(newTrustStoreType), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(kse)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        Object newPIN = null;
        String newPINProperty = configuration.getTrustStorePinProperty();
        if (newPINProperty == null) {
            String newPINEnVar = configuration.getTrustStorePinEnvironmentVariable();
            if (newPINEnVar == null) {
                String newPINFile = configuration.getTrustStorePinFile();
                if (newPINFile == null) {
                    String pinStr = configuration.getTrustStorePin();
                    newPIN = pinStr == null ? null : pinStr.toCharArray();
                } else {
                    File pinFile = StaticUtils.getFileForPath(newPINFile);
                    if (!pinFile.exists()) {
                        resultCode = DirectoryServer.getServerErrorResultCode();
                        messages.add(ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_NO_SUCH_FILE.get(String.valueOf(newPINFile), String.valueOf(this.configEntryDN)));
                    } else {
                        String pinStr = null;
                        BufferedReader br = null;
                        try {
                            br = new BufferedReader(new FileReader(pinFile));
                            pinStr = br.readLine();
                        }
                        catch (IOException ioe) {
                            resultCode = DirectoryServer.getServerErrorResultCode();
                            messages.add(ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_FILE_CANNOT_READ.get(String.valueOf(newPINFile), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(ioe)));
                        }
                        finally {
                            try {
                                br.close();
                            }
                            catch (Exception e) {}
                        }
                        if (pinStr == null) {
                            resultCode = DirectoryServer.getServerErrorResultCode();
                            messages.add(ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_FILE_EMPTY.get(String.valueOf(newPINFile), String.valueOf(this.configEntryDN)));
                        } else {
                            newPIN = pinStr.toCharArray();
                        }
                    }
                }
            } else {
                String pinStr = System.getenv(newPINEnVar);
                if (pinStr == null) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_ENVAR_NOT_SET.get(String.valueOf(newPINEnVar), String.valueOf(this.configEntryDN)));
                } else {
                    newPIN = pinStr.toCharArray();
                }
            }
        } else {
            String pinStr = System.getProperty(newPINProperty);
            if (pinStr == null) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(ExtensionMessages.ERR_FILE_TRUSTMANAGER_PIN_PROPERTY_NOT_SET.get(String.valueOf(newPINProperty), String.valueOf(this.configEntryDN)));
            } else {
                newPIN = pinStr.toCharArray();
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.trustStoreFile = newTrustStoreFile;
            this.trustStoreType = newTrustStoreType;
            this.trustStorePIN = newPIN;
            this.currentConfig = configuration;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

