/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import org.opends.messages.Category;
import org.opends.messages.ConfigMessages;
import org.opends.messages.LoggerMessages;
import org.opends.messages.Message;
import org.opends.messages.Severity;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.ErrorLogPublisherCfgDefn;
import org.opends.server.admin.std.server.ErrorLogPublisherCfg;
import org.opends.server.admin.std.server.FileBasedErrorLogPublisherCfg;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.AsyncronousTextWriter;
import org.opends.server.loggers.LogPublisherErrorHandler;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.TimeStampNaming;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.FilePermission;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextErrorLogPublisher
extends ErrorLogPublisher<FileBasedErrorLogPublisherCfg>
implements ConfigurationChangeListener<FileBasedErrorLogPublisherCfg> {
    private TextWriter writer;
    private FileBasedErrorLogPublisherCfg currentConfig;

    public static TextErrorLogPublisher getStartupTextErrorPublisher(TextWriter writer) {
        TextErrorLogPublisher startupPublisher = new TextErrorLogPublisher();
        startupPublisher.writer = writer;
        startupPublisher.defaultSeverities.addAll(Arrays.asList(Severity.values()));
        return startupPublisher;
    }

    @Override
    public void initializeErrorLogPublisher(FileBasedErrorLogPublisherCfg config) throws ConfigException, InitializationException {
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            LogPublisherErrorHandler errorHandler = new LogPublisherErrorHandler(config.dn());
            boolean writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            MultifileTextWriter writer = new MultifileTextWriter("Multifile Text Writer for " + config.dn().toNormalizedString(), config.getTimeInterval(), fnPolicy, perm, errorHandler, "UTF-8", writerAutoFlush, config.isAppend(), (int)config.getBufferSize());
            for (DN dn : config.getRotationPolicyDNs()) {
                writer.addRotationPolicy(DirectoryServer.getRotationPolicy(dn));
            }
            for (DN dn : config.getRetentionPolicyDNs()) {
                writer.addRetentionPolicy(DirectoryServer.getRetentionPolicy(dn));
            }
            this.writer = config.isAsynchronous() ? new AsyncronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), writer) : writer;
        }
        catch (DirectoryException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        catch (IOException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_OPEN_FILE.get(logFile.toString(), config.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        SortedSet<ErrorLogPublisherCfgDefn.DefaultSeverity> defSevs = config.getDefaultSeverity();
        if (defSevs.isEmpty()) {
            this.defaultSeverities.add(Severity.FATAL_ERROR);
            this.defaultSeverities.add(Severity.SEVERE_ERROR);
            this.defaultSeverities.add(Severity.SEVERE_WARNING);
        } else {
            for (ErrorLogPublisherCfgDefn.DefaultSeverity defSev : defSevs) {
                Severity errorSeverity;
                if (defSev.toString().equalsIgnoreCase("all")) {
                    this.defaultSeverities.add(Severity.FATAL_ERROR);
                    this.defaultSeverities.add(Severity.INFORMATION);
                    this.defaultSeverities.add(Severity.MILD_ERROR);
                    this.defaultSeverities.add(Severity.MILD_WARNING);
                    this.defaultSeverities.add(Severity.NOTICE);
                    this.defaultSeverities.add(Severity.SEVERE_ERROR);
                    this.defaultSeverities.add(Severity.SEVERE_WARNING);
                    continue;
                }
                if (defSev.toString().equalsIgnoreCase("none") || (errorSeverity = Severity.parseString(defSev.name())) == null) continue;
                this.defaultSeverities.add(errorSeverity);
            }
        }
        for (String overrideSeverity : config.getOverrideSeverity()) {
            if (overrideSeverity == null) continue;
            int equalPos = overrideSeverity.indexOf(61);
            if (equalPos < 0) {
                Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_OVERRIDE_SEVERITY.get(overrideSeverity);
                throw new ConfigException(msg);
            }
            String categoryName = overrideSeverity.substring(0, equalPos);
            categoryName = categoryName.replace("-", "_").toUpperCase();
            try {
                Category category = Category.valueOf(categoryName);
                HashSet<Severity> severities = new HashSet<Severity>();
                StringTokenizer sevTokenizer = new StringTokenizer(overrideSeverity.substring(equalPos + 1), ",");
                while (sevTokenizer.hasMoreElements()) {
                    String severityName = sevTokenizer.nextToken();
                    if ((severityName = severityName.replace("-", "_").toUpperCase()).equalsIgnoreCase("all")) {
                        severities.add(Severity.FATAL_ERROR);
                        severities.add(Severity.INFORMATION);
                        severities.add(Severity.MILD_ERROR);
                        severities.add(Severity.MILD_WARNING);
                        severities.add(Severity.NOTICE);
                        severities.add(Severity.SEVERE_ERROR);
                        severities.add(Severity.SEVERE_WARNING);
                        continue;
                    }
                    try {
                        Severity severity = Severity.parseString(severityName);
                        severities.add(severity);
                    }
                    catch (Exception e) {
                        Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_SEVERITY.get(severityName);
                        throw new ConfigException(msg);
                    }
                }
                this.definedSeverities.put(category, severities);
            }
            catch (Exception e) {
                Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_CATEGORY.get(categoryName);
                throw new ConfigException(msg);
            }
        }
        this.currentConfig = config;
        config.addFileBasedErrorChangeListener(this);
    }

    @Override
    public boolean isConfigurationAcceptable(ErrorLogPublisherCfg configuration, List<Message> unacceptableReasons) {
        FileBasedErrorLogPublisherCfg config = (FileBasedErrorLogPublisherCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FileBasedErrorLogPublisherCfg config, List<Message> unacceptableReasons) {
        try {
            FilePermission filePerm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            if (!filePerm.isOwnerWritable()) {
                Message message = ConfigMessages.ERR_CONFIG_LOGGING_INSANE_MODE.get(config.getLogFilePermissions());
                unacceptableReasons.add(message);
                return false;
            }
        }
        catch (DirectoryException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_MODE_INVALID.get(config.getLogFilePermissions(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        for (String overrideSeverity : config.getOverrideSeverity()) {
            if (overrideSeverity == null) continue;
            int equalPos = overrideSeverity.indexOf(61);
            if (equalPos < 0) {
                Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_OVERRIDE_SEVERITY.get(overrideSeverity);
                unacceptableReasons.add(msg);
                return false;
            }
            String categoryName = overrideSeverity.substring(0, equalPos);
            categoryName = categoryName.replace("-", "_").toUpperCase();
            try {
                Category.valueOf(categoryName);
            }
            catch (Exception e) {
                Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_CATEGORY.get(categoryName);
                unacceptableReasons.add(msg);
            }
            StringTokenizer sevTokenizer = new StringTokenizer(overrideSeverity.substring(equalPos + 1), ",");
            while (sevTokenizer.hasMoreElements()) {
                String severityName = sevTokenizer.nextToken();
                if ((severityName = severityName.replace("-", "_").toUpperCase()).equalsIgnoreCase("all")) continue;
                try {
                    Severity.parseString(severityName);
                }
                catch (Exception e) {
                    Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_SEVERITY.get(severityName);
                    unacceptableReasons.add(msg);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FileBasedErrorLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        SortedSet<ErrorLogPublisherCfgDefn.DefaultSeverity> defSevs = config.getDefaultSeverity();
        this.defaultSeverities.clear();
        if (defSevs.isEmpty()) {
            this.defaultSeverities.add(Severity.FATAL_ERROR);
            this.defaultSeverities.add(Severity.SEVERE_ERROR);
            this.defaultSeverities.add(Severity.SEVERE_WARNING);
        } else {
            for (ErrorLogPublisherCfgDefn.DefaultSeverity defSev : defSevs) {
                Severity errorSeverity;
                if (defSev.toString().equalsIgnoreCase("all")) {
                    this.defaultSeverities.add(Severity.FATAL_ERROR);
                    this.defaultSeverities.add(Severity.INFORMATION);
                    this.defaultSeverities.add(Severity.MILD_ERROR);
                    this.defaultSeverities.add(Severity.MILD_WARNING);
                    this.defaultSeverities.add(Severity.NOTICE);
                    this.defaultSeverities.add(Severity.SEVERE_ERROR);
                    this.defaultSeverities.add(Severity.SEVERE_WARNING);
                    continue;
                }
                if (defSev.toString().equalsIgnoreCase("none") || (errorSeverity = Severity.parseString(defSev.name())) == null) continue;
                this.defaultSeverities.add(errorSeverity);
            }
        }
        this.definedSeverities.clear();
        for (String overrideSeverity : config.getOverrideSeverity()) {
            if (overrideSeverity == null) continue;
            int equalPos = overrideSeverity.indexOf(61);
            if (equalPos < 0) {
                Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_OVERRIDE_SEVERITY.get(overrideSeverity);
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(msg);
                continue;
            }
            String categoryName = overrideSeverity.substring(0, equalPos);
            categoryName = categoryName.replace("-", "_").toUpperCase();
            try {
                Category category = Category.valueOf(categoryName);
                HashSet<Severity> severities = new HashSet<Severity>();
                StringTokenizer sevTokenizer = new StringTokenizer(overrideSeverity.substring(equalPos + 1), ",");
                while (sevTokenizer.hasMoreElements()) {
                    String severityName = sevTokenizer.nextToken();
                    if ((severityName = severityName.replace("-", "_").toUpperCase()).equalsIgnoreCase("all")) {
                        severities.add(Severity.FATAL_ERROR);
                        severities.add(Severity.INFORMATION);
                        severities.add(Severity.MILD_ERROR);
                        severities.add(Severity.MILD_WARNING);
                        severities.add(Severity.NOTICE);
                        severities.add(Severity.SEVERE_ERROR);
                        severities.add(Severity.SEVERE_WARNING);
                        continue;
                    }
                    try {
                        Severity severity = Severity.parseString(severityName);
                        severities.add(severity);
                    }
                    catch (Exception e) {
                        Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_SEVERITY.get(severityName);
                        throw new ConfigException(msg);
                    }
                }
                this.definedSeverities.put(category, severities);
            }
            catch (Exception e) {
                Message msg = LoggerMessages.WARN_ERROR_LOGGER_INVALID_CATEGORY.get(categoryName);
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(msg);
            }
        }
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            boolean writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            TextWriter currentWriter = this.writer instanceof AsyncronousTextWriter ? ((AsyncronousTextWriter)this.writer).getWrappedWriter() : this.writer;
            if (currentWriter instanceof MultifileTextWriter) {
                AsyncronousTextWriter asyncWriter;
                MultifileTextWriter mfWriter = (MultifileTextWriter)this.writer;
                mfWriter.setNamingPolicy(fnPolicy);
                mfWriter.setFilePermissions(perm);
                mfWriter.setAppend(config.isAppend());
                mfWriter.setAutoFlush(writerAutoFlush);
                mfWriter.setBufferSize((int)config.getBufferSize());
                mfWriter.setInterval(config.getTimeInterval());
                mfWriter.removeAllRetentionPolicies();
                mfWriter.removeAllRotationPolicies();
                for (DN dn : config.getRotationPolicyDNs()) {
                    mfWriter.addRotationPolicy(DirectoryServer.getRotationPolicy(dn));
                }
                for (DN dn : config.getRetentionPolicyDNs()) {
                    mfWriter.addRetentionPolicy(DirectoryServer.getRetentionPolicy(dn));
                }
                if (this.writer instanceof AsyncronousTextWriter && !config.isAsynchronous()) {
                    asyncWriter = (AsyncronousTextWriter)this.writer;
                    this.writer = mfWriter;
                    asyncWriter.shutdown(false);
                }
                if (!(this.writer instanceof AsyncronousTextWriter) && config.isAsynchronous()) {
                    asyncWriter = new AsyncronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), mfWriter);
                    this.writer = asyncWriter;
                }
                if (this.currentConfig.isAsynchronous() && config.isAsynchronous() && this.currentConfig.getQueueSize() != config.getQueueSize()) {
                    adminActionRequired = true;
                }
                this.currentConfig = config;
            }
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(message);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public void close() {
        this.writer.shutdown();
        if (this.currentConfig != null) {
            this.currentConfig.removeFileBasedErrorChangeListener(this);
        }
    }

    @Override
    public void logError(Message message) {
        Severity severity = message.getDescriptor().getSeverity();
        Category category = message.getDescriptor().getCategory();
        int msgId = message.getDescriptor().getId();
        HashSet severities = (HashSet)this.definedSeverities.get((Object)category);
        if (severities == null) {
            severities = this.defaultSeverities;
        }
        if (severities.contains((Object)severity)) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(TimeThread.getLocalTime());
            sb.append("] category=").append((Object)category).append(" severity=").append((Object)severity).append(" msgID=").append(msgId).append(" msg=").append(message);
            this.writer.writeRecord(sb.toString());
        }
    }

    @Override
    public DN getDN() {
        if (this.currentConfig != null) {
            return this.currentConfig.dn();
        }
        return null;
    }
}

