/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins.profiler;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.plugins.profiler.ProfileStack;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Long;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.DebugLogLevel;

public class ProfilerThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean stopProfiling;
    private long captureStartTime;
    private long captureStopTime;
    private long numIntervals;
    private long sampleInterval;
    private HashMap<ProfileStack, Long> stackTraces;
    private Thread captureThread;

    public ProfilerThread(long sampleInterval) {
        super("Directory Server Profiler Thread");
        this.sampleInterval = sampleInterval;
        this.stackTraces = new HashMap();
        this.numIntervals = 0L;
        this.stopProfiling = false;
        this.captureStartTime = -1L;
        this.captureStopTime = -1L;
        this.captureThread = null;
    }

    public void run() {
        this.captureThread = ProfilerThread.currentThread();
        this.captureStartTime = System.currentTimeMillis();
        while (!this.stopProfiling) {
            long sleepTime;
            long startTime = System.currentTimeMillis();
            Map<Thread, StackTraceElement[]> stacks = ProfilerThread.getAllStackTraces();
            ++this.numIntervals;
            for (Thread t : stacks.keySet()) {
                StackTraceElement[] threadStack;
                if (t == ProfilerThread.currentThread() || (threadStack = stacks.get(t)) == null || threadStack.length == 0) continue;
                ProfileStack profileStack = new ProfileStack(threadStack);
                Long currentCount = this.stackTraces.get(profileStack);
                if (currentCount == null) {
                    this.stackTraces.put(profileStack, 1L);
                    continue;
                }
                this.stackTraces.put(profileStack, 1L + (long)currentCount.intValue());
            }
            if (this.stopProfiling || (sleepTime = this.sampleInterval - (System.currentTimeMillis() - startTime)) <= 0L) continue;
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        this.captureStopTime = System.currentTimeMillis();
        this.captureThread = null;
    }

    public void stopProfiling() {
        block3: {
            this.stopProfiling = true;
            try {
                if (this.captureThread != null) {
                    this.captureThread.join();
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block3;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCaptureData(String filename) throws IOException {
        ASN1Writer writer = new ASN1Writer(new FileOutputStream(filename));
        try {
            if (this.captureStartTime < 0L) {
                this.captureStopTime = this.captureStartTime = System.currentTimeMillis();
            } else if (this.captureStopTime < 0L) {
                this.captureStopTime = System.currentTimeMillis();
            }
            ArrayList<ASN1Element> headerElements = new ArrayList<ASN1Element>(3);
            headerElements.add(new ASN1Long(this.numIntervals));
            headerElements.add(new ASN1Long(this.captureStartTime));
            headerElements.add(new ASN1Long(this.captureStopTime));
            writer.writeElement(new ASN1Sequence(headerElements));
            for (ProfileStack s : this.stackTraces.keySet()) {
                writer.writeElement(s.encode());
                writer.writeElement(new ASN1Long(this.stackTraces.get(s)));
            }
        }
        finally {
            writer.close();
        }
    }
}

