/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class ASN1Boolean
extends ASN1Element {
    private static final long serialVersionUID = -3352160557662933000L;
    private boolean booleanValue;

    public ASN1Boolean(boolean booleanValue) {
        super((byte)1, ASN1Boolean.encodeValue(booleanValue));
        this.booleanValue = booleanValue;
    }

    public ASN1Boolean(byte type, boolean booleanValue) {
        super(type, ASN1Boolean.encodeValue(booleanValue));
        this.booleanValue = booleanValue;
    }

    private ASN1Boolean(byte type, byte[] value, boolean booleanValue) {
        super(type, value);
        this.booleanValue = booleanValue;
    }

    public boolean booleanValue() {
        return this.booleanValue;
    }

    public void setValue(boolean booleanValue) {
        this.booleanValue = booleanValue;
        this.setValueInternal(ASN1Boolean.encodeValue(booleanValue));
    }

    public void setValue(byte[] value) throws ASN1Exception {
        if (value == null) {
            Message message = ProtocolMessages.ERR_ASN1_BOOLEAN_SET_VALUE_NULL.get();
            throw new ASN1Exception(message);
        }
        if (value.length != 1) {
            Message message = ProtocolMessages.ERR_ASN1_BOOLEAN_SET_VALUE_INVALID_LENGTH.get(value.length);
            throw new ASN1Exception(message);
        }
        this.booleanValue = value[0] != 0;
        this.setValueInternal(value);
    }

    public static ASN1Boolean decodeAsBoolean(ASN1Element element) throws ASN1Exception {
        if (element == null) {
            Message message = ProtocolMessages.ERR_ASN1_BOOLEAN_DECODE_ELEMENT_NULL.get();
            throw new ASN1Exception(message);
        }
        byte[] value = element.value();
        if (value.length != 1) {
            Message message = ProtocolMessages.ERR_ASN1_BOOLEAN_DECODE_ELEMENT_INVALID_LENGTH.get(value.length);
            throw new ASN1Exception(message);
        }
        boolean booleanValue = value[0] != 0;
        return new ASN1Boolean(element.getType(), value, booleanValue);
    }

    public static ASN1Boolean decodeAsBoolean(byte[] encodedElement) throws ASN1Exception {
        if (encodedElement == null) {
            Message message = ProtocolMessages.ERR_ASN1_BOOLEAN_DECODE_ARRAY_NULL.get();
            throw new ASN1Exception(message);
        }
        if (encodedElement.length < 3) {
            Message message = ProtocolMessages.ERR_ASN1_BOOLEAN_SHORT_ELEMENT.get(encodedElement.length);
            throw new ASN1Exception(message);
        }
        byte type = encodedElement[0];
        int length = encodedElement[1] & 0x7F;
        int valueStartPos = 2;
        if (length != encodedElement[1]) {
            int numLengthBytes = length;
            if (numLengthBytes > 4) {
                Message message = ProtocolMessages.ERR_ASN1_INVALID_NUM_LENGTH_BYTES.get(numLengthBytes);
                throw new ASN1Exception(message);
            }
            if (encodedElement.length < 2 + numLengthBytes) {
                Message message = ProtocolMessages.ERR_ASN1_TRUNCATED_LENGTH.get(numLengthBytes);
                throw new ASN1Exception(message);
            }
            length = 0;
            valueStartPos = 2 + numLengthBytes;
            for (int i = 0; i < numLengthBytes; ++i) {
                length = length << 8 | encodedElement[i + 2] & 0xFF;
            }
        }
        if (encodedElement.length - valueStartPos != length) {
            Message message = ProtocolMessages.ERR_ASN1_LENGTH_MISMATCH.get(length, encodedElement.length - valueStartPos);
            throw new ASN1Exception(message);
        }
        if (length != 1) {
            Message message = ProtocolMessages.ERR_ASN1_BOOLEAN_DECODE_ARRAY_INVALID_LENGTH.get(length);
            throw new ASN1Exception(message);
        }
        byte[] value = new byte[]{encodedElement[valueStartPos]};
        boolean booleanValue = value[0] != 0;
        return new ASN1Boolean(type, value, booleanValue);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ASN1Boolean(type=");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(", value=");
        buffer.append(this.booleanValue);
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("ASN.1 Boolean");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  BER Type:  ");
        buffer.append(StaticUtils.byteToHex(this.getType()));
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Value:  ");
        buffer.append(this.booleanValue);
        buffer.append(" (");
        buffer.append(StaticUtils.byteToHex(this.value()[0]));
        buffer.append(")");
        buffer.append(ServerConstants.EOL);
    }
}

