/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.RawModification;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ArrayList<RawModification> modifications;
    private ASN1OctetString dn;

    public ModifyRequestProtocolOp(ASN1OctetString dn) {
        this.dn = dn;
        this.modifications = new ArrayList();
    }

    public ModifyRequestProtocolOp(ASN1OctetString dn, ArrayList<RawModification> modifications) {
        this.dn = dn;
        this.modifications = modifications == null ? new ArrayList() : modifications;
    }

    public ASN1OctetString getDN() {
        return this.dn;
    }

    public void setDN(ASN1OctetString dn) {
        this.dn = dn;
    }

    public ArrayList<RawModification> getModifications() {
        return this.modifications;
    }

    @Override
    public byte getType() {
        return 102;
    }

    @Override
    public String getProtocolOpName() {
        return "Modify Request";
    }

    @Override
    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(this.dn);
        ArrayList<ASN1Element> modElements = new ArrayList<ASN1Element>(this.modifications.size());
        for (RawModification mod : this.modifications) {
            modElements.add(mod.encode());
        }
        elements.add(new ASN1Sequence(modElements));
        return new ASN1Sequence(102, elements);
    }

    public static ModifyRequestProtocolOp decodeModifyRequest(ASN1Element element) throws LDAPException {
        ArrayList<RawModification> modifications;
        ASN1OctetString dn;
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        int numElements = elements.size();
        if (numElements != 2) {
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_REQUEST_DECODE_INVALID_ELEMENT_COUNT.get(numElements);
            throw new LDAPException(2, message);
        }
        try {
            dn = elements.get(0).decodeAsOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_REQUEST_DECODE_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            ArrayList<ASN1Element> modElements = elements.get(1).decodeAsSequence().elements();
            modifications = new ArrayList<RawModification>(modElements.size());
            for (ASN1Element e : modElements) {
                modifications.add(LDAPModification.decode(e));
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_MODIFY_REQUEST_DECODE_MODS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new ModifyRequestProtocolOp(dn, modifications);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ModifyRequest(dn=");
        this.dn.toString(buffer);
        buffer.append(", mods={");
        if (!this.modifications.isEmpty()) {
            Iterator<RawModification> iterator = this.modifications.iterator();
            iterator.next().toString(buffer);
            while (iterator.hasNext()) {
                buffer.append(", ");
                iterator.next().toString(buffer);
            }
        }
        buffer.append("})");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Modify Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  DN:  ");
        this.dn.toString(buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append("  Modifications:");
        buffer.append(ServerConstants.EOL);
        for (RawModification mod : this.modifications) {
            mod.toString(buffer, indent + 4);
        }
    }
}

