/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.common;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeNumber
implements Serializable,
Comparable<ChangeNumber> {
    private static final long serialVersionUID = -8802722277749190740L;
    private long timeStamp;
    private int seqnum;
    private short serverId;

    public ChangeNumber(String str) {
        String temp = str.substring(0, 16);
        this.timeStamp = Long.parseLong(temp, 16);
        temp = str.substring(16, 20);
        this.serverId = Short.parseShort(temp, 16);
        temp = str.substring(20, 28);
        this.seqnum = Integer.parseInt(temp, 16);
    }

    public ChangeNumber(long time, int seq, short id) {
        this.serverId = id;
        this.timeStamp = time;
        this.seqnum = seq;
    }

    public long getTime() {
        return this.timeStamp;
    }

    public long getTimeSec() {
        return this.timeStamp / 1000L;
    }

    public int getSeqnum() {
        return this.seqnum;
    }

    public short getServerId() {
        return this.serverId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChangeNumber) {
            ChangeNumber cn = (ChangeNumber)obj;
            return this.seqnum == cn.seqnum && this.serverId == cn.serverId && this.timeStamp == cn.timeStamp;
        }
        return false;
    }

    public int hashCode() {
        return this.seqnum + this.serverId + Long.valueOf(this.timeStamp).hashCode();
    }

    public String toString() {
        return String.format("%016x%04x%08x", this.timeStamp, this.serverId, this.seqnum);
    }

    public static int compare(ChangeNumber CN1, ChangeNumber CN2) {
        if (CN1 == null) {
            if (CN2 == null) {
                return 0;
            }
            return -1;
        }
        if (CN2 == null) {
            return 1;
        }
        if (CN1.timeStamp < CN2.timeStamp) {
            return -1;
        }
        if (CN2.timeStamp < CN1.timeStamp) {
            return 1;
        }
        if (CN1.seqnum < CN2.seqnum) {
            return -1;
        }
        if (CN2.seqnum < CN1.seqnum) {
            return 1;
        }
        if (CN1.serverId < CN2.serverId) {
            return -1;
        }
        if (CN2.serverId < CN1.serverId) {
            return 1;
        }
        return 0;
    }

    public static int diffSeqNum(ChangeNumber op1, ChangeNumber op2) {
        int totalCount = 0;
        int max = op1.getSeqnum();
        if (op2 != null) {
            int current = op2.getSeqnum();
            if (current != max) {
                totalCount = current < max ? (totalCount += max - current) : (totalCount += Integer.MAX_VALUE - (current - max) + 1);
            }
        } else {
            totalCount += max;
        }
        return totalCount;
    }

    public Boolean older(ChangeNumber CN) {
        if (ChangeNumber.compare(this, CN) < 0) {
            return true;
        }
        return false;
    }

    public Boolean olderOrEqual(ChangeNumber CN) {
        if (ChangeNumber.compare(this, CN) <= 0) {
            return true;
        }
        return false;
    }

    public boolean newerOrEquals(ChangeNumber CN) {
        return ChangeNumber.compare(this, CN) >= 0;
    }

    public boolean newer(ChangeNumber CN) {
        return ChangeNumber.compare(this, CN) > 0;
    }

    @Override
    public int compareTo(ChangeNumber cn) {
        return ChangeNumber.compare(this, cn);
    }
}

