/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.DeleteOperationBasis;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.DeleteContext;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;

public class DeleteMsg
extends UpdateMessage {
    private static final long serialVersionUID = -4905520652801395185L;

    public DeleteMsg(PostOperationDeleteOperation operation) {
        super((OperationContext)operation.getAttachment("replicationContext"), operation.getRawEntryDN().stringValue());
    }

    public DeleteMsg(String dn, ChangeNumber changeNumber, String uid) {
        super(new DeleteContext(changeNumber, uid), dn);
    }

    public DeleteMsg(byte[] in) throws DataFormatException, UnsupportedEncodingException {
        super(in);
        this.decodeHeader((byte)3, in);
    }

    public AbstractOperation createOperation(InternalClientConnection connection, String newDn) {
        DeleteOperationBasis del = new DeleteOperationBasis((ClientConnection)connection, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, new ASN1OctetString(newDn));
        DeleteContext ctx = new DeleteContext(this.getChangeNumber(), this.getUniqueId());
        del.setAttachment("replicationContext", ctx);
        return del;
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        return this.encodeHeader((byte)3, 0);
    }

    public String toString() {
        return "DEL " + this.getDn() + " " + this.getChangeNumber();
    }
}

