/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.RoutableMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorMessage
extends RoutableMessage
implements Serializable {
    private static final long serialVersionUID = -1900670921496804942L;
    SubTopoMonitorData data = new SubTopoMonitorData();

    public MonitorMessage(short sender, short destination) {
        super(sender, destination);
    }

    public void setReplServerDbState(ServerState state) {
        this.data.replServerDbState = state;
    }

    public void setServerState(short serverId, ServerState state, Long approxFirstMissingDate, boolean isLDAP) {
        if (this.data.ldapStates == null) {
            this.data.ldapStates = new HashMap();
        }
        if (this.data.rsStates == null) {
            this.data.rsStates = new HashMap();
        }
        ServerData sd = new ServerData();
        sd.state = state;
        sd.approxFirstMissingDate = approxFirstMissingDate;
        if (isLDAP) {
            this.data.ldapStates.put(serverId, sd);
        } else {
            this.data.rsStates.put(serverId, sd);
        }
    }

    public ServerState getLDAPServerState(short serverId) {
        return this.data.ldapStates.get((Object)Short.valueOf((short)serverId)).state;
    }

    public ServerState getRSServerState(short serverId) {
        return this.data.rsStates.get((Object)Short.valueOf((short)serverId)).state;
    }

    public Long getLDAPApproxFirstMissingDate(short serverId) {
        return this.data.ldapStates.get((Object)Short.valueOf((short)serverId)).approxFirstMissingDate;
    }

    public Long getRSApproxFirstMissingDate(short serverId) {
        return this.data.rsStates.get((Object)Short.valueOf((short)serverId)).approxFirstMissingDate;
    }

    public MonitorMessage(byte[] in) throws DataFormatException {
        try {
            if (in[0] != 19) {
                throw new DataFormatException("input is not a valid " + this.getClass().getCanonicalName());
            }
            int pos = 1;
            int length = this.getNextLength(in, pos);
            String senderIDString = new String(in, pos, length, "UTF-8");
            this.senderID = Short.valueOf(senderIDString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String destinationString = new String(in, pos, length, "UTF-8");
            this.destination = Short.valueOf(destinationString);
            byte[] encodedS = new byte[in.length - (pos += length + 1) - 1];
            int i = 0;
            while (pos < in.length - 1) {
                encodedS[i++] = in[pos++];
            }
            try {
                ASN1Sequence s0 = ASN1Sequence.decodeAsSequence(encodedS);
                for (ASN1Element el0 : s0.elements()) {
                    ServerState newState = new ServerState();
                    short serverId = 0;
                    Long outime = 0L;
                    boolean isLDAPServer = false;
                    ASN1Sequence s1 = el0.decodeAsSequence();
                    for (ASN1Element el1 : s1.elements()) {
                        ASN1OctetString o = el1.decodeAsOctetString();
                        String s = o.stringValue();
                        ChangeNumber cn = new ChangeNumber(s);
                        if (this.data.replServerDbState != null && serverId == 0) {
                            serverId = cn.getServerId();
                            outime = cn.getTime();
                            isLDAPServer = cn.getSeqnum() > 0;
                            continue;
                        }
                        newState.update(cn);
                    }
                    if (this.data.replServerDbState == null) {
                        this.data.replServerDbState = newState;
                        continue;
                    }
                    ServerData sd = new ServerData();
                    sd.state = newState;
                    sd.approxFirstMissingDate = outime;
                    if (isLDAPServer) {
                        this.data.ldapStates.put(serverId, sd);
                        continue;
                    }
                    this.data.rsStates.put(serverId, sd);
                }
            }
            catch (Exception e) {
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    @Override
    public byte[] getBytes() {
        try {
            ChangeNumber cn;
            Long outime;
            ServerState statei;
            ChangeNumber cn2;
            Long outime2;
            ServerState statei2;
            byte[] senderBytes = String.valueOf(this.senderID).getBytes("UTF-8");
            byte[] destinationBytes = String.valueOf(this.destination).getBytes("UTF-8");
            int length = 1 + senderBytes.length + 1 + destinationBytes.length;
            ASN1Sequence stateElementSequence = new ASN1Sequence();
            ArrayList<ASN1Element> stateElementList = new ArrayList<ASN1Element>();
            stateElementSequence = new ASN1Sequence();
            stateElementList = new ArrayList();
            ArrayList<ASN1OctetString> cnOctetList = this.data.replServerDbState.toASN1ArrayList();
            ArrayList<ASN1Element> cnElementList = new ArrayList<ASN1Element>();
            for (ASN1OctetString soci : cnOctetList) {
                cnElementList.add(soci);
            }
            ASN1Sequence cnSequence = new ASN1Sequence(cnElementList);
            stateElementList.add(cnSequence);
            Set<Short> servers = this.data.ldapStates.keySet();
            for (Short sid : servers) {
                statei2 = this.data.ldapStates.get((Object)sid).state;
                outime2 = this.data.ldapStates.get((Object)sid).approxFirstMissingDate;
                cnOctetList = statei2.toASN1ArrayList();
                cnElementList = new ArrayList();
                cn2 = new ChangeNumber(outime2, 0, sid);
                cnElementList.add(new ASN1OctetString(cn2.toString()));
                for (ASN1OctetString soci : cnOctetList) {
                    cnElementList.add(soci);
                }
                cnSequence = new ASN1Sequence(cnElementList);
                stateElementList.add(cnSequence);
            }
            servers = this.data.rsStates.keySet();
            for (Short sid : servers) {
                statei2 = this.data.rsStates.get((Object)sid).state;
                outime2 = this.data.rsStates.get((Object)sid).approxFirstMissingDate;
                cnOctetList = statei2.toASN1ArrayList();
                cnElementList = new ArrayList();
                cn2 = new ChangeNumber(outime2, 0, sid);
                cnElementList.add(new ASN1OctetString(cn2.toString()));
                for (ASN1OctetString soci : cnOctetList) {
                    cnElementList.add(soci);
                }
                cnSequence = new ASN1Sequence(cnElementList);
                stateElementList.add(cnSequence);
            }
            stateElementSequence.setElements(stateElementList);
            int seqLen = stateElementSequence.encode().length;
            length += seqLen;
            byte[] resultByteArray = new byte[length += 2];
            resultByteArray[0] = 19;
            int pos = 1;
            pos = this.addByteArray(senderBytes, resultByteArray, pos);
            pos = this.addByteArray(destinationBytes, resultByteArray, pos);
            stateElementSequence = new ASN1Sequence();
            stateElementList = new ArrayList();
            cnOctetList = this.data.replServerDbState.toASN1ArrayList();
            cnElementList = new ArrayList();
            for (ASN1OctetString soci : cnOctetList) {
                cnElementList.add(soci);
            }
            cnSequence = new ASN1Sequence(cnElementList);
            stateElementList.add(cnSequence);
            servers = this.data.ldapStates.keySet();
            for (Short sid : servers) {
                statei = this.data.ldapStates.get((Object)sid).state;
                outime = this.data.ldapStates.get((Object)sid).approxFirstMissingDate;
                cnOctetList = statei.toASN1ArrayList();
                cnElementList = new ArrayList();
                cn = new ChangeNumber(outime, 1, sid);
                cnElementList.add(new ASN1OctetString(cn.toString()));
                for (ASN1OctetString soci : cnOctetList) {
                    cnElementList.add(soci);
                }
                cnSequence = new ASN1Sequence(cnElementList);
                stateElementList.add(cnSequence);
            }
            servers = this.data.rsStates.keySet();
            for (Short sid : servers) {
                statei = this.data.rsStates.get((Object)sid).state;
                outime = this.data.rsStates.get((Object)sid).approxFirstMissingDate;
                cnOctetList = statei.toASN1ArrayList();
                cnElementList = new ArrayList();
                cn = new ChangeNumber(outime, 0, sid);
                cnElementList.add(new ASN1OctetString(cn.toString()));
                for (ASN1OctetString soci : cnOctetList) {
                    cnElementList.add(soci);
                }
                cnSequence = new ASN1Sequence(cnElementList);
                stateElementList.add(cnSequence);
            }
            stateElementSequence.setElements(stateElementList);
            pos = this.addByteArray(stateElementSequence.encode(), resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public ServerState getReplServerDbState() {
        return this.data.replServerDbState;
    }

    public Iterator<Short> ldapIterator() {
        return this.data.ldapStates.keySet().iterator();
    }

    public Iterator<Short> rsIterator() {
        return this.data.rsStates.keySet().iterator();
    }

    @Override
    public String toString() {
        ServerData sd;
        String stateS = "\nRState:[";
        stateS = stateS + this.data.replServerDbState.toString();
        stateS = stateS + "]";
        stateS = stateS + "\nLDAPStates:[";
        for (Short sid : this.data.ldapStates.keySet()) {
            sd = this.data.ldapStates.get(sid);
            stateS = stateS + "\n[LSstate(" + sid + ")=" + sd.state.toString() + "]" + " afmd=" + sd.approxFirstMissingDate + "]";
        }
        stateS = stateS + "\nRSStates:[";
        for (Short sid : this.data.rsStates.keySet()) {
            sd = this.data.rsStates.get(sid);
            stateS = stateS + "\n[RSState(" + sid + ")=" + sd.state.toString() + "]" + " afmd=" + sd.approxFirstMissingDate + "]";
        }
        String me = this.getClass().getCanonicalName() + "[ sender=" + this.senderID + " destination=" + this.destination + " data=[" + stateS + "]" + "]";
        return me;
    }

    class SubTopoMonitorData {
        ServerState replServerDbState;
        HashMap<Short, ServerData> ldapStates = new HashMap();
        HashMap<Short, ServerData> rsStates = new HashMap();

        SubTopoMonitorData() {
        }
    }

    class ServerData {
        ServerState state;
        Long approxFirstMissingDate;

        ServerData() {
        }
    }
}

