/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.ReplicationMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplServerInfoMessage
extends ReplicationMessage {
    private List<String> connectedServers = null;
    private long generationId;

    public ReplServerInfoMessage(byte[] in) throws DataFormatException {
        try {
            if (in.length < 1 || in[0] != 16) {
                throw new DataFormatException("Input is not a valid " + this.getClass().getCanonicalName());
            }
            int pos = 1;
            int length = this.getNextLength(in, pos);
            this.generationId = Long.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            this.connectedServers = new ArrayList<String>();
            while (pos < in.length) {
                length = this.getNextLength(in, pos);
                this.connectedServers.add(new String(in, pos, length, "UTF-8"));
                pos += length + 1;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public ReplServerInfoMessage(List<String> connectedServers, long generationId) {
        this.connectedServers = connectedServers;
        this.generationId = generationId;
    }

    @Override
    public byte[] getBytes() {
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            oStream.write(16);
            oStream.write(String.valueOf(this.generationId).getBytes("UTF-8"));
            oStream.write(0);
            if (this.connectedServers.size() >= 1) {
                for (String server : this.connectedServers) {
                    byte[] byteServerURL = server.getBytes("UTF-8");
                    oStream.write(byteServerURL);
                    oStream.write(0);
                }
            }
            return oStream.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public List<String> getConnectedServers() {
        return this.connectedServers;
    }

    public long getGenerationId() {
        return this.generationId;
    }

    public String toString() {
        String csrvs = "";
        for (String s : this.connectedServers) {
            csrvs = csrvs + s + "/";
        }
        return "ReplServerInfoMessage: genId=" + this.getGenerationId() + " Connected peers:" + csrvs;
    }
}

