/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.protocol.ReplicationMessage;

public class ResetGenerationId
extends ReplicationMessage
implements Serializable {
    private static final long serialVersionUID = 7657049716115572226L;
    private long generationId;

    public ResetGenerationId(long generationId) {
        this.generationId = generationId;
    }

    public ResetGenerationId(byte[] in) throws DataFormatException {
        try {
            if (in[0] != 17) {
                throw new DataFormatException("input is not a valid GenerationId Message");
            }
            int pos = 1;
            int length = this.getNextLength(in, pos);
            this.generationId = Long.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public byte[] getBytes() {
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            oStream.write(17);
            oStream.write(String.valueOf(this.generationId).getBytes("UTF-8"));
            oStream.write(0);
            return oStream.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public long getGenerationId() {
        return this.generationId;
    }
}

