/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.UpdateMessage;
import org.opends.server.replication.server.ReplicationData;
import org.opends.server.replication.server.ReplicationDbEnv;
import org.opends.server.replication.server.ReplicationKey;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.types.DN;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationDB {
    private Database db = null;
    private ReplicationDbEnv dbenv = null;
    private ReplicationServer replicationServer;
    private Short serverId;
    private DN baseDn;
    private static final int DEADLOCK_RETRIES = 10;
    private ReentrantReadWriteLock dbCloseLock;

    public ReplicationDB(Short serverId, DN baseDn, ReplicationServer replicationServer, ReplicationDbEnv dbenv) throws DatabaseException {
        this.serverId = serverId;
        this.baseDn = baseDn;
        this.dbenv = dbenv;
        this.replicationServer = replicationServer;
        this.db = dbenv.getOrAddDb(serverId, baseDn, replicationServer.getReplicationServerDomain(baseDn, true).getGenerationId());
        this.dbCloseLock = new ReentrantReadWriteLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntries(List<UpdateMessage> changes) {
        Transaction txn = null;
        try {
            int tries = 0;
            boolean done = false;
            while (tries++ < 10 && !done) {
                this.dbCloseLock.readLock().lock();
                try {
                    txn = this.dbenv.beginTransaction();
                    for (UpdateMessage change : changes) {
                        ReplicationKey key = new ReplicationKey(change.getChangeNumber());
                        ReplicationData data = new ReplicationData(change);
                        this.db.put(txn, (DatabaseEntry)key, (DatabaseEntry)data);
                    }
                    txn.commitWriteNoSync();
                    txn = null;
                    done = true;
                }
                catch (DeadlockException e) {
                    txn.abort();
                    txn = null;
                }
                finally {
                    this.dbCloseLock.readLock().unlock();
                }
            }
            if (!done) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                ErrorLogger.logError(mb.toMessage());
                if (txn != null) {
                    txn.abort();
                }
                this.replicationServer.shutdown();
            }
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            if (txn != null) {
                try {
                    txn.abort();
                }
                catch (DatabaseException e1) {
                    // empty catch block
                }
            }
            this.replicationServer.shutdown();
        }
        catch (UnsupportedEncodingException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_UNSUPPORTED_UTF8_ENCODING.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            this.replicationServer.shutdown();
            if (txn != null) {
                try {
                    txn.abort();
                }
                catch (DatabaseException e1) {
                    // empty catch block
                }
            }
            this.replicationServer.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.dbCloseLock.writeLock().lock();
            try {
                this.db.close();
            }
            finally {
                this.dbCloseLock.writeLock().unlock();
            }
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.NOTE_EXCEPTION_CLOSING_DATABASE.get(this.toString()));
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
        }
    }

    public ReplServerDBCursor openReadCursor(ChangeNumber changeNumber) throws DatabaseException, Exception {
        return new ReplServerDBCursor(changeNumber);
    }

    public ReplServerDBCursor openDeleteCursor() throws DatabaseException, Exception {
        return new ReplServerDBCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLockedCursor(Cursor cursor) throws DatabaseException {
        try {
            if (cursor != null) {
                cursor.close();
            }
        }
        finally {
            this.dbCloseLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChangeNumber readFirstChange() {
        Cursor cursor = null;
        String str = null;
        try {
            this.dbCloseLock.readLock().lock();
            cursor = this.db.openCursor(null, null);
        }
        catch (DatabaseException e1) {
            this.dbCloseLock.readLock().unlock();
            return null;
        }
        try {
            try {
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                OperationStatus status = cursor.getFirst(key, data, LockMode.DEFAULT);
                if (status != OperationStatus.SUCCESS) {
                    ChangeNumber changeNumber = null;
                    return changeNumber;
                }
                try {
                    str = new String(key.getData(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                ChangeNumber changeNumber = new ChangeNumber(str);
                return changeNumber;
            }
            finally {
                this.closeLockedCursor(cursor);
            }
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            this.replicationServer.shutdown();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChangeNumber readLastChange() {
        Cursor cursor = null;
        String str = null;
        try {
            DatabaseEntry key;
            block7: {
                ChangeNumber changeNumber;
                this.dbCloseLock.readLock().lock();
                try {
                    cursor = this.db.openCursor(null, null);
                    key = new DatabaseEntry();
                    DatabaseEntry data = new DatabaseEntry();
                    OperationStatus status = cursor.getLast(key, data, LockMode.DEFAULT);
                    if (status == OperationStatus.SUCCESS) break block7;
                    changeNumber = null;
                }
                catch (Throwable throwable) {
                    this.closeLockedCursor(cursor);
                    throw throwable;
                }
                this.closeLockedCursor(cursor);
                return changeNumber;
            }
            try {
                str = new String(key.getData(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            ChangeNumber changeNumber = new ChangeNumber(str);
            this.closeLockedCursor(cursor);
            return changeNumber;
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
            this.replicationServer.shutdown();
            return null;
        }
    }

    public String toString() {
        return this.serverId.toString() + this.baseDn.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws Exception, DatabaseException {
        this.dbCloseLock.writeLock().lock();
        try {
            String dbName = this.db.getDatabaseName();
            this.dbenv.clearServerId(this.baseDn, this.serverId);
            this.db.close();
            this.dbenv.clearDb(dbName);
            this.db = null;
            this.db = this.dbenv.getOrAddDb(this.serverId, this.baseDn, -1L);
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_ERROR_CLEARING_DB.get(this.toString(), e.getMessage() + " " + StaticUtils.stackTraceToSingleLineString(e)));
            ErrorLogger.logError(mb.toMessage());
        }
        finally {
            this.dbCloseLock.writeLock().unlock();
        }
    }

    public class ReplServerDBCursor {
        private Cursor cursor = null;
        private Transaction txn = null;
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();

        private ReplServerDBCursor(ChangeNumber startingChangeNumber) throws Exception {
            try {
                ReplicationDB.this.dbCloseLock.readLock().lock();
                this.cursor = ReplicationDB.this.db.openCursor(this.txn, null);
                if (startingChangeNumber != null) {
                    this.key = new ReplicationKey(startingChangeNumber);
                    this.data = new DatabaseEntry();
                    if (this.cursor.getSearchKey(this.key, this.data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                        if (this.cursor.getSearchKeyRange(this.key, this.data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                            throw new Exception("ChangeNumber not available");
                        }
                        DatabaseEntry key = new DatabaseEntry();
                        DatabaseEntry data = new DatabaseEntry();
                        if (this.cursor.getPrev(key, data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                            ReplicationDB.this.closeLockedCursor(this.cursor);
                            ReplicationDB.this.dbCloseLock.readLock().lock();
                            this.cursor = ReplicationDB.this.db.openCursor(this.txn, null);
                        }
                    }
                }
            }
            catch (Exception e) {
                ReplicationDB.this.closeLockedCursor(this.cursor);
                throw e;
            }
        }

        private ReplServerDBCursor() throws DatabaseException {
            try {
                ReplicationDB.this.dbCloseLock.readLock().lock();
                this.txn = ReplicationDB.this.dbenv.beginTransaction();
                this.cursor = ReplicationDB.this.db.openCursor(this.txn, null);
            }
            catch (DatabaseException e) {
                if (this.txn != null) {
                    try {
                        this.txn.abort();
                    }
                    catch (DatabaseException databaseException) {
                        // empty catch block
                    }
                }
                ReplicationDB.this.closeLockedCursor(this.cursor);
                throw e;
            }
        }

        public void close() {
            MessageBuilder mb;
            try {
                ReplicationDB.this.closeLockedCursor(this.cursor);
                this.cursor = null;
            }
            catch (DatabaseException e) {
                mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                mb.append(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(mb.toMessage());
                ReplicationDB.this.replicationServer.shutdown();
            }
            if (this.txn != null) {
                try {
                    this.txn.commit();
                }
                catch (DatabaseException e) {
                    mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                    mb.append(StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(mb.toMessage());
                    ReplicationDB.this.replicationServer.shutdown();
                }
            }
        }

        public void abort() {
            MessageBuilder mb;
            if (this.cursor == null) {
                return;
            }
            try {
                ReplicationDB.this.closeLockedCursor(this.cursor);
                this.cursor = null;
            }
            catch (DeadlockException e1) {
            }
            catch (DatabaseException e) {
                mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                mb.append(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(mb.toMessage());
                ReplicationDB.this.replicationServer.shutdown();
            }
            if (this.txn != null) {
                try {
                    this.txn.abort();
                }
                catch (DatabaseException e) {
                    mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_CHANGELOG_SHUTDOWN_DATABASE_ERROR.get());
                    mb.append(StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(mb.toMessage());
                    ReplicationDB.this.replicationServer.shutdown();
                }
            }
        }

        public ChangeNumber nextChangeNumber() throws DatabaseException {
            OperationStatus status = this.cursor.getNext(this.key, this.data, LockMode.DEFAULT);
            if (status != OperationStatus.SUCCESS) {
                return null;
            }
            try {
                String csnString = new String(this.key.getData(), "UTF-8");
                return new ChangeNumber(csnString);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }

        public UpdateMessage next() {
            UpdateMessage currentChange = null;
            while (currentChange == null) {
                try {
                    OperationStatus status = this.cursor.getNext(this.key, this.data, LockMode.DEFAULT);
                    if (status != OperationStatus.SUCCESS) {
                        return null;
                    }
                }
                catch (DatabaseException e) {
                    return null;
                }
                try {
                    currentChange = ReplicationData.generateChange(this.data.getData());
                }
                catch (Exception exception) {}
            }
            return currentChange;
        }

        public void delete() throws DatabaseException {
            this.cursor.delete();
        }
    }
}

