/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.io.UnsupportedEncodingException;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.server.DbHandler;
import org.opends.server.replication.server.ReplicationDBException;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;

public class ReplicationDbEnv {
    private Environment dbEnvironment = null;
    private Database stateDb = null;
    private ReplicationServer replicationServer = null;
    private static final String GENERATION_ID_TAG = "GENID";
    private static final String FIELD_SEPARATOR = " ";
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public ReplicationDbEnv(String path, ReplicationServer replicationServer) throws DatabaseException, ReplicationDBException {
        this.replicationServer = replicationServer;
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        envConfig.setConfigParam("je.cleaner.expunge", "true");
        envConfig.setConfigParam("je.maxMemory", "5000000");
        this.dbEnvironment = new Environment(new File(path), envConfig);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(true);
        this.stateDb = this.dbEnvironment.openDatabase(null, "changelogstate", dbConfig);
        this.start();
    }

    private void start() throws DatabaseException, ReplicationDBException {
        Cursor cursor = this.stateDb.openCursor(null, null);
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        try {
            String[] str;
            String stringData;
            OperationStatus status = cursor.getFirst(key, data, LockMode.DEFAULT);
            while (status == OperationStatus.SUCCESS) {
                block21: {
                    try {
                        stringData = new String(data.getData(), "UTF-8");
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " Read tag baseDn generationId=" + stringData);
                        }
                        if (!(str = stringData.split(FIELD_SEPARATOR, 3))[0].equals(GENERATION_ID_TAG)) break block21;
                        long generationId = -1L;
                        try {
                            generationId = new Long(str[1]);
                        }
                        catch (NumberFormatException e) {
                            throw new ReplicationDBException(Message.raw("replicationServer state database has a wrong format: " + e.getLocalizedMessage() + "<" + str[1] + ">", new Object[0]));
                        }
                        DN baseDn = null;
                        try {
                            baseDn = DN.decode(str[2]);
                        }
                        catch (DirectoryException e) {
                            Message message = ReplicationMessages.ERR_IGNORE_BAD_DN_IN_DATABASE_IDENTIFIER.get(str[1]);
                            ErrorLogger.logError(message);
                        }
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " Has read baseDn=" + baseDn + " generationId=" + generationId);
                        }
                        this.replicationServer.getReplicationServerDomain(baseDn, true).setGenerationId(generationId, true);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new ReplicationDBException(Message.raw("need UTF-8 support", new Object[0]));
                    }
                }
                status = cursor.getNext(key, data, LockMode.DEFAULT);
            }
            status = cursor.getFirst(key, data, LockMode.DEFAULT);
            while (status == OperationStatus.SUCCESS) {
                stringData = null;
                try {
                    stringData = new String(data.getData(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new ReplicationDBException(Message.raw("need UTF-8 support", new Object[0]));
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " Read serverId BaseDN=" + stringData);
                }
                if (!(str = stringData.split(FIELD_SEPARATOR, 2))[0].equals(GENERATION_ID_TAG)) {
                    short serverId = -1;
                    try {
                        serverId = new Short(str[0]);
                    }
                    catch (NumberFormatException e) {
                        throw new ReplicationDBException(Message.raw("replicationServer state database has a wrong format: " + e.getLocalizedMessage() + "<" + str[0] + ">", new Object[0]));
                    }
                    DN baseDn = null;
                    try {
                        baseDn = DN.decode(str[1]);
                    }
                    catch (DirectoryException e) {
                        Message message = ReplicationMessages.ERR_IGNORE_BAD_DN_IN_DATABASE_IDENTIFIER.get(str[1]);
                        ErrorLogger.logError(message);
                    }
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " Has read: baseDn=" + baseDn + " serverId=" + serverId);
                    }
                    DbHandler dbHandler = new DbHandler(serverId, baseDn, this.replicationServer, this);
                    this.replicationServer.getReplicationServerDomain(baseDn, true).setDbHandler(serverId, dbHandler);
                }
                status = cursor.getNext(key, data, LockMode.DEFAULT);
            }
            cursor.close();
        }
        catch (DatabaseException dbe) {
            cursor.close();
            throw dbe;
        }
    }

    public Database getOrAddDb(Short serverId, DN baseDn, Long generationId) throws DatabaseException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("ReplicationDbEnv.getOrAddDb() " + serverId + FIELD_SEPARATOR + baseDn + FIELD_SEPARATOR + generationId);
        }
        try {
            String stringId = serverId.toString() + FIELD_SEPARATOR + baseDn.toNormalizedString();
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(true);
            Database db = this.dbEnvironment.openDatabase(null, stringId, dbConfig);
            byte[] byteId = stringId.getBytes("UTF-8");
            DatabaseEntry key = new DatabaseEntry();
            key.setData(byteId);
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.stateDb.get(null, key, data, LockMode.DEFAULT);
            if (status == OperationStatus.NOTFOUND) {
                Transaction txn = this.dbEnvironment.beginTransaction(null, null);
                try {
                    data.setData(byteId);
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("getOrAddDb() Created in the state Db record  serverId/Domain=<" + stringId + ">");
                    }
                    this.stateDb.put(txn, key, data);
                    txn.commitWriteNoSync();
                }
                catch (DatabaseException dbe) {
                    txn.abort();
                    throw dbe;
                }
            }
            stringId = "GENID " + baseDn.toNormalizedString();
            String dataStringId = "GENID " + generationId.toString() + FIELD_SEPARATOR + baseDn.toNormalizedString();
            byteId = stringId.getBytes("UTF-8");
            byte[] dataByteId = dataStringId.getBytes("UTF-8");
            key = new DatabaseEntry();
            key.setData(byteId);
            data = new DatabaseEntry();
            status = this.stateDb.get(null, key, data, LockMode.DEFAULT);
            if (status == OperationStatus.NOTFOUND) {
                Transaction txn = this.dbEnvironment.beginTransaction(null, null);
                try {
                    data.setData(dataByteId);
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Created in the state Db record Tag/Domain/GenId key=" + stringId + " value=" + dataStringId);
                    }
                    this.stateDb.put(txn, key, data);
                    txn.commitWriteNoSync();
                }
                catch (DatabaseException dbe) {
                    txn.abort();
                    throw dbe;
                }
            }
            return db;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public Transaction beginTransaction() throws DatabaseException {
        return this.dbEnvironment.beginTransaction(null, null);
    }

    public void shutdown() {
        try {
            this.stateDb.close();
            this.dbEnvironment.close();
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_ERROR_CLOSING_CHANGELOG_ENV.get());
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
        }
    }

    public void clearGenerationId(DN baseDn) {
        block9: {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " clearGenerationId " + baseDn);
            }
            try {
                String stringId = "GENID " + baseDn.toNormalizedString();
                byte[] byteId = stringId.getBytes("UTF-8");
                DatabaseEntry key = new DatabaseEntry();
                key.setData(byteId);
                DatabaseEntry data = new DatabaseEntry();
                OperationStatus status = this.stateDb.get(null, key, data, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS || status == OperationStatus.KEYEXIST) {
                    Transaction txn = this.dbEnvironment.beginTransaction(null, null);
                    try {
                        this.stateDb.delete(txn, key);
                        txn.commitWriteNoSync();
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " clearGenerationId (" + baseDn + ") succeeded.");
                        }
                        break block9;
                    }
                    catch (DatabaseException dbe) {
                        txn.abort();
                        throw dbe;
                    }
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + " clearGenerationId (" + baseDn + " failed" + status.toString());
                }
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
    }

    public void clearServerId(DN baseDn, Short serverId) {
        block7: {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("In " + this.replicationServer.getMonitorInstanceName() + "clearServerId(baseDN=" + baseDn + ", serverId=" + serverId);
            }
            try {
                String stringId = serverId.toString() + FIELD_SEPARATOR + baseDn.toNormalizedString();
                byte[] byteId = stringId.getBytes("UTF-8");
                DatabaseEntry key = new DatabaseEntry();
                key.setData(byteId);
                DatabaseEntry data = new DatabaseEntry();
                OperationStatus status = this.stateDb.get(null, key, data, LockMode.DEFAULT);
                if (status == OperationStatus.NOTFOUND) break block7;
                Transaction txn = this.dbEnvironment.beginTransaction(null, null);
                try {
                    data.setData(byteId);
                    this.stateDb.delete(txn, key);
                    txn.commitWriteNoSync();
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo(" In " + this.replicationServer.getMonitorInstanceName() + " clearServerId() succeeded " + baseDn + FIELD_SEPARATOR + serverId);
                    }
                }
                catch (DatabaseException dbe) {
                    txn.abort();
                    throw dbe;
                }
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearDb(String databaseName) {
        Transaction txn = null;
        try {
            txn = this.dbEnvironment.beginTransaction(null, null);
            this.dbEnvironment.truncateDatabase(txn, databaseName, false);
            txn.commitWriteNoSync();
            txn = null;
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_ERROR_CLEARING_DB.get(databaseName, e.getMessage() + FIELD_SEPARATOR + StaticUtils.stackTraceToSingleLineString(e)));
            ErrorLogger.logError(mb.toMessage());
        }
        finally {
            try {
                if (txn != null) {
                    txn.abort();
                }
            }
            catch (Exception exception) {}
        }
    }
}

