/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.OrderingMatchingRuleCfg;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

public class CaseIgnoreOrderingMatchingRule
extends OrderingMatchingRule {
    private static final long serialVersionUID = -8992263058903266096L;

    public void initializeMatchingRule(OrderingMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "caseIgnoreOrderingMatch";
    }

    public String getOID() {
        return "2.5.13.3";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.15";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.toLowerCase(value.value(), buffer, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return new ASN1OctetString();
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            if (buffer.charAt(pos) != ' ' || buffer.charAt(pos - 1) != ' ') continue;
            buffer.delete(pos, pos + 1);
        }
        return new ASN1OctetString(buffer.toString());
    }

    public int compareValues(ByteString value1, ByteString value2) {
        return this.compare(value1.value(), value2.value());
    }

    public int compare(byte[] b1, byte[] b2) {
        int minLength = Math.min(b1.length, b2.length);
        for (int i = 0; i < minLength; ++i) {
            if (b1[i] == b2[i]) continue;
            if (b1[i] < b2[i]) {
                return -1;
            }
            if (b1[i] <= b2[i]) continue;
            return 1;
        }
        if (b1.length == b2.length) {
            return 0;
        }
        if (b1.length < b2.length) {
            return -1;
        }
        return 1;
    }
}

