/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.TaskMessages;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.plugin.ReplicationDomain;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;

public class InitializeTask
extends Task {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    boolean isCompressed = false;
    boolean isEncrypted = false;
    boolean skipSchemaValidation = false;
    String domainString = null;
    short source;
    ReplicationDomain domain = null;
    TaskState initState;
    long total = 0L;
    long left = 0L;
    private Message initTaskError = null;

    public Message getDisplayName() {
        return TaskMessages.INFO_TASK_INITIALIZE_NAME.get();
    }

    public void initializeTask() throws DirectoryException {
        if (TaskState.isDone(this.getTaskState())) {
            return;
        }
        Entry taskEntry = this.getTaskEntry();
        AttributeType typeDomainBase = DirectoryServer.getAttributeType("ds-task-initialize-domain-dn", true);
        AttributeType typeSourceScope = DirectoryServer.getAttributeType("ds-task-initialize-replica-server-id", true);
        List<Attribute> attrList = taskEntry.getAttribute(typeDomainBase);
        this.domainString = TaskUtils.getSingleValueString(attrList);
        DN domainDN = DN.nullDN();
        try {
            domainDN = DN.decode(this.domainString);
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(TaskMessages.ERR_TASK_INITIALIZE_INVALID_DN.get());
            mb.append(e.getMessage());
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, mb.toMessage());
        }
        this.domain = ReplicationDomain.retrievesReplicationDomain(domainDN);
        attrList = taskEntry.getAttribute(typeSourceScope);
        String sourceString = TaskUtils.getSingleValueString(attrList);
        this.source = this.domain.decodeSource(sourceString);
        this.replaceAttributeValue("ds-task-unprocessed-entry-count", String.valueOf(0));
        this.replaceAttributeValue("ds-task-processed-entry-count", String.valueOf(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskState runTask() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("InitializeTask is starting domain: %s source:%d", this.domain.getBaseDN(), this.source);
        }
        this.initState = this.getTaskState();
        try {
            this.domain.initializeFromRemote(this.source, this);
            TaskState taskState = this.initState;
            synchronized (taskState) {
                while (this.initState == TaskState.RUNNING) {
                    ((Object)((Object)this.initState)).wait(1000L);
                    this.replaceAttributeValue("ds-task-unprocessed-entry-count", String.valueOf(this.left));
                    this.replaceAttributeValue("ds-task-processed-entry-count", String.valueOf(this.total - this.left));
                }
            }
            this.replaceAttributeValue("ds-task-unprocessed-entry-count", String.valueOf(this.left));
            this.replaceAttributeValue("ds-task-processed-entry-count", String.valueOf(this.total - this.left));
        }
        catch (InterruptedException ie) {
        }
        catch (DirectoryException de) {
            this.logError(de.getMessageObject());
            this.initState = TaskState.STOPPED_BY_ERROR;
        }
        if (this.initTaskError != null) {
            this.logError(this.initTaskError);
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("InitializeTask is ending with state:%s", this.initState.toString());
        }
        return this.initState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTaskCompletionState(DirectoryException de) {
        try {
            if (de != null) {
                this.initTaskError = de.getMessageObject();
            }
            this.initState = de == null ? TaskState.COMPLETED_SUCCESSFULLY : TaskState.STOPPED_BY_ERROR;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("InitializeTask/setState: %s", new Object[]{this.initState});
            }
            TaskState taskState = this.initState;
            synchronized (taskState) {
                ((Object)((Object)this.initState)).notify();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setLeft(long left) {
        this.left = left;
    }
}

