/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordStorageSchemeConfigManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.StringArgument;

public class EncodePassword {
    public static void main(String[] args) {
        int returnCode = EncodePassword.encodePassword(args, true, System.out, System.err);
        if (returnCode != 0) {
            System.exit(StaticUtils.filterExitCode(returnCode));
        }
    }

    public static int encodePassword(String[] args) {
        return EncodePassword.encodePassword(args, true, System.out, System.err);
    }

    public static int encodePassword(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        Message message;
        String scheme;
        PasswordStorageScheme storageScheme;
        boolean compareMode;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        BooleanArgument authPasswordSyntax = null;
        BooleanArgument useCompareResultCode = null;
        BooleanArgument listSchemes = null;
        BooleanArgument showUsage = null;
        StringArgument clearPassword = null;
        FileBasedArgument clearPasswordFile = null;
        StringArgument encodedPassword = null;
        FileBasedArgument encodedPasswordFile = null;
        StringArgument configClass = null;
        StringArgument configFile = null;
        StringArgument schemeName = null;
        Message toolDescription = ToolMessages.INFO_ENCPW_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser("org.opends.server.tools.EncodePassword", toolDescription, false);
        try {
            listSchemes = new BooleanArgument("listschemes", Character.valueOf('l'), "listSchemes", ToolMessages.INFO_ENCPW_DESCRIPTION_LISTSCHEMES.get());
            argParser.addArgument(listSchemes);
            clearPassword = new StringArgument("clearpw", Character.valueOf('c'), "clearPassword", false, false, true, ToolMessages.INFO_CLEAR_PWD.get(), null, null, ToolMessages.INFO_ENCPW_DESCRIPTION_CLEAR_PW.get());
            argParser.addArgument(clearPassword);
            clearPasswordFile = new FileBasedArgument("clearpwfile", Character.valueOf('f'), "clearPasswordFile", false, false, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_ENCPW_DESCRIPTION_CLEAR_PW_FILE.get());
            argParser.addArgument(clearPasswordFile);
            encodedPassword = new StringArgument("encodedpw", Character.valueOf('e'), "encodedPassword", false, false, true, ToolMessages.INFO_ENCODED_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_ENCPW_DESCRIPTION_ENCODED_PW.get());
            argParser.addArgument(encodedPassword);
            encodedPasswordFile = new FileBasedArgument("encodedpwfile", Character.valueOf('E'), "encodedPasswordFile", false, false, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_ENCPW_DESCRIPTION_ENCODED_PW_FILE.get());
            argParser.addArgument(encodedPasswordFile);
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            configFile = new StringArgument("configfile", Character.valueOf('F'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            schemeName = new StringArgument("scheme", Character.valueOf('s'), "storageScheme", false, false, true, ToolMessages.INFO_STORAGE_SCHEME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_ENCPW_DESCRIPTION_SCHEME.get());
            argParser.addArgument(schemeName);
            authPasswordSyntax = new BooleanArgument("authpasswordsyntax", Character.valueOf('a'), "authPasswordSyntax", ToolMessages.INFO_ENCPW_DESCRIPTION_AUTHPW.get());
            argParser.addArgument(authPasswordSyntax);
            useCompareResultCode = new BooleanArgument("usecompareresultcode", Character.valueOf('r'), "useCompareResultCode", ToolMessages.INFO_ENCPW_DESCRIPTION_USE_COMPARE_RESULT.get());
            argParser.addArgument(useCompareResultCode);
            showUsage = new BooleanArgument("usage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            Message message2 = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message3 = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (clearPassword.isPresent() && clearPasswordFile.isPresent()) {
            Message message4 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(clearPassword.getLongIdentifier(), clearPasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (encodedPassword.isPresent() && encodedPasswordFile.isPresent()) {
            Message message5 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(encodedPassword.getLongIdentifier(), encodedPasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        ASN1OctetString clearPW = null;
        if (!listSchemes.isPresent()) {
            if (clearPassword.hasValue()) {
                clearPW = new ASN1OctetString(clearPassword.getValue());
            } else if (clearPasswordFile.hasValue()) {
                clearPW = new ASN1OctetString(clearPasswordFile.getValue());
            } else {
                Message message6 = ToolMessages.ERR_ENCPW_NO_CLEAR_PW.get(clearPassword.getLongIdentifier(), clearPasswordFile.getLongIdentifier());
                err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 1;
            }
            if (!(encodedPassword.isPresent() || encodedPasswordFile.isPresent() || schemeName.isPresent())) {
                Message message7 = ToolMessages.ERR_ENCPW_NO_SCHEME.get(schemeName.getLongIdentifier());
                err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 1;
            }
        }
        ByteString encodedPW = null;
        if (encodedPassword.hasValue()) {
            compareMode = true;
            encodedPW = new ASN1OctetString(encodedPassword.getValue());
        } else if (encodedPasswordFile.hasValue()) {
            compareMode = true;
            encodedPW = new ASN1OctetString(encodedPasswordFile.getValue());
        } else {
            compareMode = false;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            try {
                directoryServer.bootstrapClient();
                directoryServer.initializeJMX();
            }
            catch (Exception e) {
                Message message8 = ToolMessages.ERR_SERVER_BOOTSTRAP_ERROR.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
            }
            catch (InitializationException ie) {
                Message message9 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message10 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                Message message11 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message12 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message13 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager();
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException ce) {
                Message message14 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message15 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message16 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message16, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                PasswordStorageSchemeConfigManager storageSchemeConfigManager = new PasswordStorageSchemeConfigManager();
                storageSchemeConfigManager.initializePasswordStorageSchemes();
            }
            catch (ConfigException ce) {
                Message message17 = ToolMessages.ERR_ENCPW_CANNOT_INITIALIZE_STORAGE_SCHEMES.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message17, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message18 = ToolMessages.ERR_ENCPW_CANNOT_INITIALIZE_STORAGE_SCHEMES.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message18, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message19 = ToolMessages.ERR_ENCPW_CANNOT_INITIALIZE_STORAGE_SCHEMES.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message19, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (listSchemes.isPresent()) {
            ConcurrentHashMap<String, PasswordStorageScheme> storageSchemes;
            if (authPasswordSyntax.isPresent()) {
                storageSchemes = DirectoryServer.getAuthPasswordStorageSchemes();
                if (storageSchemes.isEmpty()) {
                    Message message20 = ToolMessages.ERR_ENCPW_NO_STORAGE_SCHEMES.get();
                    err.println(StaticUtils.wrapText(message20, ServerConstants.MAX_LINE_WIDTH));
                } else {
                    int size = storageSchemes.size();
                    ArrayList<String> nameList = new ArrayList<String>(size);
                    for (PasswordStorageScheme s : storageSchemes.values()) {
                        nameList.add(s.getAuthPasswordSchemeName());
                    }
                    Object[] nameArray = new String[size];
                    nameList.toArray(nameArray);
                    Arrays.sort(nameArray);
                    for (Object storageSchemeName : nameArray) {
                        out.println((String)storageSchemeName);
                    }
                }
                return 0;
            }
            storageSchemes = DirectoryServer.getPasswordStorageSchemes();
            if (storageSchemes.isEmpty()) {
                Message message21 = ToolMessages.ERR_ENCPW_NO_STORAGE_SCHEMES.get();
                err.println(StaticUtils.wrapText(message21, ServerConstants.MAX_LINE_WIDTH));
            } else {
                int size = storageSchemes.size();
                ArrayList<String> nameList = new ArrayList<String>(size);
                for (PasswordStorageScheme s : storageSchemes.values()) {
                    nameList.add(s.getStorageSchemeName());
                }
                Object[] nameArray = new String[size];
                nameList.toArray(nameArray);
                Arrays.sort(nameArray);
                for (Object storageSchemeName : nameArray) {
                    out.println((String)storageSchemeName);
                }
            }
            return 0;
        }
        if (compareMode) {
            Message message22;
            String encodedPWString;
            block75: {
                if (authPasswordSyntax.isPresent()) {
                    String authValue;
                    String authInfo;
                    String scheme2;
                    try {
                        StringBuilder[] authPWElements = AuthPasswordSyntax.decodeAuthPassword(encodedPW.stringValue());
                        scheme2 = authPWElements[0].toString();
                        authInfo = authPWElements[1].toString();
                        authValue = authPWElements[2].toString();
                    }
                    catch (DirectoryException de) {
                        Message message23 = ToolMessages.ERR_ENCPW_INVALID_ENCODED_AUTHPW.get(de.getMessageObject());
                        err.println(StaticUtils.wrapText(message23, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    catch (Exception e) {
                        Message message24 = ToolMessages.ERR_ENCPW_INVALID_ENCODED_AUTHPW.get(String.valueOf(e));
                        err.println(StaticUtils.wrapText(message24, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    PasswordStorageScheme storageScheme2 = DirectoryServer.getAuthPasswordStorageScheme(scheme2);
                    if (storageScheme2 == null) {
                        Message message25 = ToolMessages.ERR_ENCPW_NO_SUCH_AUTH_SCHEME.get(scheme2);
                        err.println(StaticUtils.wrapText(message25, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    if (storageScheme2.authPasswordMatches(clearPW, authInfo, authValue)) {
                        Message message26 = ToolMessages.INFO_ENCPW_PASSWORDS_MATCH.get();
                        out.println(message26);
                        if (useCompareResultCode.isPresent()) {
                            return 6;
                        }
                        return 0;
                    }
                    Message message27 = ToolMessages.INFO_ENCPW_PASSWORDS_DO_NOT_MATCH.get();
                    out.println(message27);
                    if (useCompareResultCode.isPresent()) {
                        return 5;
                    }
                    return 0;
                }
                if (UserPasswordSyntax.isEncoded(encodedPW)) {
                    try {
                        String[] userPWElements = UserPasswordSyntax.decodeUserPassword(encodedPW.stringValue());
                        encodedPWString = userPWElements[1];
                        storageScheme = DirectoryServer.getPasswordStorageScheme(userPWElements[0]);
                        if (storageScheme == null) {
                            Message message28 = ToolMessages.ERR_ENCPW_NO_SUCH_SCHEME.get(userPWElements[0]);
                            err.println(StaticUtils.wrapText(message28, ServerConstants.MAX_LINE_WIDTH));
                            return 1;
                        }
                        break block75;
                    }
                    catch (DirectoryException de) {
                        Message message29 = ToolMessages.ERR_ENCPW_INVALID_ENCODED_USERPW.get(de.getMessageObject());
                        err.println(StaticUtils.wrapText(message29, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    catch (Exception e) {
                        Message message30 = ToolMessages.ERR_ENCPW_INVALID_ENCODED_USERPW.get(String.valueOf(e));
                        err.println(StaticUtils.wrapText(message30, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                }
                if (!schemeName.isPresent()) {
                    Message message31 = ToolMessages.ERR_ENCPW_NO_SCHEME.get(schemeName.getLongIdentifier());
                    err.println(StaticUtils.wrapText(message31, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                encodedPWString = ((Object)encodedPW).toString();
                String scheme3 = StaticUtils.toLowerCase(schemeName.getValue());
                storageScheme = DirectoryServer.getPasswordStorageScheme(scheme3);
                if (storageScheme == null) {
                    Message message32 = ToolMessages.ERR_ENCPW_NO_SUCH_SCHEME.get(scheme3);
                    err.println(StaticUtils.wrapText(message32, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            }
            if (storageScheme.passwordMatches(clearPW, new ASN1OctetString(encodedPWString))) {
                message22 = ToolMessages.INFO_ENCPW_PASSWORDS_MATCH.get();
                out.println(message22);
                if (useCompareResultCode.isPresent()) {
                    return 6;
                }
                return 0;
            }
            message22 = ToolMessages.INFO_ENCPW_PASSWORDS_DO_NOT_MATCH.get();
            out.println(message22);
            if (useCompareResultCode.isPresent()) {
                return 5;
            }
            return 0;
        }
        if (authPasswordSyntax.isPresent()) {
            scheme = schemeName.getValue();
            storageScheme = DirectoryServer.getAuthPasswordStorageScheme(scheme);
            if (storageScheme == null) {
                Message message33 = ToolMessages.ERR_ENCPW_NO_SUCH_AUTH_SCHEME.get(scheme);
                err.println(StaticUtils.wrapText(message33, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        } else {
            scheme = StaticUtils.toLowerCase(schemeName.getValue());
            storageScheme = DirectoryServer.getPasswordStorageScheme(scheme);
            if (storageScheme == null) {
                Message message34 = ToolMessages.ERR_ENCPW_NO_SUCH_SCHEME.get(scheme);
                err.println(StaticUtils.wrapText(message34, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (authPasswordSyntax.isPresent()) {
            try {
                encodedPW = storageScheme.encodeAuthPassword(clearPW);
                message = ToolMessages.ERR_ENCPW_ENCODED_PASSWORD.get(encodedPW.stringValue());
                out.println(message);
            }
            catch (DirectoryException de) {
                Message message35 = ToolMessages.ERR_ENCPW_CANNOT_ENCODE.get(de.getMessageObject());
                err.println(StaticUtils.wrapText(message35, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message36 = ToolMessages.ERR_ENCPW_CANNOT_ENCODE.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message36, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        try {
            encodedPW = storageScheme.encodePasswordWithScheme(clearPW);
            message = ToolMessages.ERR_ENCPW_ENCODED_PASSWORD.get(encodedPW.stringValue());
            out.println(message);
        }
        catch (DirectoryException de) {
            Message message37 = ToolMessages.ERR_ENCPW_CANNOT_ENCODE.get(de.getMessageObject());
            err.println(StaticUtils.wrapText(message37, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        catch (Exception e) {
            Message message38 = ToolMessages.ERR_ENCPW_CANNOT_ENCODE.get(StaticUtils.getExceptionMessage(e));
            err.println(StaticUtils.wrapText(message38, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        return 0;
    }
}

