/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.opends.messages.ToolMessages;
import org.opends.server.extensions.BlindTrustManagerProvider;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.tools.PromptTrustManager;
import org.opends.server.tools.SSLConnectionException;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.ExpirationCheckTrustManager;
import org.opends.server.util.SelectableCertificateKeyManager;

public class SSLConnectionFactory {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private SSLSocketFactory sslSocketFactory = null;

    public void init(boolean trustAll, String keyStorePath, String keyStorePassword, String clientAlias, String trustStorePath, String trustStorePassword) throws SSLConnectionException {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            KeyManager[] keyManagers = null;
            TrustManager[] trustManagers = null;
            if (trustAll) {
                BlindTrustManagerProvider blindTrustProvider = new BlindTrustManagerProvider();
                trustManagers = blindTrustProvider.getTrustManagers();
            } else if (trustStorePath == null) {
                trustManagers = PromptTrustManager.getTrustManagers();
            } else {
                TrustManager[] tmpTrustManagers = this.getTrustManagers(KeyStore.getDefaultType(), null, trustStorePath, trustStorePassword);
                trustManagers = new TrustManager[tmpTrustManagers.length];
                for (int i = 0; i < trustManagers.length; ++i) {
                    trustManagers[i] = new ExpirationCheckTrustManager((X509TrustManager)tmpTrustManagers[i]);
                }
            }
            if (keyStorePath != null) {
                keyManagers = this.getKeyManagers(KeyStore.getDefaultType(), null, keyStorePath, keyStorePassword);
                if (clientAlias != null) {
                    keyManagers = SelectableCertificateKeyManager.wrap(keyManagers, clientAlias);
                }
            }
            ctx.init(keyManagers, trustManagers, new SecureRandom());
            this.sslSocketFactory = ctx.getSocketFactory();
        }
        catch (Exception e) {
            throw new SSLConnectionException(ToolMessages.ERR_TOOLS_CANNOT_CREATE_SSL_CONNECTION.get(e.getMessage()), (Throwable)e);
        }
    }

    public Socket createSocket(String hostName, int portNumber) throws SSLConnectionException, IOException {
        if (this.sslSocketFactory == null) {
            throw new SSLConnectionException(ToolMessages.ERR_TOOLS_SSL_CONNECTION_NOT_INITIALIZED.get());
        }
        return this.sslSocketFactory.createSocket(hostName, portNumber);
    }

    public Socket createSocket(Socket s, String hostName, int portNumber, boolean autoClose) throws SSLConnectionException, IOException {
        if (this.sslSocketFactory == null) {
            throw new SSLConnectionException(ToolMessages.ERR_TOOLS_SSL_CONNECTION_NOT_INITIALIZED.get());
        }
        return this.sslSocketFactory.createSocket(s, hostName, portNumber, autoClose);
    }

    private KeyManager[] getKeyManagers(String keyStoreType, Provider provider, String keyStoreFile, String keyStorePass) throws KeyStoreException, SSLConnectionException {
        if (keyStoreFile == null) {
            keyStoreFile = this.getKeyStore();
        }
        if (keyStorePass == null) {
            keyStorePass = this.getKeyStorePIN();
        }
        KeyStore ks = null;
        ks = provider != null ? KeyStore.getInstance(keyStoreType, provider) : KeyStore.getInstance(keyStoreType);
        char[] keyStorePIN = null;
        if (keyStorePass != null) {
            keyStorePIN = keyStorePass.toCharArray();
        }
        try {
            FileInputStream inputStream = new FileInputStream(keyStoreFile);
            ks.load(inputStream, keyStorePIN);
            inputStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new SSLConnectionException(ToolMessages.ERR_TOOLS_CANNOT_LOAD_KEYSTORE_FILE.get(keyStoreFile), (Throwable)e);
        }
        try {
            String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
            keyManagerFactory.init(ks, keyStorePIN);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception ke) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ke);
            }
            throw new SSLConnectionException(ToolMessages.ERR_TOOLS_CANNOT_INIT_KEYMANAGER.get(keyStoreFile), (Throwable)ke);
        }
    }

    private TrustManager[] getTrustManagers(String trustStoreType, Provider provider, String trustStoreFile, String trustStorePass) throws KeyStoreException, SSLConnectionException {
        if (trustStoreFile == null && (trustStoreFile = this.getTrustStore()) == null) {
            return null;
        }
        if (trustStorePass == null) {
            trustStorePass = this.getTrustStorePIN();
        }
        KeyStore trustStore = null;
        trustStore = provider != null ? KeyStore.getInstance(trustStoreType, provider) : KeyStore.getInstance(trustStoreType);
        char[] trustStorePIN = null;
        if (trustStorePass != null) {
            trustStorePIN = trustStorePass.toCharArray();
        }
        try {
            FileInputStream inputStream = new FileInputStream(trustStoreFile);
            trustStore.load(inputStream, trustStorePIN);
            inputStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new SSLConnectionException(ToolMessages.ERR_TOOLS_CANNOT_LOAD_TRUSTSTORE_FILE.get(trustStoreFile), (Throwable)e);
        }
        try {
            String trustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerAlgorithm);
            trustManagerFactory.init(trustStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception ke) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ke);
            }
            throw new SSLConnectionException(ToolMessages.ERR_TOOLS_CANNOT_INIT_TRUSTMANAGER.get(trustStoreFile), (Throwable)ke);
        }
    }

    private String getKeyStorePIN() {
        return System.getProperty("javax.net.ssl.keyStorePassword");
    }

    private String getTrustStorePIN() {
        return System.getProperty("javax.net.ssl.trustStorePassword");
    }

    private String getKeyStore() {
        return System.getProperty("javax.net.ssl.keyStore");
    }

    private String getTrustStore() {
        return System.getProperty("javax.net.ssl.trustStore");
    }
}

