/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.util.List;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ManagementContextFactory;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.MenuResult;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DeleteSubCommandHandler
extends SubCommandHandler {
    private static final String OPTION_DSCFG_LONG_FORCE = "force";
    private static final char OPTION_DSCFG_SHORT_FORCE = 'f';
    private final BooleanArgument forceArgument;
    private final List<StringArgument> namingArgs;
    private final ManagedObjectPath<?, ?> path;
    private final RelationDefinition<?, ?> relation;
    private final SubCommand subCommand;

    public static DeleteSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, InstantiableRelationDefinition<?, ?> r) throws ArgumentException {
        return new DeleteSubCommandHandler(parser, p, r, p.child(r, "DUMMY"));
    }

    public static DeleteSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, OptionalRelationDefinition<?, ?> r) throws ArgumentException {
        return new DeleteSubCommandHandler(parser, p, r, p.child(r));
    }

    private DeleteSubCommandHandler(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, RelationDefinition<?, ?> r, ManagedObjectPath<?, ?> c) throws ArgumentException {
        this.path = p;
        this.relation = r;
        String name = "delete-" + r.getName();
        Message ufpn = r.getChildDefinition().getUserFriendlyPluralName();
        Message description = DSConfigMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_DELETE.get(ufpn);
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, description);
        this.namingArgs = this.createNamingArgs(this.subCommand, c, false);
        this.forceArgument = new BooleanArgument(OPTION_DSCFG_LONG_FORCE, Character.valueOf('f'), OPTION_DSCFG_LONG_FORCE, DSConfigMessages.INFO_DSCFG_DESCRIPTION_FORCE.get(ufpn));
        this.subCommand.addArgument(this.forceArgument);
        this.addTags(this.relation.getChildDefinition().getAllTags());
    }

    public RelationDefinition<?, ?> getRelationDefinition() {
        return this.relation;
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public MenuResult<Integer> run(ConsoleApplication app, ManagementContextFactory factory) throws ArgumentException, ClientException, CLIException {
        Message ufn;
        block28: {
            MenuResult<ManagedObject<?>> result;
            List<String> names = this.getNamingArgValues(app, this.namingArgs);
            this.getCommandBuilder().clearArguments();
            this.setCommandBuilderUseful(false);
            ManagementContext context = factory.getManagementContext(app);
            ufn = this.relation.getUserFriendlyName();
            try {
                result = this.getManagedObject(app, context, this.path, names);
            }
            catch (AuthorizationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_DELETE_AUTHZ.get(ufn);
                throw new ClientException(50, msg);
            }
            catch (DefinitionDecodingException e) {
                Message pufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_PARENT_DDE.get(pufn, pufn, pufn);
                throw new ClientException(80, msg);
            }
            catch (ManagedObjectDecodingException e) {
                Message pufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MODE.get(pufn);
                throw new ClientException(80, msg, e);
            }
            catch (CommunicationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_DELETE_CE.get(ufn, e.getMessage());
                throw new ClientException(81, msg);
            }
            catch (ConcurrentModificationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_DELETE_CME.get(ufn);
                throw new ClientException(19, msg);
            }
            catch (ManagedObjectNotFoundException e) {
                if (!this.forceArgument.isPresent()) {
                    Message pufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                    Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MONFE.get(pufn);
                    throw new ClientException(32, msg);
                }
                return MenuResult.success(0);
            }
            if (result.isQuit()) {
                if (!app.isMenuDrivenMode()) {
                    Message msg = DSConfigMessages.INFO_DSCFG_CONFIRM_DELETE_FAIL.get(ufn);
                    app.printVerboseMessage(msg);
                }
                return MenuResult.quit();
            }
            if (result.isCancel()) {
                return MenuResult.cancel();
            }
            ManagedObject<?> parent = result.getValue();
            try {
                if (this.relation instanceof InstantiableRelationDefinition) {
                    InstantiableRelationDefinition irelation = (InstantiableRelationDefinition)this.relation;
                    String childName = names.get(names.size() - 1);
                    if (childName == null) {
                        MenuResult<String> sresult = this.readChildName(app, parent, irelation, null);
                        if (sresult.isQuit()) {
                            if (!app.isMenuDrivenMode()) {
                                Message msg = DSConfigMessages.INFO_DSCFG_CONFIRM_DELETE_FAIL.get(ufn);
                                app.printVerboseMessage(msg);
                            }
                            return MenuResult.quit();
                        }
                        if (sresult.isCancel()) {
                            return MenuResult.cancel();
                        }
                        childName = sresult.getValue();
                    }
                    if (this.confirmDeletion(app)) {
                        this.setCommandBuilderUseful(true);
                        parent.removeChild(irelation, childName);
                        break block28;
                    }
                    return MenuResult.cancel();
                }
                if (!(this.relation instanceof OptionalRelationDefinition)) break block28;
                OptionalRelationDefinition orelation = (OptionalRelationDefinition)this.relation;
                if (this.confirmDeletion(app)) {
                    this.setCommandBuilderUseful(true);
                    parent.removeChild(orelation);
                    break block28;
                }
                return MenuResult.cancel();
            }
            catch (AuthorizationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_DELETE_AUTHZ.get(ufn);
                throw new ClientException(50, msg);
            }
            catch (OperationRejectedException e) {
                Message msg = e.getMessages().size() == 1 ? DSConfigMessages.ERR_DSCFG_ERROR_DELETE_ORE_SINGLE.get(ufn) : DSConfigMessages.ERR_DSCFG_ERROR_DELETE_ORE_PLURAL.get(ufn);
                if (app.isInteractive()) {
                    app.println();
                    app.println(msg);
                    app.println();
                    TableBuilder builder = new TableBuilder();
                    for (Message reason : e.getMessages()) {
                        builder.startRow();
                        builder.appendCell("*");
                        builder.appendCell(reason);
                    }
                    TextTablePrinter printer = new TextTablePrinter(app.getErrorStream());
                    printer.setDisplayHeadings(false);
                    printer.setColumnWidth(1, 0);
                    printer.setIndentWidth(4);
                    builder.print(printer);
                    return MenuResult.cancel();
                }
                throw new ClientException(19, msg, e);
            }
            catch (ManagedObjectNotFoundException e) {
                if (!this.forceArgument.isPresent()) {
                    Message msg = DSConfigMessages.ERR_DSCFG_ERROR_DELETE_MONFE.get(ufn);
                    throw new ClientException(32, msg);
                }
            }
            catch (ConcurrentModificationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_DELETE_CME.get(ufn);
                throw new ClientException(19, msg);
            }
            catch (CommunicationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_DELETE_CE.get(ufn, e.getMessage());
                throw new ClientException(81, msg);
            }
        }
        for (StringArgument arg : this.namingArgs) {
            if (!arg.isPresent()) continue;
            this.getCommandBuilder().addArgument(arg);
        }
        Message msg = DSConfigMessages.INFO_DSCFG_CONFIRM_DELETE_SUCCESS.get(ufn);
        app.printVerboseMessage(msg);
        return MenuResult.success(0);
    }

    private boolean confirmDeletion(ConsoleApplication app) throws CLIException {
        if (app.isInteractive()) {
            Message prompt = DSConfigMessages.INFO_DSCFG_CONFIRM_DELETE.get(this.relation.getUserFriendlyName());
            app.println();
            if (!app.confirmAction(prompt, false)) {
                Message msg = DSConfigMessages.INFO_DSCFG_CONFIRM_DELETE_FAIL.get(this.relation.getUserFriendlyName());
                app.printVerboseMessage(msg);
                return false;
            }
        }
        return true;
    }
}

